/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.util.HashMap;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.procedure2.LockAndQueue;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestLockAndQueue {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLockAndQueue.class);

    @Test
    public void testHasLockAccess() {
        long i;
        HashMap procMap = new HashMap();
        for (long i2 = 1L; i2 <= 10L; ++i2) {
            ProcedureTestingUtility.NoopProcedure proc = new ProcedureTestingUtility.NoopProcedure();
            proc.setProcId(i2);
            if (i2 > 1L) {
                proc.setParentProcId(i2 - 1L);
                proc.setRootProcId(1L);
            }
            procMap.put(i2, proc);
        }
        LockAndQueue laq = new LockAndQueue(procMap::get);
        for (i = 1L; i <= 10L; ++i) {
            Assert.assertFalse((boolean)laq.hasLockAccess((Procedure)procMap.get(i)));
        }
        for (i = 1L; i <= 10L; ++i) {
            long j;
            ProcedureTestingUtility.NoopProcedure procHasLock = (ProcedureTestingUtility.NoopProcedure)((Object)procMap.get(i));
            laq.tryExclusiveLock((Procedure)procHasLock);
            for (j = 1L; j < i; ++j) {
                Assert.assertFalse((boolean)laq.hasLockAccess((Procedure)procMap.get(j)));
            }
            for (j = i; j <= 10L; ++j) {
                Assert.assertTrue((boolean)laq.hasLockAccess((Procedure)procMap.get(j)));
            }
            laq.releaseExclusiveLock((Procedure)procHasLock);
        }
    }
}

