/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.opentelemetry.context.Scope;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayDeque;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.sasl.SaslException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.exceptions.ConnectionClosingException;
import org.apache.hadoop.hbase.io.ByteArrayOutputStream;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.Call;
import org.apache.hadoop.hbase.ipc.CallCancelledException;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.FailedServerException;
import org.apache.hadoop.hbase.ipc.FallbackDisallowedException;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcConnection;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.security.HBaseSaslRpcClient;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.SocketInputWrapper;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.buffer.PooledByteBufAllocator;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class BlockingRpcConnection
extends RpcConnection
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingRpcConnection.class);
    private final BlockingRpcClient rpcClient;
    private final String threadName;
    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="We are always under lock actually")
    private Thread thread;
    private final Object readerThreadLock = new Object();
    private final AtomicInteger attempts = new AtomicInteger();
    protected Socket socket = null;
    private DataInputStream in;
    private DataOutputStream out;
    private HBaseSaslRpcClient saslRpcClient;
    private final ConcurrentMap<Integer, Call> calls = new ConcurrentHashMap<Integer, Call>();
    private final CallSender callSender;
    private boolean closed = false;
    private byte[] connectionHeaderPreamble;
    private byte[] connectionHeaderWithLength;
    private boolean waitingConnectionHeaderResponse = false;

    BlockingRpcConnection(BlockingRpcClient rpcClient, ConnectionId remoteId) throws IOException {
        super(rpcClient.conf, AbstractRpcClient.WHEEL_TIMER, remoteId, rpcClient.clusterId, rpcClient.userProvider.isHBaseSecurityEnabled(), rpcClient.codec, rpcClient.compressor, rpcClient.cellBlockBuilder, rpcClient.metrics, rpcClient.connectionAttributes);
        this.rpcClient = rpcClient;
        this.connectionHeaderPreamble = this.getConnectionHeaderPreamble();
        RPCProtos.ConnectionHeader header = this.getConnectionHeader();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4 + header.getSerializedSize());
        DataOutputStream dos = new DataOutputStream((OutputStream)baos);
        dos.writeInt(header.getSerializedSize());
        header.writeTo((OutputStream)dos);
        assert (baos.size() == 4 + header.getSerializedSize());
        this.connectionHeaderWithLength = baos.getBuffer();
        UserGroupInformation ticket = remoteId.ticket.getUGI();
        this.threadName = "BRPC Connection (" + this.rpcClient.socketFactory.hashCode() + ") to " + remoteId.getAddress().toString() + (ticket == null ? " from an unknown user" : " from " + ticket.getUserName());
        if (this.rpcClient.conf.getBoolean("hbase.ipc.client.specificThreadForWriting", false)) {
            this.callSender = new CallSender(this.threadName, this.rpcClient.conf);
            this.callSender.start();
        } else {
            this.callSender = null;
        }
    }

    protected void setupConnection() throws IOException {
        int ioFailures = 0;
        int timeoutFailures = 0;
        while (true) {
            try {
                this.socket = this.rpcClient.socketFactory.createSocket();
                this.socket.setTcpNoDelay(this.rpcClient.isTcpNoDelay());
                this.socket.setKeepAlive(this.rpcClient.tcpKeepAlive);
                if (this.rpcClient.localAddr != null) {
                    this.socket.bind(this.rpcClient.localAddr);
                }
                InetSocketAddress remoteAddr = this.getRemoteInetAddress(this.rpcClient.metrics);
                NetUtils.connect((Socket)this.socket, (SocketAddress)remoteAddr, (int)this.rpcClient.connectTO);
                this.socket.setSoTimeout(this.rpcClient.readTO);
                return;
            }
            catch (SocketTimeoutException toe) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received exception in connection setup.\n" + StringUtils.stringifyException((Throwable)toe));
                }
                int n = timeoutFailures;
                timeoutFailures = (short)(timeoutFailures + 1);
                this.handleConnectionFailure(n, this.rpcClient.maxRetries, toe);
                continue;
            }
            catch (IOException ie) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received exception in connection setup.\n" + StringUtils.stringifyException((Throwable)ie));
                }
                int n = ioFailures;
                ioFailures = (short)(ioFailures + 1);
                this.handleConnectionFailure(n, this.rpcClient.maxRetries, ie);
                continue;
            }
            break;
        }
    }

    private void handleConnectionFailure(int curRetries, int maxRetries, IOException ioe) throws IOException {
        this.closeSocket();
        if (curRetries >= maxRetries || ExceptionUtil.isInterrupt((Throwable)ioe)) {
            throw ioe;
        }
        try {
            Thread.sleep(this.rpcClient.failureSleep);
        }
        catch (InterruptedException ie) {
            ExceptionUtil.rethrowIfInterrupt((Throwable)ie);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Retrying connect to server: " + this.remoteId.getAddress() + " after sleeping " + this.rpcClient.failureSleep + "ms. Already tried " + curRetries + " time(s).");
        }
    }

    private synchronized boolean waitForWork() {
        long waitUntil = EnvironmentEdgeManager.currentTime() + (long)this.rpcClient.minIdleTimeBeforeClose;
        while (this.thread != null) {
            if (!this.isCurrentThreadExpected()) {
                LOG.debug("Thread replaced by new connection thread. Ending waitForWork loop.");
                return false;
            }
            if (!this.calls.isEmpty()) {
                return true;
            }
            if (EnvironmentEdgeManager.currentTime() >= waitUntil) {
                this.closeConn(new IOException("idle connection closed with " + this.calls.size() + " pending request(s)"));
                return false;
            }
            try {
                this.wait(Math.min(this.rpcClient.minIdleTimeBeforeClose, 1000));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                String msg = "Interrupted while waiting for work";
                if (this.isCurrentThreadExpected()) {
                    LOG.debug(msg + ", closing connection");
                    this.closeConn(new InterruptedIOException(msg));
                } else {
                    LOG.debug(msg);
                }
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("starting");
        }
        Object object = this.readerThreadLock;
        synchronized (object) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("started");
            }
            while (this.waitForWork()) {
                this.readResponse();
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("stopped");
        }
    }

    private void disposeSasl() {
        if (this.saslRpcClient != null) {
            this.saslRpcClient.dispose();
            this.saslRpcClient = null;
        }
    }

    private boolean setupSaslConnection(InputStream in2, OutputStream out2, String serverPrincipal) throws IOException {
        if (this.metrics != null) {
            this.metrics.incrNsLookups();
        }
        this.saslRpcClient = new HBaseSaslRpcClient(this.rpcClient.conf, this.provider, (Token<? extends TokenIdentifier>)this.token, this.socket.getInetAddress(), serverPrincipal, this.rpcClient.fallbackAllowed, this.rpcClient.conf.get("hbase.rpc.protection", SaslUtil.QualityOfProtection.AUTHENTICATION.name().toLowerCase(Locale.ROOT)), this.rpcClient.conf.getBoolean(CRYPTO_AES_ENABLED_KEY, CRYPTO_AES_ENABLED_DEFAULT));
        return this.saslRpcClient.saslConnect(in2, out2);
    }

    private void handleSaslConnectionFailure(final int currRetries, final int maxRetries, final Exception ex, UserGroupInformation user, final String serverPrincipal) throws IOException, InterruptedException {
        this.closeSocket();
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException, InterruptedException {
                if (!BlockingRpcConnection.this.provider.canRetry()) {
                    LOG.warn("Exception encountered while connecting to the server " + BlockingRpcConnection.this.remoteId.getAddress(), (Throwable)ex);
                    if (ex instanceof RemoteException) {
                        throw (RemoteException)((Object)ex);
                    }
                    if (ex instanceof SaslException) {
                        String msg = "SASL authentication failed. The most likely cause is missing or invalid credentials.";
                        throw new RuntimeException(msg, ex);
                    }
                    throw new IOException(ex);
                }
                if (currRetries < maxRetries) {
                    LOG.debug("Exception encountered while connecting to the server " + BlockingRpcConnection.this.remoteId.getAddress(), (Throwable)ex);
                    BlockingRpcConnection.this.provider.relogin();
                    BlockingRpcConnection.this.disposeSasl();
                    Thread.sleep(ThreadLocalRandom.current().nextInt(BlockingRpcConnection.this.reloginMaxBackoff) + 1);
                    return null;
                }
                String msg = "Failed to initiate connection for " + UserGroupInformation.getLoginUser().getUserName() + " to " + serverPrincipal;
                throw new IOException(msg, ex);
            }
        });
    }

    private void getConnectionRegistry(InputStream inStream, OutputStream outStream, Call connectionRegistryCall) throws IOException {
        outStream.write(RpcClient.REGISTRY_PREAMBLE_HEADER);
        this.readResponse(new DataInputStream(inStream), this.calls, connectionRegistryCall, remoteExc -> {
            BlockingRpcConnection blockingRpcConnection = this;
            synchronized (blockingRpcConnection) {
                this.closeConn((IOException)((Object)remoteExc));
            }
        });
    }

    private void createStreams(InputStream inStream, OutputStream outStream) {
        this.in = new DataInputStream(new BufferedInputStream(inStream));
        this.out = new DataOutputStream(new BufferedOutputStream(outStream));
    }

    private String chooseServerPrincipal(InputStream inStream, OutputStream outStream) throws IOException {
        Set<String> serverPrincipals = this.getServerPrincipals();
        if (serverPrincipals.size() == 1) {
            return serverPrincipals.iterator().next();
        }
        Call securityPreambleCall = this.createSecurityPreambleCall((RpcCallback<Call>)((RpcCallback)r -> {}));
        outStream.write(RpcClient.SECURITY_PREAMBLE_HEADER);
        this.readResponse(new DataInputStream(inStream), this.calls, securityPreambleCall, remoteExc -> {
            BlockingRpcConnection blockingRpcConnection = this;
            synchronized (blockingRpcConnection) {
                this.closeConn((IOException)((Object)remoteExc));
            }
        });
        if (securityPreambleCall.error != null) {
            LOG.debug("Error when trying to do a security preamble call to {}", (Object)this.remoteId.address, (Object)securityPreambleCall.error);
            if (ConnectionUtils.isUnexpectedPreambleHeaderException(securityPreambleCall.error)) {
                throw securityPreambleCall.error;
            }
            if (IPCUtil.isSecurityNotEnabledException(securityPreambleCall.error)) {
                if (this.rpcClient.fallbackAllowed) {
                    return serverPrincipals.iterator().next();
                }
                throw new FallbackDisallowedException();
            }
            return this.randomSelect(serverPrincipals);
        }
        return this.chooseServerPrincipal(serverPrincipals, securityPreambleCall);
    }

    private void setupIOstreams(Call connectionRegistryCall) throws IOException {
        if (this.socket != null) {
            return;
        }
        if (this.rpcClient.failedServers.isFailedServer(this.remoteId.getAddress())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not trying to connect to " + this.remoteId.getAddress() + " this server is in the failed servers list");
            }
            throw new FailedServerException("This server is in the failed servers list: " + this.remoteId.getAddress());
        }
        try {
            OutputStream outStream;
            Object inStream;
            block15: {
                block14: {
                    boolean continueSasl;
                    String serverPrincipal;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Connecting to " + this.remoteId.getAddress());
                    }
                    int numRetries = 0;
                    int reloginMaxRetries = this.rpcClient.conf.getInt("hbase.security.relogin.maxretries", 5);
                    while (true) {
                        this.setupConnection();
                        inStream = NetUtils.getInputStream((Socket)this.socket);
                        outStream = NetUtils.getOutputStream((Socket)this.socket, (long)this.rpcClient.writeTO);
                        if (connectionRegistryCall != null) {
                            this.getConnectionRegistry((InputStream)inStream, outStream, connectionRegistryCall);
                            this.closeSocket();
                            return;
                        }
                        if (!this.useSasl) break block14;
                        UserGroupInformation ticket = this.provider.getRealUser(this.remoteId.ticket);
                        if (ticket == null) {
                            throw new FatalConnectionException("ticket/user is null");
                        }
                        serverPrincipal = this.chooseServerPrincipal((InputStream)inStream, outStream);
                        this.writeConnectionHeaderPreamble(outStream);
                        try {
                            SocketInputWrapper in2 = inStream;
                            OutputStream out2 = outStream;
                            continueSasl = (Boolean)ticket.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>((InputStream)in2, out2, serverPrincipal){
                                final /* synthetic */ InputStream val$in2;
                                final /* synthetic */ OutputStream val$out2;
                                final /* synthetic */ String val$serverPrincipal;
                                {
                                    this.val$in2 = inputStream;
                                    this.val$out2 = outputStream;
                                    this.val$serverPrincipal = string;
                                }

                                @Override
                                public Boolean run() throws IOException {
                                    return BlockingRpcConnection.this.setupSaslConnection(this.val$in2, this.val$out2, this.val$serverPrincipal);
                                }
                            });
                        }
                        catch (Exception ex) {
                            ExceptionUtil.rethrowIfInterrupt((Throwable)ex);
                            this.saslNegotiationDone(serverPrincipal, false);
                            int n = numRetries;
                            numRetries = (short)(numRetries + 1);
                            this.handleSaslConnectionFailure(n, reloginMaxRetries, ex, ticket, serverPrincipal);
                            continue;
                        }
                        break;
                    }
                    this.saslNegotiationDone(serverPrincipal, true);
                    if (continueSasl) {
                        inStream = this.saslRpcClient.getInputStream();
                        outStream = this.saslRpcClient.getOutputStream();
                    } else {
                        this.saslRpcClient = null;
                    }
                    break block15;
                }
                this.writeConnectionHeaderPreamble(outStream);
            }
            this.createStreams((InputStream)inStream, outStream);
            this.writeConnectionHeader();
            this.processResponseForConnectionHeader();
        }
        catch (Throwable t) {
            this.closeSocket();
            Object e = ExceptionUtil.asInterrupt((Throwable)t);
            if (e == null) {
                this.rpcClient.failedServers.addToFailedServers(this.remoteId.getAddress(), t);
                e = t instanceof LinkageError ? new DoNotRetryIOException(t) : (t instanceof IOException ? (IOException)t : new IOException("Could not set up IO Streams to " + this.remoteId.getAddress(), t));
            }
            throw e;
        }
        this.thread = new Thread((Runnable)this, this.threadName + " (attempt: " + this.attempts.incrementAndGet() + ")");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void writeConnectionHeaderPreamble(OutputStream out) throws IOException {
        out.write(this.connectionHeaderPreamble);
        out.flush();
    }

    private void writeConnectionHeader() throws IOException {
        boolean isCryptoAesEnable = false;
        if (this.saslRpcClient != null) {
            boolean saslEncryptionEnabled = SaslUtil.QualityOfProtection.PRIVACY.getSaslQop().equalsIgnoreCase(this.saslRpcClient.getSaslQOP());
            boolean bl = isCryptoAesEnable = saslEncryptionEnabled && this.conf.getBoolean(CRYPTO_AES_ENABLED_KEY, CRYPTO_AES_ENABLED_DEFAULT);
        }
        if (isCryptoAesEnable) {
            this.waitingConnectionHeaderResponse = true;
        }
        this.out.write(this.connectionHeaderWithLength);
        this.out.flush();
    }

    private void processResponseForConnectionHeader() throws IOException {
        if (!this.waitingConnectionHeaderResponse) {
            return;
        }
        try {
            RPCProtos.ConnectionHeaderResponse connectionHeaderResponse;
            int len = this.in.readInt();
            byte[] buff = new byte[len];
            int readSize = this.in.read(buff);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Length of response for connection header:" + readSize);
            }
            if ((connectionHeaderResponse = RPCProtos.ConnectionHeaderResponse.parseFrom((byte[])buff)).hasCryptoCipherMeta()) {
                this.negotiateCryptoAes(connectionHeaderResponse.getCryptoCipherMeta());
            }
            this.waitingConnectionHeaderResponse = false;
        }
        catch (SocketTimeoutException ste) {
            LOG.error(HBaseMarkers.FATAL, "Can't get the connection header response for rpc timeout, please check if server has the correct configuration to support the additional function.", (Throwable)ste);
            throw new IOException("Timeout while waiting connection header response", ste);
        }
    }

    private void negotiateCryptoAes(RPCProtos.CryptoCipherMeta cryptoCipherMeta) throws IOException {
        this.saslRpcClient.initCryptoCipher(cryptoCipherMeta, this.rpcClient.conf);
        this.in = new DataInputStream(new BufferedInputStream(this.saslRpcClient.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(this.saslRpcClient.getOutputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequest(Call call) throws IOException {
        ByteBuf cellBlock = null;
        try {
            cellBlock = this.rpcClient.cellBlockBuilder.buildCellBlock(this.codec, this.compressor, call.cells, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
            RPCProtos.CellBlockMeta cellBlockMeta = cellBlock != null ? RPCProtos.CellBlockMeta.newBuilder().setLength(cellBlock.readableBytes()).build() : null;
            RPCProtos.RequestHeader requestHeader = IPCUtil.buildRequestHeader(call, cellBlockMeta);
            if (call.isConnectionRegistryCall()) {
                this.setupIOstreams(call);
                return;
            }
            this.setupIOstreams(null);
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            this.calls.put(call.id, call);
            try {
                call.callStats.setRequestSizeBytes(IPCUtil.write(this.out, (Message)requestHeader, call.param, cellBlock));
            }
            catch (Throwable t) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Error while writing {}", (Object)call.toShortString(), (Object)t);
                }
                IOException e = IPCUtil.toIOE(t);
                this.closeConn(e);
                if (cellBlock != null) {
                    cellBlock.release();
                }
                return;
            }
        }
        finally {
            if (cellBlock != null) {
                cellBlock.release();
            }
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readResponse() {
        try {
            this.readResponse(this.in, this.calls, null, remoteExc -> {
                BlockingRpcConnection blockingRpcConnection = this;
                synchronized (blockingRpcConnection) {
                    this.closeConn((IOException)((Object)remoteExc));
                }
            });
        }
        catch (IOException e) {
            if (e instanceof SocketTimeoutException) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("ignored", (Throwable)e);
                }
            }
            BlockingRpcConnection blockingRpcConnection = this;
            synchronized (blockingRpcConnection) {
                if (this.isCurrentThreadExpected()) {
                    LOG.debug("Closing connection after error", (Throwable)e);
                    this.closeConn(e);
                }
            }
        }
    }

    private boolean isCurrentThreadExpected() {
        return this.thread == Thread.currentThread();
    }

    @Override
    protected synchronized void callTimeout(Call call) {
        this.calls.remove(call.id);
    }

    private void closeSocket() {
        IOUtils.closeStream((Closeable)this.out);
        IOUtils.closeStream((Closeable)this.in);
        IOUtils.closeSocket((Socket)this.socket);
        this.out = null;
        this.in = null;
        this.socket = null;
    }

    private void closeConn(IOException e) {
        if (this.thread == null) {
            return;
        }
        this.thread.interrupt();
        this.thread = null;
        this.closeSocket();
        if (this.callSender != null) {
            this.callSender.cleanup(e);
        }
        for (Call call : this.calls.values()) {
            call.setException(e);
        }
        this.calls.clear();
    }

    @Override
    public synchronized void shutdown() {
        this.closed = true;
        if (this.callSender != null) {
            this.callSender.interrupt();
        }
        this.closeConn(new IOException("connection to " + this.remoteId.getAddress() + " closed"));
    }

    @Override
    public void cleanupConnection() {
    }

    @Override
    public synchronized void sendRequest(final Call call, HBaseRpcController pcrc) throws IOException {
        pcrc.notifyOnCancel(new RpcCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(Object parameter) {
                IPCUtil.setCancelled(call);
                BlockingRpcConnection blockingRpcConnection = BlockingRpcConnection.this;
                synchronized (blockingRpcConnection) {
                    if (BlockingRpcConnection.this.callSender != null) {
                        BlockingRpcConnection.this.callSender.remove(call);
                    } else {
                        BlockingRpcConnection.this.calls.remove(call.id);
                    }
                }
            }
        }, new HBaseRpcController.CancellationCallback(){

            @Override
            public void run(boolean cancelled) throws IOException {
                if (cancelled) {
                    IPCUtil.setCancelled(call);
                    return;
                }
                BlockingRpcConnection.this.scheduleTimeoutTask(call);
                if (BlockingRpcConnection.this.callSender != null) {
                    BlockingRpcConnection.this.callSender.sendCall(call);
                } else {
                    BlockingRpcConnection.this.writeRequest(call);
                }
            }
        });
    }

    @Override
    public synchronized boolean isActive() {
        return this.thread != null;
    }

    private class CallSender
    extends Thread {
        private final Queue<Call> callsToWrite;
        private final int maxQueueSize;

        public CallSender(String name, Configuration conf) {
            int queueSize = conf.getInt("hbase.ipc.client.write.queueSize", 1000);
            this.callsToWrite = new ArrayDeque<Call>(queueSize);
            this.maxQueueSize = queueSize;
            this.setDaemon(true);
            this.setName(name + " - writer");
        }

        public void sendCall(Call call) throws IOException {
            if (this.callsToWrite.size() >= this.maxQueueSize) {
                throw new IOException("Can't add " + call.toShortString() + " to the write queue. callsToWrite.size()=" + this.callsToWrite.size());
            }
            this.callsToWrite.offer(call);
            BlockingRpcConnection.this.notifyAll();
        }

        public void remove(Call call) {
            this.callsToWrite.remove(call);
            BlockingRpcConnection.this.calls.remove(call.id);
            call.setException((IOException)((Object)new CallCancelledException(call.toShortString() + ", waitTime=" + (EnvironmentEdgeManager.currentTime() - call.getStartTime()) + ", rpcTimeout=" + call.timeout)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            BlockingRpcConnection blockingRpcConnection = BlockingRpcConnection.this;
            synchronized (blockingRpcConnection) {
                while (!BlockingRpcConnection.this.closed) {
                    if (this.callsToWrite.isEmpty()) {
                        try {
                            BlockingRpcConnection.this.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    Call call = this.callsToWrite.poll();
                    if (call.isDone()) continue;
                    try {
                        Scope scope = call.span.makeCurrent();
                        Throwable throwable = null;
                        try {
                            BlockingRpcConnection.this.writeRequest(call);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (scope == null) continue;
                            if (throwable != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            scope.close();
                        }
                    }
                    catch (IOException e) {
                        LOG.debug("call write error for {}", (Object)call.toShortString());
                        call.setException(e);
                        BlockingRpcConnection.this.closeConn(e);
                    }
                }
                return;
            }
        }

        public void cleanup(IOException e) {
            ConnectionClosingException ie = new ConnectionClosingException("Connection to " + BlockingRpcConnection.this.remoteId.getAddress() + " is closing.");
            for (Call call : this.callsToWrite) {
                call.setException(ie);
            }
            this.callsToWrite.clear();
        }
    }
}

