/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.timeline.EntityIdentifier;
import org.apache.hadoop.yarn.server.timeline.GenericObjectMapper;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.util.LeveldbUtils;
import org.apache.hadoop.yarn.server.utils.LeveldbIterator;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LeveldbTimelineStore
extends AbstractService
implements TimelineStore {
    private static final Logger LOG = LoggerFactory.getLogger(LeveldbTimelineStore.class);
    @InterfaceAudience.Private
    @VisibleForTesting
    static final String FILENAME = "leveldb-timeline-store.ldb";
    @VisibleForTesting
    static final String BACKUP_EXT = ".backup-";
    private static final byte[] START_TIME_LOOKUP_PREFIX = "k".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ENTITY_ENTRY_PREFIX = "e".getBytes(StandardCharsets.UTF_8);
    private static final byte[] INDEXED_ENTRY_PREFIX = "i".getBytes(StandardCharsets.UTF_8);
    private static final byte[] EVENTS_COLUMN = "e".getBytes(StandardCharsets.UTF_8);
    private static final byte[] PRIMARY_FILTERS_COLUMN = "f".getBytes(StandardCharsets.UTF_8);
    private static final byte[] OTHER_INFO_COLUMN = "i".getBytes(StandardCharsets.UTF_8);
    private static final byte[] RELATED_ENTITIES_COLUMN = "r".getBytes(StandardCharsets.UTF_8);
    private static final byte[] INVISIBLE_REVERSE_RELATED_ENTITIES_COLUMN = "z".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DOMAIN_ID_COLUMN = "d".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DOMAIN_ENTRY_PREFIX = "d".getBytes(StandardCharsets.UTF_8);
    private static final byte[] OWNER_LOOKUP_PREFIX = "o".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DESCRIPTION_COLUMN = "d".getBytes(StandardCharsets.UTF_8);
    private static final byte[] OWNER_COLUMN = "o".getBytes(StandardCharsets.UTF_8);
    private static final byte[] READER_COLUMN = "r".getBytes(StandardCharsets.UTF_8);
    private static final byte[] WRITER_COLUMN = "w".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TIMESTAMP_COLUMN = "t".getBytes(StandardCharsets.UTF_8);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final String TIMELINE_STORE_VERSION_KEY = "timeline-store-version";
    private static final Version CURRENT_VERSION_INFO = Version.newInstance((int)1, (int)0);
    @InterfaceAudience.Private
    @VisibleForTesting
    static final FsPermission LEVELDB_DIR_UMASK = FsPermission.createImmutable((short)448);
    private Map<EntityIdentifier, StartAndInsertTime> startTimeWriteCache;
    private Map<EntityIdentifier, Long> startTimeReadCache;
    private final LockMap<EntityIdentifier> writeLocks = new LockMap();
    private final ReentrantReadWriteLock deleteLock = new ReentrantReadWriteLock();
    private DB db;
    private Thread deletionThread;
    private JniDBFactory factory;

    public LeveldbTimelineStore() {
        super(LeveldbTimelineStore.class.getName());
    }

    @VisibleForTesting
    void setFactory(JniDBFactory fact) {
        this.factory = fact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceInit(Configuration conf) throws Exception {
        Preconditions.checkArgument((conf.getLong("yarn.timeline-service.ttl-ms", 604800000L) > 0L ? 1 : 0) != 0, (String)"%s property value should be greater than zero", (Object[])new Object[]{"yarn.timeline-service.ttl-ms"});
        Preconditions.checkArgument((conf.getLong("yarn.timeline-service.leveldb-timeline-store.ttl-interval-ms", 300000L) > 0L ? 1 : 0) != 0, (String)"%s property value should be greater than zero", (Object[])new Object[]{"yarn.timeline-service.leveldb-timeline-store.ttl-interval-ms"});
        Preconditions.checkArgument((conf.getLong("yarn.timeline-service.leveldb-timeline-store.read-cache-size", 0x6400000L) >= 0L ? 1 : 0) != 0, (String)"%s property value should be greater than or equal to zero", (Object[])new Object[]{"yarn.timeline-service.leveldb-timeline-store.read-cache-size"});
        Preconditions.checkArgument((conf.getLong("yarn.timeline-service.leveldb-timeline-store.start-time-read-cache-size", 10000L) > 0L ? 1 : 0) != 0, (String)" %s property value should be greater than zero", (Object[])new Object[]{"yarn.timeline-service.leveldb-timeline-store.start-time-read-cache-size"});
        Preconditions.checkArgument((conf.getLong("yarn.timeline-service.leveldb-timeline-store.start-time-write-cache-size", 10000L) > 0L ? 1 : 0) != 0, (String)"%s property value should be greater than zero", (Object[])new Object[]{"yarn.timeline-service.leveldb-timeline-store.start-time-write-cache-size"});
        Options options = new Options();
        options.createIfMissing(true);
        options.cacheSize(conf.getLong("yarn.timeline-service.leveldb-timeline-store.read-cache-size", 0x6400000L));
        if (this.factory == null) {
            this.factory = new JniDBFactory();
        }
        Path dbPath = new Path(conf.get("yarn.timeline-service.leveldb-timeline-store.path"), FILENAME);
        LocalFileSystem localFS = null;
        try {
            localFS = FileSystem.getLocal((Configuration)conf);
            if (!localFS.exists(dbPath)) {
                if (!localFS.mkdirs(dbPath)) {
                    throw new IOException("Couldn't create directory for leveldb timeline store " + dbPath);
                }
                localFS.setPermission(dbPath, LEVELDB_DIR_UMASK);
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{localFS});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{localFS});
        LOG.info("Using leveldb path " + dbPath);
        this.db = LeveldbUtils.loadOrRepairLevelDb(this.factory, dbPath, options);
        this.checkVersion();
        this.startTimeWriteCache = Collections.synchronizedMap(new LRUMap(LeveldbTimelineStore.getStartTimeWriteCacheSize(conf)));
        this.startTimeReadCache = Collections.synchronizedMap(new LRUMap(LeveldbTimelineStore.getStartTimeReadCacheSize(conf)));
        if (conf.getBoolean("yarn.timeline-service.ttl-enable", true)) {
            this.deletionThread = new EntityDeletionThread(conf);
            this.deletionThread.start();
        }
        super.serviceInit(conf);
    }

    protected void serviceStop() throws Exception {
        if (this.deletionThread != null) {
            this.deletionThread.interrupt();
            LOG.info("Waiting for deletion thread to complete its current action");
            try {
                this.deletionThread.join();
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for deletion thread to complete, closing db now", (Throwable)e);
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.db});
        super.serviceStop();
    }

    @Override
    public TimelineEntity getEntity(String entityId, String entityType, EnumSet<TimelineReader.Field> fields) throws IOException {
        TimelineEntity timelineEntity;
        Long revStartTime = this.getStartTimeLong(entityId, entityType);
        if (revStartTime == null) {
            return null;
        }
        byte[] prefix = LeveldbUtils.KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(GenericObjectMapper.writeReverseOrderedLong(revStartTime)).add(entityId).getBytesForLookup();
        LeveldbIterator iterator = null;
        try {
            iterator = new LeveldbIterator(this.db);
            iterator.seek(prefix);
            if (fields == null) {
                fields = EnumSet.allOf(TimelineReader.Field.class);
            }
            timelineEntity = LeveldbTimelineStore.getEntity(entityId, entityType, revStartTime, fields, iterator, prefix, prefix.length);
        }
        catch (DBException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator});
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator});
        return timelineEntity;
    }

    private static TimelineEntity getEntity(String entityId, String entityType, Long startTime, EnumSet<TimelineReader.Field> fields, LeveldbIterator iterator, byte[] prefix, int prefixlen) throws IOException {
        byte[] key;
        TimelineEntity entity = new TimelineEntity();
        boolean events = false;
        boolean lastEvent = false;
        if (fields.contains((Object)TimelineReader.Field.EVENTS)) {
            events = true;
        } else if (fields.contains((Object)TimelineReader.Field.LAST_EVENT_ONLY)) {
            lastEvent = true;
        } else {
            entity.setEvents(null);
        }
        boolean relatedEntities = false;
        if (fields.contains((Object)TimelineReader.Field.RELATED_ENTITIES)) {
            relatedEntities = true;
        } else {
            entity.setRelatedEntities(null);
        }
        boolean primaryFilters = false;
        if (fields.contains((Object)TimelineReader.Field.PRIMARY_FILTERS)) {
            primaryFilters = true;
        } else {
            entity.setPrimaryFilters(null);
        }
        boolean otherInfo = false;
        if (fields.contains((Object)TimelineReader.Field.OTHER_INFO)) {
            otherInfo = true;
        } else {
            entity.setOtherInfo(null);
        }
        while (iterator.hasNext() && LeveldbUtils.prefixMatches(prefix, prefixlen, key = (byte[])iterator.peekNext().getKey())) {
            if (key.length != prefixlen) {
                if (key[prefixlen] == PRIMARY_FILTERS_COLUMN[0]) {
                    if (primaryFilters) {
                        LeveldbTimelineStore.addPrimaryFilter(entity, key, prefixlen + PRIMARY_FILTERS_COLUMN.length);
                    }
                } else if (key[prefixlen] == OTHER_INFO_COLUMN[0]) {
                    if (otherInfo) {
                        entity.addOtherInfo(LeveldbTimelineStore.parseRemainingKey(key, prefixlen + OTHER_INFO_COLUMN.length), GenericObjectMapper.read((byte[])iterator.peekNext().getValue()));
                    }
                } else if (key[prefixlen] == RELATED_ENTITIES_COLUMN[0]) {
                    if (relatedEntities) {
                        LeveldbTimelineStore.addRelatedEntity(entity, key, prefixlen + RELATED_ENTITIES_COLUMN.length);
                    }
                } else if (key[prefixlen] == EVENTS_COLUMN[0]) {
                    TimelineEvent event;
                    if ((events || lastEvent && entity.getEvents().size() == 0) && (event = LeveldbTimelineStore.getEntityEvent(null, key, prefixlen + EVENTS_COLUMN.length, (byte[])iterator.peekNext().getValue())) != null) {
                        entity.addEvent(event);
                    }
                } else if (key[prefixlen] == DOMAIN_ID_COLUMN[0]) {
                    byte[] v = (byte[])iterator.peekNext().getValue();
                    String domainId = new String(v, StandardCharsets.UTF_8);
                    entity.setDomainId(domainId);
                } else if (key[prefixlen] != INVISIBLE_REVERSE_RELATED_ENTITIES_COLUMN[0]) {
                    LOG.warn(String.format("Found unexpected column for entity %s of type %s (0x%02x)", entityId, entityType, key[prefixlen]));
                }
            }
            iterator.next();
        }
        entity.setEntityId(entityId);
        entity.setEntityType(entityType);
        entity.setStartTime(startTime);
        return entity;
    }

    @Override
    public TimelineEvents getEntityTimelines(String entityType, SortedSet<String> entityIds, Long limit, Long windowStart, Long windowEnd, Set<String> eventType) throws IOException {
        TimelineEvents events = new TimelineEvents();
        if (entityIds == null || entityIds.isEmpty()) {
            return events;
        }
        TreeMap<byte[], ArrayList<EntityIdentifier>> startTimeMap = new TreeMap<byte[], ArrayList<EntityIdentifier>>(new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                return WritableComparator.compareBytes((byte[])o1, (int)0, (int)o1.length, (byte[])o2, (int)0, (int)o2.length);
            }
        });
        LeveldbIterator iterator = null;
        try {
            for (String string : entityIds) {
                byte[] startTime = this.getStartTime(string, entityType);
                if (startTime == null) continue;
                ArrayList<EntityIdentifier> entities = (ArrayList<EntityIdentifier>)startTimeMap.get(startTime);
                if (entities == null) {
                    entities = new ArrayList<EntityIdentifier>();
                    startTimeMap.put(startTime, entities);
                }
                entities.add(new EntityIdentifier(string, entityType));
            }
            for (Map.Entry entry : startTimeMap.entrySet()) {
                byte[] revStartTime = (byte[])entry.getKey();
                for (EntityIdentifier entityIdentifier : (List)entry.getValue()) {
                    byte[] key;
                    TimelineEvents.EventsOfOneEntity entity = new TimelineEvents.EventsOfOneEntity();
                    entity.setEntityId(entityIdentifier.getId());
                    entity.setEntityType(entityType);
                    events.addEvent(entity);
                    LeveldbUtils.KeyBuilder kb = LeveldbUtils.KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityIdentifier.getId()).add(EVENTS_COLUMN);
                    byte[] prefix = kb.getBytesForLookup();
                    if (windowEnd == null) {
                        windowEnd = Long.MAX_VALUE;
                    }
                    byte[] revts = GenericObjectMapper.writeReverseOrderedLong(windowEnd);
                    kb.add(revts);
                    byte[] first = kb.getBytesForLookup();
                    byte[] last = null;
                    if (windowStart != null) {
                        last = LeveldbUtils.KeyBuilder.newInstance().add(prefix).add(GenericObjectMapper.writeReverseOrderedLong(windowStart)).getBytesForLookup();
                    }
                    if (limit == null) {
                        limit = 100L;
                    }
                    iterator = new LeveldbIterator(this.db);
                    iterator.seek(first);
                    while ((long)entity.getEvents().size() < limit && iterator.hasNext() && LeveldbUtils.prefixMatches(prefix, prefix.length, key = (byte[])iterator.peekNext().getKey()) && (last == null || WritableComparator.compareBytes((byte[])key, (int)0, (int)key.length, (byte[])last, (int)0, (int)last.length) <= 0)) {
                        TimelineEvent event = LeveldbTimelineStore.getEntityEvent(eventType, key, prefix.length, (byte[])iterator.peekNext().getValue());
                        if (event != null) {
                            entity.addEvent(event);
                        }
                        iterator.next();
                    }
                }
            }
        }
        catch (DBException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator});
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator});
        return events;
    }

    @Override
    public TimelineEntities getEntities(String entityType, Long limit, Long windowStart, Long windowEnd, String fromId, Long fromTs, NameValuePair primaryFilter, Collection<NameValuePair> secondaryFilters, EnumSet<TimelineReader.Field> fields, TimelineDataManager.CheckAcl checkAcl) throws IOException {
        if (primaryFilter == null) {
            return this.getEntityByTime(ENTITY_ENTRY_PREFIX, entityType, limit, windowStart, windowEnd, fromId, fromTs, secondaryFilters, fields, checkAcl);
        }
        byte[] base = LeveldbUtils.KeyBuilder.newInstance().add(INDEXED_ENTRY_PREFIX).add(primaryFilter.getName()).add(GenericObjectMapper.write(primaryFilter.getValue()), true).add(ENTITY_ENTRY_PREFIX).getBytesForLookup();
        return this.getEntityByTime(base, entityType, limit, windowStart, windowEnd, fromId, fromTs, secondaryFilters, fields, checkAcl);
    }

    /*
     * Unable to fully structure code
     */
    private TimelineEntities getEntityByTime(byte[] base, String entityType, Long limit, Long starttime, Long endtime, String fromId, Long fromTs, Collection<NameValuePair> secondaryFilters, EnumSet<TimelineReader.Field> fields, TimelineDataManager.CheckAcl checkAcl) throws IOException {
        block23: {
            if (fields == null) {
                fields = EnumSet.allOf(TimelineReader.Field.class);
            }
            addPrimaryFilters = false;
            addOtherInfo = false;
            if (secondaryFilters != null && secondaryFilters.size() > 0) {
                if (!fields.contains((Object)TimelineReader.Field.PRIMARY_FILTERS)) {
                    fields.add(TimelineReader.Field.PRIMARY_FILTERS);
                    addPrimaryFilters = true;
                }
                if (!fields.contains((Object)TimelineReader.Field.OTHER_INFO)) {
                    fields.add(TimelineReader.Field.OTHER_INFO);
                    addOtherInfo = true;
                }
            }
            iterator = null;
            kb = LeveldbUtils.KeyBuilder.newInstance().add(base).add(entityType);
            prefix = kb.getBytesForLookup();
            if (endtime == null) {
                endtime = 0x7FFFFFFFFFFFFFFFL;
            }
            first = null;
            if (fromId == null) ** GOTO lbl31
            fromIdStartTime = this.getStartTimeLong(fromId, entityType);
            if (fromIdStartTime != null) break block23;
            var18_19 = new TimelineEntities();
            IOUtils.cleanupWithLogger((Logger)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{iterator});
            return var18_19;
        }
        try {
            if (fromIdStartTime <= endtime) {
                first = kb.add(GenericObjectMapper.writeReverseOrderedLong(fromIdStartTime)).add(fromId).getBytesForLookup();
            }
lbl31:
            // 4 sources

            if (first == null) {
                first = kb.add(GenericObjectMapper.writeReverseOrderedLong(endtime)).getBytesForLookup();
            }
            last = null;
            if (starttime != null) {
                last = LeveldbUtils.KeyBuilder.newInstance().add(base).add(entityType).add(GenericObjectMapper.writeReverseOrderedLong(starttime)).getBytesForLookup();
            }
            if (limit == null) {
                limit = 100L;
            }
            entities = new TimelineEntities();
            iterator = new LeveldbIterator(this.db);
            iterator.seek(first);
            while ((long)entities.getEntities().size() < limit && iterator.hasNext() && LeveldbUtils.prefixMatches(prefix, prefix.length, key = (byte[])iterator.peekNext().getKey()) && (last == null || WritableComparator.compareBytes((byte[])key, (int)0, (int)key.length, (byte[])last, (int)0, (int)last.length) <= 0)) {
                kp = new LeveldbUtils.KeyParser(key, prefix.length);
                startTime = kp.getNextLong();
                entityId = kp.getNextString();
                if (fromTs != null && (insertTime = GenericObjectMapper.readReverseOrderedLong((byte[])iterator.peekNext().getValue(), 0)) > fromTs) {
                    firstKey = key;
                    while (iterator.hasNext() && LeveldbUtils.prefixMatches(firstKey, kp.getOffset(), key)) {
                        iterator.next();
                        key = (byte[])iterator.peekNext().getKey();
                    }
                    continue;
                }
                entity = LeveldbTimelineStore.getEntity(entityId, entityType, startTime, fields, iterator, key, kp.getOffset());
                filterPassed = true;
                if (secondaryFilters != null) {
                    for (NameValuePair filter : secondaryFilters) {
                        v = entity.getOtherInfo().get(filter.getName());
                        if (v == null) {
                            vs = (Set)entity.getPrimaryFilters().get(filter.getName());
                            if (vs != null && vs.contains(filter.getValue())) continue;
                            filterPassed = false;
                            break;
                        }
                        if (v.equals(filter.getValue())) continue;
                        filterPassed = false;
                        break;
                    }
                }
                if (!filterPassed) continue;
                if (entity.getDomainId() == null) {
                    entity.setDomainId("DEFAULT");
                }
                if (checkAcl != null && !checkAcl.check(entity)) continue;
                if (addPrimaryFilters) {
                    entity.setPrimaryFilters(null);
                }
                if (addOtherInfo) {
                    entity.setOtherInfo(null);
                }
                entities.addEntity(entity);
            }
            var19_21 = entities;
        }
        catch (DBException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable var29_32) {
                IOUtils.cleanupWithLogger((Logger)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{iterator});
                throw var29_32;
            }
        }
        IOUtils.cleanupWithLogger((Logger)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{iterator});
        return var19_21;
    }

    private static void handleError(TimelineEntity entity, TimelinePutResponse response, int errorCode) {
        TimelinePutResponse.TimelinePutError error = new TimelinePutResponse.TimelinePutError();
        error.setEntityId(entity.getEntityId());
        error.setEntityType(entity.getEntityType());
        error.setErrorCode(errorCode);
        response.addError(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void put(TimelineEntity entity, TimelinePutResponse response, boolean allowEmptyDomainId) {
        block31: {
            block30: {
                block29: {
                    lock = this.writeLocks.getLock(new EntityIdentifier(entity.getEntityId(), entity.getEntityType()));
                    lock.lock();
                    writeBatch = null;
                    relatedEntitiesWithoutStartTimes = new ArrayList<EntityIdentifier>();
                    revStartTime = null;
                    primaryFilters = null;
                    writeBatch = this.db.createWriteBatch();
                    events = entity.getEvents();
                    startAndInsertTime = this.getAndSetStartTime(entity.getEntityId(), entity.getEntityType(), entity.getStartTime(), events);
                    if (startAndInsertTime != null) break block29;
                    LeveldbTimelineStore.handleError(entity, response, 1);
                    lock.unlock();
                    this.writeLocks.returnLock(lock);
                    IOUtils.cleanupWithLogger((Logger)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{writeBatch});
                    return;
                }
                revStartTime = GenericObjectMapper.writeReverseOrderedLong(startAndInsertTime.startTime);
                primaryFilters = entity.getPrimaryFilters();
                markerKey = LeveldbTimelineStore.createEntityMarkerKey(entity.getEntityId(), entity.getEntityType(), revStartTime);
                markerValue = GenericObjectMapper.writeReverseOrderedLong(startAndInsertTime.insertTime);
                writeBatch.put(markerKey, markerValue);
                LeveldbTimelineStore.writePrimaryFilterEntries(writeBatch, primaryFilters, markerKey, markerValue);
                if (events != null && !events.isEmpty()) {
                    for (Object event : events) {
                        revts = GenericObjectMapper.writeReverseOrderedLong(event.getTimestamp());
                        key = LeveldbTimelineStore.createEntityEventKey(entity.getEntityId(), entity.getEntityType(), revStartTime, revts, event.getEventType());
                        value = GenericObjectMapper.write(event.getEventInfo());
                        writeBatch.put(key, (byte[])value);
                        LeveldbTimelineStore.writePrimaryFilterEntries(writeBatch, primaryFilters, key, (byte[])value);
                    }
                }
                if ((relatedEntities = entity.getRelatedEntities()) != null && !relatedEntities.isEmpty()) {
                    for (Map.Entry relatedEntityList : relatedEntities.entrySet()) {
                        relatedEntityType = (String)relatedEntityList.getKey();
                        for (String relatedEntityId : (Set)relatedEntityList.getValue()) {
                            key = LeveldbTimelineStore.createReverseRelatedEntityKey(entity.getEntityId(), entity.getEntityType(), revStartTime, relatedEntityId, relatedEntityType);
                            writeBatch.put(key, LeveldbTimelineStore.EMPTY_BYTES);
                            relatedEntityStartTime = this.getStartTime(relatedEntityId, relatedEntityType);
                            if (relatedEntityStartTime == null) {
                                relatedEntitiesWithoutStartTimes.add(new EntityIdentifier(relatedEntityId, relatedEntityType));
                                continue;
                            }
                            domainIdBytes = this.db.get(LeveldbTimelineStore.createDomainIdKey(relatedEntityId, relatedEntityType, relatedEntityStartTime));
                            domainId = null;
                            domainId = domainIdBytes == null ? "DEFAULT" : new String(domainIdBytes, StandardCharsets.UTF_8);
                            if (!domainId.equals(entity.getDomainId())) {
                                LeveldbTimelineStore.handleError(entity, response, 6);
                                continue;
                            }
                            key = LeveldbTimelineStore.createRelatedEntityKey(relatedEntityId, relatedEntityType, relatedEntityStartTime, entity.getEntityId(), entity.getEntityType());
                            writeBatch.put(key, LeveldbTimelineStore.EMPTY_BYTES);
                        }
                    }
                }
                if (primaryFilters != null && !primaryFilters.isEmpty()) {
                    for (Object primaryFilter : primaryFilters.entrySet()) {
                        for (E primaryFilterValue : (Set)primaryFilter.getValue()) {
                            key = LeveldbTimelineStore.createPrimaryFilterKey(entity.getEntityId(), entity.getEntityType(), revStartTime, (String)primaryFilter.getKey(), primaryFilterValue);
                            writeBatch.put(key, LeveldbTimelineStore.EMPTY_BYTES);
                            LeveldbTimelineStore.writePrimaryFilterEntries(writeBatch, primaryFilters, key, LeveldbTimelineStore.EMPTY_BYTES);
                        }
                    }
                }
                if ((otherInfo = entity.getOtherInfo()) != null && !otherInfo.isEmpty()) {
                    for (Map.Entry i : otherInfo.entrySet()) {
                        key = LeveldbTimelineStore.createOtherInfoKey(entity.getEntityId(), entity.getEntityType(), revStartTime, (String)i.getKey());
                        value = GenericObjectMapper.write(i.getValue());
                        writeBatch.put(key, value);
                        LeveldbTimelineStore.writePrimaryFilterEntries(writeBatch, primaryFilters, key, value);
                    }
                }
                key = LeveldbTimelineStore.createDomainIdKey(entity.getEntityId(), entity.getEntityType(), revStartTime);
                if (entity.getDomainId() != null && entity.getDomainId().length() != 0) break block30;
                if (allowEmptyDomainId) ** GOTO lbl88
                LeveldbTimelineStore.handleError(entity, response, 5);
                lock.unlock();
                this.writeLocks.returnLock(lock);
                IOUtils.cleanupWithLogger((Logger)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{writeBatch});
                return;
            }
            try {
                writeBatch.put(key, entity.getDomainId().getBytes(StandardCharsets.UTF_8));
                LeveldbTimelineStore.writePrimaryFilterEntries(writeBatch, primaryFilters, key, entity.getDomainId().getBytes(StandardCharsets.UTF_8));
lbl88:
                // 2 sources

                this.db.write(writeBatch);
            }
            catch (DBException de) {
                LeveldbTimelineStore.LOG.error("Error putting entity " + entity.getEntityId() + " of type " + entity.getEntityType(), (Throwable)de);
                LeveldbTimelineStore.handleError(entity, response, 2);
                lock.unlock();
                this.writeLocks.returnLock(lock);
                IOUtils.cleanupWithLogger((Logger)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{writeBatch});
                break block31;
            }
            catch (IOException e) {
                LeveldbTimelineStore.LOG.error("Error putting entity " + entity.getEntityId() + " of type " + entity.getEntityType(), (Throwable)e);
                LeveldbTimelineStore.handleError(entity, response, 2);
                {
                    catch (Throwable var23_27) {
                        lock.unlock();
                        this.writeLocks.returnLock(lock);
                        IOUtils.cleanupWithLogger((Logger)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{writeBatch});
                        throw var23_27;
                    }
                }
                lock.unlock();
                this.writeLocks.returnLock(lock);
                IOUtils.cleanupWithLogger((Logger)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{writeBatch});
            }
            lock.unlock();
            this.writeLocks.returnLock(lock);
            IOUtils.cleanupWithLogger((Logger)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{writeBatch});
        }
        for (EntityIdentifier relatedEntity : relatedEntitiesWithoutStartTimes) {
            lock = this.writeLocks.getLock(relatedEntity);
            lock.lock();
            try {
                relatedEntityStartAndInsertTime = this.getAndSetStartTime(relatedEntity.getId(), relatedEntity.getType(), GenericObjectMapper.readReverseOrderedLong(revStartTime, 0), null);
                if (relatedEntityStartAndInsertTime == null) {
                    throw new IOException("Error setting start time for related entity");
                }
                relatedEntityStartTime = GenericObjectMapper.writeReverseOrderedLong(relatedEntityStartAndInsertTime.startTime);
                key = LeveldbTimelineStore.createDomainIdKey(relatedEntity.getId(), relatedEntity.getType(), relatedEntityStartTime);
                this.db.put(key, entity.getDomainId().getBytes(StandardCharsets.UTF_8));
                this.db.put(LeveldbTimelineStore.createRelatedEntityKey(relatedEntity.getId(), relatedEntity.getType(), relatedEntityStartTime, entity.getEntityId(), entity.getEntityType()), LeveldbTimelineStore.EMPTY_BYTES);
                this.db.put(LeveldbTimelineStore.createEntityMarkerKey(relatedEntity.getId(), relatedEntity.getType(), relatedEntityStartTime), GenericObjectMapper.writeReverseOrderedLong(relatedEntityStartAndInsertTime.insertTime));
            }
            catch (DBException de) {
                LeveldbTimelineStore.LOG.error("Error putting related entity " + relatedEntity.getId() + " of type " + relatedEntity.getType() + " for entity " + entity.getEntityId() + " of type " + entity.getEntityType(), (Throwable)de);
                LeveldbTimelineStore.handleError(entity, response, 2);
            }
            catch (IOException e) {
                LeveldbTimelineStore.LOG.error("Error putting related entity " + relatedEntity.getId() + " of type " + relatedEntity.getType() + " for entity " + entity.getEntityId() + " of type " + entity.getEntityType(), (Throwable)e);
                LeveldbTimelineStore.handleError(entity, response, 2);
            }
            finally {
                lock.unlock();
                this.writeLocks.returnLock(lock);
            }
        }
    }

    private static void writePrimaryFilterEntries(WriteBatch writeBatch, Map<String, Set<Object>> primaryFilters, byte[] key, byte[] value) throws IOException {
        if (primaryFilters != null && !primaryFilters.isEmpty()) {
            for (Map.Entry<String, Set<Object>> pf : primaryFilters.entrySet()) {
                for (Object pfval : pf.getValue()) {
                    writeBatch.put(LeveldbTimelineStore.addPrimaryFilterToKey(pf.getKey(), pfval, key), value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimelinePutResponse put(TimelineEntities entities) {
        this.deleteLock.readLock().lock();
        try {
            TimelinePutResponse response = new TimelinePutResponse();
            for (TimelineEntity entity : entities.getEntities()) {
                this.put(entity, response, false);
            }
            TimelinePutResponse timelinePutResponse = response;
            return timelinePutResponse;
        }
        finally {
            this.deleteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    public TimelinePutResponse putWithNoDomainId(TimelineEntities entities) {
        this.deleteLock.readLock().lock();
        try {
            TimelinePutResponse response = new TimelinePutResponse();
            for (TimelineEntity entity : entities.getEntities()) {
                this.put(entity, response, true);
            }
            TimelinePutResponse timelinePutResponse = response;
            return timelinePutResponse;
        }
        finally {
            this.deleteLock.readLock().unlock();
        }
    }

    private byte[] getStartTime(String entityId, String entityType) throws IOException {
        Long l = this.getStartTimeLong(entityId, entityType);
        return l == null ? null : GenericObjectMapper.writeReverseOrderedLong(l);
    }

    private Long getStartTimeLong(String entityId, String entityType) throws IOException {
        EntityIdentifier entity = new EntityIdentifier(entityId, entityType);
        try {
            if (this.startTimeReadCache.containsKey(entity)) {
                return this.startTimeReadCache.get(entity);
            }
            byte[] b = LeveldbTimelineStore.createStartTimeLookupKey(entity.getId(), entity.getType());
            byte[] v = this.db.get(b);
            if (v == null) {
                return null;
            }
            Long l = GenericObjectMapper.readReverseOrderedLong(v, 0);
            this.startTimeReadCache.put(entity, l);
            return l;
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    private StartAndInsertTime getAndSetStartTime(String entityId, String entityType, Long startTime, List<TimelineEvent> events) throws IOException {
        EntityIdentifier entity = new EntityIdentifier(entityId, entityType);
        if (startTime == null) {
            if (this.startTimeWriteCache.containsKey(entity)) {
                return this.startTimeWriteCache.get(entity);
            }
            if (events != null) {
                Long min = Long.MAX_VALUE;
                for (TimelineEvent e : events) {
                    if (min <= e.getTimestamp()) continue;
                    min = e.getTimestamp();
                }
                startTime = min;
            }
            return this.checkStartTimeInDb(entity, startTime);
        }
        if (this.startTimeWriteCache.containsKey(entity)) {
            return this.startTimeWriteCache.get(entity);
        }
        return this.checkStartTimeInDb(entity, startTime);
    }

    private StartAndInsertTime checkStartTimeInDb(EntityIdentifier entity, Long suggestedStartTime) throws IOException {
        StartAndInsertTime startAndInsertTime = null;
        byte[] b = LeveldbTimelineStore.createStartTimeLookupKey(entity.getId(), entity.getType());
        try {
            byte[] v = this.db.get(b);
            if (v == null) {
                if (suggestedStartTime == null) {
                    return null;
                }
                startAndInsertTime = new StartAndInsertTime(suggestedStartTime, System.currentTimeMillis());
                v = new byte[16];
                GenericObjectMapper.writeReverseOrderedLong(suggestedStartTime, v, 0);
                GenericObjectMapper.writeReverseOrderedLong(startAndInsertTime.insertTime, v, 8);
                WriteOptions writeOptions = new WriteOptions();
                writeOptions.sync(true);
                this.db.put(b, v, writeOptions);
            } else {
                startAndInsertTime = new StartAndInsertTime(GenericObjectMapper.readReverseOrderedLong(v, 0), GenericObjectMapper.readReverseOrderedLong(v, 8));
            }
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        this.startTimeWriteCache.put(entity, startAndInsertTime);
        this.startTimeReadCache.put(entity, startAndInsertTime.startTime);
        return startAndInsertTime;
    }

    private static byte[] createStartTimeLookupKey(String entityId, String entityType) throws IOException {
        return LeveldbUtils.KeyBuilder.newInstance().add(START_TIME_LOOKUP_PREFIX).add(entityType).add(entityId).getBytes();
    }

    private static byte[] createEntityMarkerKey(String entityId, String entityType, byte[] revStartTime) throws IOException {
        return LeveldbUtils.KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityId).getBytesForLookup();
    }

    private static byte[] addPrimaryFilterToKey(String primaryFilterName, Object primaryFilterValue, byte[] key) throws IOException {
        return LeveldbUtils.KeyBuilder.newInstance().add(INDEXED_ENTRY_PREFIX).add(primaryFilterName).add(GenericObjectMapper.write(primaryFilterValue), true).add(key).getBytes();
    }

    private static byte[] createEntityEventKey(String entityId, String entityType, byte[] revStartTime, byte[] revEventTimestamp, String eventType) throws IOException {
        return LeveldbUtils.KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityId).add(EVENTS_COLUMN).add(revEventTimestamp).add(eventType).getBytes();
    }

    private static TimelineEvent getEntityEvent(Set<String> eventTypes, byte[] key, int offset, byte[] value) throws IOException {
        LeveldbUtils.KeyParser kp = new LeveldbUtils.KeyParser(key, offset);
        long ts = kp.getNextLong();
        String tstype = kp.getNextString();
        if (eventTypes == null || eventTypes.contains(tstype)) {
            TimelineEvent event = new TimelineEvent();
            event.setTimestamp(ts);
            event.setEventType(tstype);
            Object o = GenericObjectMapper.read(value);
            if (o == null) {
                event.setEventInfo(null);
            } else if (o instanceof Map) {
                Map m = (Map)o;
                event.setEventInfo(m);
            } else {
                throw new IOException("Couldn't deserialize event info map");
            }
            return event;
        }
        return null;
    }

    private static byte[] createPrimaryFilterKey(String entityId, String entityType, byte[] revStartTime, String name, Object value) throws IOException {
        return LeveldbUtils.KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityId).add(PRIMARY_FILTERS_COLUMN).add(name).add(GenericObjectMapper.write(value)).getBytes();
    }

    private static void addPrimaryFilter(TimelineEntity entity, byte[] key, int offset) throws IOException {
        LeveldbUtils.KeyParser kp = new LeveldbUtils.KeyParser(key, offset);
        String name = kp.getNextString();
        Object value = GenericObjectMapper.read(key, kp.getOffset());
        entity.addPrimaryFilter(name, value);
    }

    private static byte[] createOtherInfoKey(String entityId, String entityType, byte[] revStartTime, String name) throws IOException {
        return LeveldbUtils.KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityId).add(OTHER_INFO_COLUMN).add(name).getBytes();
    }

    private static String parseRemainingKey(byte[] b, int offset) {
        return new String(b, offset, b.length - offset, StandardCharsets.UTF_8);
    }

    private static byte[] createRelatedEntityKey(String entityId, String entityType, byte[] revStartTime, String relatedEntityId, String relatedEntityType) throws IOException {
        return LeveldbUtils.KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityId).add(RELATED_ENTITIES_COLUMN).add(relatedEntityType).add(relatedEntityId).getBytes();
    }

    private static void addRelatedEntity(TimelineEntity entity, byte[] key, int offset) throws IOException {
        LeveldbUtils.KeyParser kp = new LeveldbUtils.KeyParser(key, offset);
        String type = kp.getNextString();
        String id = kp.getNextString();
        entity.addRelatedEntity(type, id);
    }

    private static byte[] createReverseRelatedEntityKey(String entityId, String entityType, byte[] revStartTime, String relatedEntityId, String relatedEntityType) throws IOException {
        return LeveldbUtils.KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityId).add(INVISIBLE_REVERSE_RELATED_ENTITIES_COLUMN).add(relatedEntityType).add(relatedEntityId).getBytes();
    }

    private static byte[] createDomainIdKey(String entityId, String entityType, byte[] revStartTime) throws IOException {
        return LeveldbUtils.KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityId).add(DOMAIN_ID_COLUMN).getBytes();
    }

    @VisibleForTesting
    void clearStartTimeCache() {
        this.startTimeWriteCache.clear();
        this.startTimeReadCache.clear();
    }

    @VisibleForTesting
    static int getStartTimeReadCacheSize(Configuration conf) {
        return conf.getInt("yarn.timeline-service.leveldb-timeline-store.start-time-read-cache-size", 10000);
    }

    @VisibleForTesting
    static int getStartTimeWriteCacheSize(Configuration conf) {
        return conf.getInt("yarn.timeline-service.leveldb-timeline-store.start-time-write-cache-size", 10000);
    }

    @VisibleForTesting
    List<String> getEntityTypes() throws IOException {
        ArrayList<String> arrayList;
        LeveldbIterator iterator = null;
        try {
            byte[] key;
            iterator = this.getDbIterator(false);
            ArrayList<String> entityTypes = new ArrayList<String>();
            iterator.seek(ENTITY_ENTRY_PREFIX);
            while (iterator.hasNext() && (key = (byte[])iterator.peekNext().getKey())[0] == ENTITY_ENTRY_PREFIX[0]) {
                LeveldbUtils.KeyParser kp = new LeveldbUtils.KeyParser(key, ENTITY_ENTRY_PREFIX.length);
                String entityType = kp.getNextString();
                entityTypes.add(entityType);
                byte[] lookupKey = LeveldbUtils.KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).getBytesForLookup();
                if (lookupKey[lookupKey.length - 1] != 0) {
                    throw new IOException("Found unexpected end byte in lookup key");
                }
                lookupKey[lookupKey.length - 1] = 1;
                iterator.seek(lookupKey);
            }
            arrayList = entityTypes;
        }
        catch (DBException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator});
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator});
        return arrayList;
    }

    private void deleteKeysWithPrefix(WriteBatch writeBatch, byte[] prefix, LeveldbIterator iterator) {
        byte[] key;
        iterator.seek(prefix);
        while (iterator.hasNext() && LeveldbUtils.prefixMatches(prefix, prefix.length, key = (byte[])iterator.peekNext().getKey())) {
            writeBatch.delete(key);
            iterator.next();
        }
    }

    @VisibleForTesting
    boolean deleteNextEntity(String entityType, byte[] reverseTimestamp, LeveldbIterator iterator, LeveldbIterator pfIterator, boolean seeked) throws IOException {
        boolean bl;
        byte[] entityKey;
        byte[] typePrefix;
        WriteBatch writeBatch;
        block19: {
            block18: {
                writeBatch = null;
                LeveldbUtils.KeyBuilder kb = LeveldbUtils.KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType);
                typePrefix = kb.getBytesForLookup();
                kb.add(reverseTimestamp);
                if (!seeked) {
                    iterator.seek(kb.getBytesForLookup());
                }
                if (iterator.hasNext()) break block18;
                boolean bl2 = false;
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writeBatch});
                return bl2;
            }
            entityKey = (byte[])iterator.peekNext().getKey();
            if (LeveldbUtils.prefixMatches(typePrefix, typePrefix.length, entityKey)) break block19;
            boolean bl3 = false;
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writeBatch});
            return bl3;
        }
        try {
            byte[] key;
            LeveldbUtils.KeyParser kp = new LeveldbUtils.KeyParser(entityKey, typePrefix.length + 8);
            String entityId = kp.getNextString();
            int prefixlen = kp.getOffset();
            byte[] deletePrefix = new byte[prefixlen];
            System.arraycopy(entityKey, 0, deletePrefix, 0, prefixlen);
            writeBatch = this.db.createWriteBatch();
            LOG.debug("Deleting entity type:{} id:{}", (Object)entityType, (Object)entityId);
            writeBatch.delete(LeveldbTimelineStore.createStartTimeLookupKey(entityId, entityType));
            EntityIdentifier entityIdentifier = new EntityIdentifier(entityId, entityType);
            this.startTimeReadCache.remove(entityIdentifier);
            this.startTimeWriteCache.remove(entityIdentifier);
            while (iterator.hasNext() && LeveldbUtils.prefixMatches(entityKey, prefixlen, key = (byte[])iterator.peekNext().getKey())) {
                writeBatch.delete(key);
                if (key.length != prefixlen) {
                    byte[] relatedEntityStartTime;
                    String id;
                    String type;
                    if (key[prefixlen] == PRIMARY_FILTERS_COLUMN[0]) {
                        kp = new LeveldbUtils.KeyParser(key, prefixlen + PRIMARY_FILTERS_COLUMN.length);
                        String name = kp.getNextString();
                        Object value = GenericObjectMapper.read(key, kp.getOffset());
                        this.deleteKeysWithPrefix(writeBatch, LeveldbTimelineStore.addPrimaryFilterToKey(name, value, deletePrefix), pfIterator);
                        LOG.debug("Deleting entity type:{} id:{} primary filter entry {} {}", new Object[]{entityType, entityId, name, value});
                    } else if (key[prefixlen] == RELATED_ENTITIES_COLUMN[0]) {
                        kp = new LeveldbUtils.KeyParser(key, prefixlen + RELATED_ENTITIES_COLUMN.length);
                        type = kp.getNextString();
                        id = kp.getNextString();
                        relatedEntityStartTime = this.getStartTime(id, type);
                        if (relatedEntityStartTime == null) {
                            LOG.warn("Found no start time for related entity " + id + " of type " + type + " while deleting " + entityId + " of type " + entityType);
                        } else {
                            writeBatch.delete(LeveldbTimelineStore.createReverseRelatedEntityKey(id, type, relatedEntityStartTime, entityId, entityType));
                            LOG.debug("Deleting entity type:{} id:{} from invisible reverse related entity entry of type:{} id:{}", new Object[]{entityType, entityId, type, id});
                        }
                    } else if (key[prefixlen] == INVISIBLE_REVERSE_RELATED_ENTITIES_COLUMN[0]) {
                        kp = new LeveldbUtils.KeyParser(key, prefixlen + INVISIBLE_REVERSE_RELATED_ENTITIES_COLUMN.length);
                        type = kp.getNextString();
                        id = kp.getNextString();
                        relatedEntityStartTime = this.getStartTime(id, type);
                        if (relatedEntityStartTime == null) {
                            LOG.warn("Found no start time for reverse related entity " + id + " of type " + type + " while deleting " + entityId + " of type " + entityType);
                        } else {
                            writeBatch.delete(LeveldbTimelineStore.createRelatedEntityKey(id, type, relatedEntityStartTime, entityId, entityType));
                            LOG.debug("Deleting entity type:{} id:{} from related entity entry of type:{} id:{}", new Object[]{entityType, entityId, type, id});
                        }
                    }
                }
                iterator.next();
            }
            WriteOptions writeOptions = new WriteOptions();
            writeOptions.sync(true);
            this.db.write(writeBatch, writeOptions);
            bl = true;
        }
        catch (DBException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writeBatch});
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writeBatch});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    void discardOldEntities(long timestamp) throws IOException, InterruptedException {
        byte[] reverseTimestamp = GenericObjectMapper.writeReverseOrderedLong(timestamp);
        long totalCount = 0L;
        long t1 = System.currentTimeMillis();
        try {
            List<String> entityTypes = this.getEntityTypes();
            for (String entityType : entityTypes) {
                LeveldbIterator iterator = null;
                LeveldbIterator pfIterator = null;
                long typeCount = 0L;
                this.deleteLock.writeLock().lock();
                try {
                    iterator = this.getDbIterator(false);
                    pfIterator = this.getDbIterator(false);
                    if (this.deletionThread != null && this.deletionThread.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    boolean seeked = false;
                    while (this.deleteNextEntity(entityType, reverseTimestamp, iterator, pfIterator, seeked)) {
                        ++typeCount;
                        ++totalCount;
                        seeked = true;
                        if (this.deletionThread == null || !this.deletionThread.isInterrupted()) continue;
                        throw new InterruptedException();
                    }
                }
                catch (IOException e) {
                    try {
                        LOG.error("Got IOException while deleting entities for type " + entityType + ", continuing to next type", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator, pfIterator});
                        this.deleteLock.writeLock().unlock();
                        if (typeCount <= 0L) throw throwable;
                        LOG.info("Deleted " + typeCount + " entities of type " + entityType);
                        throw throwable;
                        return;
                    }
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator, pfIterator});
                    this.deleteLock.writeLock().unlock();
                    if (typeCount <= 0L) continue;
                    LOG.info("Deleted " + typeCount + " entities of type " + entityType);
                    continue;
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator, pfIterator});
                this.deleteLock.writeLock().unlock();
                if (typeCount <= 0L) continue;
                LOG.info("Deleted " + typeCount + " entities of type " + entityType);
            }
        }
        finally {
            long t2 = System.currentTimeMillis();
            LOG.info("Discarded " + totalCount + " entities for timestamp " + timestamp + " and earlier in " + (double)(t2 - t1) / 1000.0 + " seconds");
        }
    }

    @VisibleForTesting
    LeveldbIterator getDbIterator(boolean fillCache) {
        ReadOptions readOptions = new ReadOptions();
        readOptions.fillCache(fillCache);
        return new LeveldbIterator(this.db, readOptions);
    }

    Version loadVersion() throws IOException {
        try {
            byte[] data = this.db.get(JniDBFactory.bytes((String)TIMELINE_STORE_VERSION_KEY));
            if (data == null || data.length == 0) {
                return this.getCurrentVersion();
            }
            VersionPBImpl version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom((byte[])data));
            return version;
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    void storeVersion(Version state) throws IOException {
        this.dbStoreVersion(state);
    }

    private void dbStoreVersion(Version state) throws IOException {
        String key = TIMELINE_STORE_VERSION_KEY;
        byte[] data = ((VersionPBImpl)state).getProto().toByteArray();
        try {
            this.db.put(JniDBFactory.bytes((String)key), data);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    private void checkVersion() throws IOException {
        Version loadedVersion = this.loadVersion();
        LOG.info("Loaded timeline store version info " + loadedVersion);
        if (loadedVersion.equals((Object)this.getCurrentVersion())) {
            return;
        }
        if (!loadedVersion.isCompatibleTo(this.getCurrentVersion())) {
            String incompatibleMessage = "Incompatible version for timeline store: expecting version " + this.getCurrentVersion() + ", but loading version " + loadedVersion;
            LOG.error(incompatibleMessage);
            throw new IOException(incompatibleMessage);
        }
        LOG.info("Storing timeline store version info " + this.getCurrentVersion());
        this.dbStoreVersion(CURRENT_VERSION_INFO);
    }

    @Override
    public void put(TimelineDomain domain) throws IOException {
        WriteBatch writeBatch = null;
        try {
            writeBatch = this.db.createWriteBatch();
            if (domain.getId() == null || domain.getId().length() == 0) {
                throw new IllegalArgumentException("Domain doesn't have an ID");
            }
            if (domain.getOwner() == null || domain.getOwner().length() == 0) {
                throw new IllegalArgumentException("Domain doesn't have an owner.");
            }
            byte[] domainEntryKey = LeveldbTimelineStore.createDomainEntryKey(domain.getId(), DESCRIPTION_COLUMN);
            byte[] ownerLookupEntryKey = LeveldbTimelineStore.createOwnerLookupKey(domain.getOwner(), domain.getId(), DESCRIPTION_COLUMN);
            if (domain.getDescription() != null) {
                writeBatch.put(domainEntryKey, domain.getDescription().getBytes(StandardCharsets.UTF_8));
                writeBatch.put(ownerLookupEntryKey, domain.getDescription().getBytes(StandardCharsets.UTF_8));
            } else {
                writeBatch.put(domainEntryKey, EMPTY_BYTES);
                writeBatch.put(ownerLookupEntryKey, EMPTY_BYTES);
            }
            domainEntryKey = LeveldbTimelineStore.createDomainEntryKey(domain.getId(), OWNER_COLUMN);
            ownerLookupEntryKey = LeveldbTimelineStore.createOwnerLookupKey(domain.getOwner(), domain.getId(), OWNER_COLUMN);
            writeBatch.put(domainEntryKey, domain.getOwner().getBytes(StandardCharsets.UTF_8));
            writeBatch.put(ownerLookupEntryKey, domain.getOwner().getBytes(StandardCharsets.UTF_8));
            domainEntryKey = LeveldbTimelineStore.createDomainEntryKey(domain.getId(), READER_COLUMN);
            ownerLookupEntryKey = LeveldbTimelineStore.createOwnerLookupKey(domain.getOwner(), domain.getId(), READER_COLUMN);
            if (domain.getReaders() != null && domain.getReaders().length() > 0) {
                writeBatch.put(domainEntryKey, domain.getReaders().getBytes(StandardCharsets.UTF_8));
                writeBatch.put(ownerLookupEntryKey, domain.getReaders().getBytes(StandardCharsets.UTF_8));
            } else {
                writeBatch.put(domainEntryKey, EMPTY_BYTES);
                writeBatch.put(ownerLookupEntryKey, EMPTY_BYTES);
            }
            domainEntryKey = LeveldbTimelineStore.createDomainEntryKey(domain.getId(), WRITER_COLUMN);
            ownerLookupEntryKey = LeveldbTimelineStore.createOwnerLookupKey(domain.getOwner(), domain.getId(), WRITER_COLUMN);
            if (domain.getWriters() != null && domain.getWriters().length() > 0) {
                writeBatch.put(domainEntryKey, domain.getWriters().getBytes(StandardCharsets.UTF_8));
                writeBatch.put(ownerLookupEntryKey, domain.getWriters().getBytes(StandardCharsets.UTF_8));
            } else {
                writeBatch.put(domainEntryKey, EMPTY_BYTES);
                writeBatch.put(ownerLookupEntryKey, EMPTY_BYTES);
            }
            domainEntryKey = LeveldbTimelineStore.createDomainEntryKey(domain.getId(), TIMESTAMP_COLUMN);
            ownerLookupEntryKey = LeveldbTimelineStore.createOwnerLookupKey(domain.getOwner(), domain.getId(), TIMESTAMP_COLUMN);
            long currentTimestamp = System.currentTimeMillis();
            byte[] timestamps = this.db.get(domainEntryKey);
            if (timestamps == null) {
                timestamps = new byte[16];
                GenericObjectMapper.writeReverseOrderedLong(currentTimestamp, timestamps, 0);
                GenericObjectMapper.writeReverseOrderedLong(currentTimestamp, timestamps, 8);
            } else {
                GenericObjectMapper.writeReverseOrderedLong(currentTimestamp, timestamps, 8);
            }
            writeBatch.put(domainEntryKey, timestamps);
            writeBatch.put(ownerLookupEntryKey, timestamps);
            this.db.write(writeBatch);
        }
        catch (DBException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writeBatch});
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writeBatch});
    }

    private static byte[] createDomainEntryKey(String domainId, byte[] columnName) throws IOException {
        return LeveldbUtils.KeyBuilder.newInstance().add(DOMAIN_ENTRY_PREFIX).add(domainId).add(columnName).getBytes();
    }

    private static byte[] createOwnerLookupKey(String owner, String domainId, byte[] columnName) throws IOException {
        return LeveldbUtils.KeyBuilder.newInstance().add(OWNER_LOOKUP_PREFIX).add(owner).add(domainId).add(columnName).getBytes();
    }

    @Override
    public TimelineDomain getDomain(String domainId) throws IOException {
        TimelineDomain timelineDomain;
        LeveldbIterator iterator = null;
        try {
            byte[] prefix = LeveldbUtils.KeyBuilder.newInstance().add(DOMAIN_ENTRY_PREFIX).add(domainId).getBytesForLookup();
            iterator = new LeveldbIterator(this.db);
            iterator.seek(prefix);
            timelineDomain = LeveldbTimelineStore.getTimelineDomain(iterator, domainId, prefix);
        }
        catch (DBException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator});
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator});
        return timelineDomain;
    }

    @Override
    public TimelineDomains getDomains(String owner) throws IOException {
        TimelineDomains timelineDomains;
        LeveldbIterator iterator = null;
        try {
            byte[] key;
            byte[] prefix = LeveldbUtils.KeyBuilder.newInstance().add(OWNER_LOOKUP_PREFIX).add(owner).getBytesForLookup();
            ArrayList<TimelineDomain> domains = new ArrayList<TimelineDomain>();
            iterator = new LeveldbIterator(this.db);
            iterator.seek(prefix);
            while (iterator.hasNext() && LeveldbUtils.prefixMatches(prefix, prefix.length, key = (byte[])iterator.peekNext().getKey())) {
                byte[] prefixExt;
                LeveldbUtils.KeyParser kp = new LeveldbUtils.KeyParser(key, prefix.length);
                String domainId = kp.getNextString();
                TimelineDomain domainToReturn = LeveldbTimelineStore.getTimelineDomain(iterator, domainId, prefixExt = LeveldbUtils.KeyBuilder.newInstance().add(OWNER_LOOKUP_PREFIX).add(owner).add(domainId).getBytesForLookup());
                if (domainToReturn == null) continue;
                domains.add(domainToReturn);
            }
            Collections.sort(domains, new Comparator<TimelineDomain>(){

                @Override
                public int compare(TimelineDomain domain1, TimelineDomain domain2) {
                    int result = domain2.getCreatedTime().compareTo(domain1.getCreatedTime());
                    if (result == 0) {
                        return domain2.getModifiedTime().compareTo(domain1.getModifiedTime());
                    }
                    return result;
                }
            });
            TimelineDomains domainsToReturn = new TimelineDomains();
            domainsToReturn.addDomains(domains);
            timelineDomains = domainsToReturn;
        }
        catch (DBException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator});
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator});
        return timelineDomains;
    }

    private static TimelineDomain getTimelineDomain(LeveldbIterator iterator, String domainId, byte[] prefix) throws IOException {
        byte[] key;
        TimelineDomain domain = new TimelineDomain();
        domain.setId(domainId);
        boolean noRows = true;
        while (iterator.hasNext() && LeveldbUtils.prefixMatches(prefix, prefix.length, key = (byte[])iterator.peekNext().getKey())) {
            byte[] value;
            if (noRows) {
                noRows = false;
            }
            if ((value = (byte[])iterator.peekNext().getValue()) != null && value.length > 0) {
                if (key[prefix.length] == DESCRIPTION_COLUMN[0]) {
                    domain.setDescription(new String(value, StandardCharsets.UTF_8));
                } else if (key[prefix.length] == OWNER_COLUMN[0]) {
                    domain.setOwner(new String(value, StandardCharsets.UTF_8));
                } else if (key[prefix.length] == READER_COLUMN[0]) {
                    domain.setReaders(new String(value, StandardCharsets.UTF_8));
                } else if (key[prefix.length] == WRITER_COLUMN[0]) {
                    domain.setWriters(new String(value, StandardCharsets.UTF_8));
                } else if (key[prefix.length] == TIMESTAMP_COLUMN[0]) {
                    domain.setCreatedTime(Long.valueOf(GenericObjectMapper.readReverseOrderedLong(value, 0)));
                    domain.setModifiedTime(Long.valueOf(GenericObjectMapper.readReverseOrderedLong(value, 8)));
                } else {
                    LOG.error("Unrecognized domain column: " + key[prefix.length]);
                }
            }
            iterator.next();
        }
        if (noRows) {
            return null;
        }
        return domain;
    }

    private static class LockMap<K> {
        private Map<K, CountingReentrantLock<K>> locks = new HashMap<K, CountingReentrantLock<K>>();

        private LockMap() {
        }

        synchronized CountingReentrantLock<K> getLock(K key) {
            CountingReentrantLock<K> lock = this.locks.get(key);
            if (lock == null) {
                lock = new CountingReentrantLock<K>(key);
                this.locks.put(key, lock);
            }
            ((CountingReentrantLock)lock).count++;
            return lock;
        }

        synchronized void returnLock(CountingReentrantLock<K> lock) {
            if (((CountingReentrantLock)lock).count == 0) {
                throw new IllegalStateException("Returned lock more times than it was retrieved");
            }
            ((CountingReentrantLock)lock).count--;
            if (((CountingReentrantLock)lock).count == 0) {
                this.locks.remove(((CountingReentrantLock)lock).key);
            }
        }

        private static class CountingReentrantLock<K>
        extends ReentrantLock {
            private static final long serialVersionUID = 1L;
            private int count = 0;
            private K key;

            CountingReentrantLock(K key) {
                this.key = key;
            }
        }
    }

    private class EntityDeletionThread
    extends Thread {
        private final long ttl;
        private final long ttlInterval;

        public EntityDeletionThread(Configuration conf) {
            this.ttl = conf.getLong("yarn.timeline-service.ttl-ms", 604800000L);
            this.ttlInterval = conf.getLong("yarn.timeline-service.leveldb-timeline-store.ttl-interval-ms", 300000L);
            LOG.info("Starting deletion thread with ttl " + this.ttl + " and cycle interval " + this.ttlInterval);
        }

        @Override
        public void run() {
            while (true) {
                long timestamp = System.currentTimeMillis() - this.ttl;
                try {
                    LeveldbTimelineStore.this.discardOldEntities(timestamp);
                    Thread.sleep(this.ttlInterval);
                    continue;
                }
                catch (IOException e) {
                    LOG.error(e.toString());
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.info("Deletion thread received interrupt, exiting");
                    return;
                }
                break;
            }
        }
    }

    private static class StartAndInsertTime {
        final long startTime;
        final long insertTime;

        public StartAndInsertTime(long startTime, long insertTime) {
            this.startTime = startTime;
            this.insertTime = insertTime;
        }
    }
}

