/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import com.google.errorprone.annotations.RestrictedApi;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.impl.BackupManifest;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class HBackupFileSystem {
    public static final Logger LOG = LoggerFactory.getLogger(HBackupFileSystem.class);

    private HBackupFileSystem() {
    }

    public static String getTableBackupDir(String backupRootDir, String backupId, TableName tableName) {
        return backupRootDir + "/" + backupId + "/" + tableName.getNamespaceAsString() + "/" + tableName.getQualifierAsString() + "/";
    }

    public static Path getBackupTmpDirPath(String backupRootDir) {
        return new Path(backupRootDir, ".tmp");
    }

    public static Path getBackupTmpDirPathForBackupId(String backupRoot, String backupId) {
        return new Path(HBackupFileSystem.getBackupTmpDirPath(backupRoot), backupId);
    }

    public static Path getBackupPath(String backupRootDir, String backupId) {
        return new Path(backupRootDir + "/" + backupId);
    }

    public static Path getTableBackupPath(TableName tableName, Path backupRootPath, String backupId) {
        return new Path(HBackupFileSystem.getTableBackupDir(backupRootPath.toString(), backupId, tableName));
    }

    private static Path getManifestPath(Configuration conf, Path backupRootPath, String backupId) throws IOException {
        return HBackupFileSystem.getManifestPath(conf, backupRootPath, backupId, true);
    }

    @RestrictedApi(explanation="Should only be called internally or in tests", link="", allowedOnPath="(.*/src/test/.*|.*/org/apache/hadoop/hbase/backup/HBackupFileSystem.java)")
    static Path getManifestPath(Configuration conf, Path backupRootPath, String backupId, boolean throwIfNotFound) throws IOException {
        FileSystem fs = backupRootPath.getFileSystem(conf);
        Path manifestPath = new Path(HBackupFileSystem.getBackupPath(backupRootPath.toString(), backupId) + "/" + ".backup.manifest");
        if (throwIfNotFound && !fs.exists(manifestPath)) {
            String errorMsg = "Could not find backup manifest .backup.manifest for " + backupId + ". File " + manifestPath + " does not exists. Did " + backupId + " correspond to previously taken backup ?";
            throw new IOException(errorMsg);
        }
        return manifestPath;
    }

    public static Path getRootDirFromBackupPath(Path backupPath, String backupId) {
        if (backupPath.getName().equals(".backup.manifest")) {
            backupPath = backupPath.getParent();
        }
        Preconditions.checkArgument((boolean)backupPath.getName().equals(backupId), (Object)String.format("Backup path %s must end in backupId %s", backupPath, backupId));
        return backupPath.getParent();
    }

    public static BackupManifest getManifest(Configuration conf, Path backupRootPath, String backupId) throws IOException {
        BackupManifest manifest = new BackupManifest(conf, HBackupFileSystem.getManifestPath(conf, backupRootPath, backupId));
        return manifest;
    }
}

