/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.mapreduce;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.RestoreJob;
import org.apache.hadoop.hbase.tool.BulkLoadHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSVisitor;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MapReduceRestoreToOriginalSplitsJob
implements RestoreJob {
    private Configuration conf;

    @Override
    public void run(Path[] dirPaths, TableName[] fromTables, Path restoreRootDir, TableName[] toTables, boolean fullBackupRestore) throws IOException {
        Configuration conf = this.getConf();
        conf.setBoolean("always.copy.files", true);
        Path backupRootDir = new Path(conf.get("hbase.backup.root.path"));
        FileSystem fs = backupRootDir.getFileSystem(conf);
        Map<byte[], List<Path>> family2Files = MapReduceRestoreToOriginalSplitsJob.buildFamily2Files(fs, dirPaths, fullBackupRestore);
        BulkLoadHFiles bulkLoad = BulkLoadHFiles.create((Configuration)conf);
        for (int i = 0; i < fromTables.length; ++i) {
            bulkLoad.bulkLoad(toTables[i], family2Files);
        }
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
    }

    public Configuration getConf() {
        return this.conf;
    }

    private static Map<byte[], List<Path>> buildFamily2Files(FileSystem fs, Path[] dirs, boolean isFullBackup) throws IOException {
        if (isFullBackup) {
            return MapReduceRestoreToOriginalSplitsJob.buildFullBackupFamily2Files(fs, dirs);
        }
        HashMap<byte[], List<Path>> family2Files = new HashMap<byte[], List<Path>>();
        for (Path dir : dirs) {
            byte[] familyName = Bytes.toBytes((String)dir.getParent().getName());
            if (family2Files.containsKey(familyName)) {
                ((List)family2Files.get(familyName)).add(dir);
                continue;
            }
            family2Files.put(familyName, Lists.newArrayList((Object[])new Path[]{dir}));
        }
        return family2Files;
    }

    private static Map<byte[], List<Path>> buildFullBackupFamily2Files(FileSystem fs, Path[] dirs) throws IOException {
        HashMap<byte[], List<Path>> family2Files = new HashMap<byte[], List<Path>>();
        for (Path regionPath : dirs) {
            FSVisitor.visitRegionStoreFiles((FileSystem)fs, (Path)regionPath, (region, family, name) -> {
                Path path = new Path(regionPath, new Path(family, name));
                byte[] familyName = Bytes.toBytes((String)family);
                if (family2Files.containsKey(familyName)) {
                    ((List)family2Files.get(familyName)).add(path);
                } else {
                    family2Files.put(familyName, Lists.newArrayList((Object[])new Path[]{path}));
                }
            });
        }
        return family2Files;
    }
}

