/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.backup.util.BackupUtils;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.IterableUtils;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.MapUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class BackupLogCleaner
extends BaseLogCleanerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(BackupLogCleaner.class);
    private boolean stopped = false;
    private Connection conn;

    public void init(Map<String, Object> params) {
        MasterServices master = (MasterServices)MapUtils.getObject(params, (Object)"master");
        if (master != null) {
            this.conn = master.getConnection();
            if (this.getConf() == null) {
                super.setConf(this.conn.getConfiguration());
            }
        }
        if (this.conn == null) {
            try {
                this.conn = ConnectionFactory.createConnection((Configuration)this.getConf());
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to create connection", ioe);
            }
        }
    }

    private Map<Address, Long> serverToPreservationBoundaryTs(List<BackupInfo> backups) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cleaning WALs if they are older than the WAL cleanup time-boundary. Checking WALs against {} backups: {}", (Object)backups.size(), (Object)backups.stream().map(BackupInfo::getBackupId).sorted().collect(Collectors.joining(", ")));
        }
        HashMap<String, BackupInfo> newestBackupPerRootDir = new HashMap<String, BackupInfo>();
        for (BackupInfo backup : backups) {
            BackupInfo backupInfo = (BackupInfo)newestBackupPerRootDir.get(backup.getBackupRootDir());
            if (backupInfo != null && backupInfo.getStartTs() >= backup.getStartTs()) continue;
            newestBackupPerRootDir.put(backup.getBackupRootDir(), backup);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("WAL cleanup time-boundary using info from: {}. ", (Object)newestBackupPerRootDir.entrySet().stream().map(e -> "Backup root " + (String)e.getKey() + ": " + ((BackupInfo)e.getValue()).getBackupId()).sorted().collect(Collectors.joining(", ")));
        }
        HashMap<Address, Long> boundaries = new HashMap<Address, Long>();
        for (BackupInfo backupInfo : newestBackupPerRootDir.values()) {
            for (TableName table : backupInfo.getTableSetTimestampMap().keySet()) {
                for (Map.Entry<String, Long> entry : backupInfo.getTableSetTimestampMap().get(table).entrySet()) {
                    Address address = Address.fromString((String)entry.getKey());
                    Long storedTs = (Long)boundaries.get(address);
                    if (storedTs != null && entry.getValue() >= storedTs) continue;
                    boundaries.put(address, entry.getValue());
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            for (Map.Entry entry : boundaries.entrySet()) {
                LOG.debug("Server: {}, WAL cleanup boundary: {}", (Object)((Address)entry.getKey()).getHostName(), entry.getValue());
            }
        }
        return boundaries;
    }

    public Iterable<FileStatus> getDeletableFiles(Iterable<FileStatus> files) {
        Map<Address, Long> serverToPreservationBoundaryTs;
        ArrayList<FileStatus> filteredFiles = new ArrayList<FileStatus>();
        if (this.getConf() == null || !BackupManager.isBackupEnabled(this.getConf())) {
            LOG.debug("Backup is not enabled. Check your {} setting", (Object)"hbase.backup.enable");
            return files;
        }
        try (BackupManager backupManager = new BackupManager(this.conn, this.getConf());){
            serverToPreservationBoundaryTs = this.serverToPreservationBoundaryTs(backupManager.getBackupHistory(true));
        }
        catch (IOException ex) {
            LOG.error("Failed to analyse backup history with exception: {}. Retaining all logs", (Object)ex.getMessage(), (Object)ex);
            return Collections.emptyList();
        }
        for (FileStatus file : files) {
            if (!BackupLogCleaner.canDeleteFile(serverToPreservationBoundaryTs, file.getPath())) continue;
            filteredFiles.add(file);
        }
        LOG.info("Total files: {}, Filtered Files: {}", (Object)IterableUtils.size(files), (Object)filteredFiles.size());
        return filteredFiles;
    }

    public void setConf(Configuration config) {
        super.setConf(config);
        if (!config.getBoolean("hbase.backup.enable", false)) {
            LOG.warn("Backup is disabled - allowing all wals to be deleted");
        }
    }

    public void stop(String why) {
        if (!this.stopped) {
            this.stopped = true;
            LOG.info("Stopping BackupLogCleaner");
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    protected static boolean canDeleteFile(Map<Address, Long> addressToBoundaryTs, Path path) {
        if (BackupLogCleaner.isHMasterWAL(path)) {
            return true;
        }
        try {
            String hostname = BackupUtils.parseHostNameFromLogFile(path);
            if (hostname == null) {
                LOG.warn("Cannot parse hostname from RegionServer WAL file: {}. Ignoring cleanup of this log", (Object)path);
                return false;
            }
            Address walServerAddress = Address.fromString((String)hostname);
            long walTimestamp = WAL.getTimestamp((String)path.getName());
            if (!addressToBoundaryTs.containsKey(walServerAddress)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No cleanup WAL time-boundary found for server: {}. Ok to delete file: {}", (Object)walServerAddress.getHostName(), (Object)path);
                }
                return true;
            }
            Long backupBoundary = addressToBoundaryTs.get(walServerAddress);
            if (backupBoundary >= walTimestamp) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("WAL cleanup time-boundary found for server {}: {}. Ok to delete older file: {}", new Object[]{walServerAddress.getHostName(), backupBoundary, path});
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("WAL cleanup time-boundary found for server {}: {}. Keeping younger file: {}", new Object[]{walServerAddress.getHostName(), backupBoundary, path});
            }
        }
        catch (Exception ex) {
            LOG.warn("Error occurred while filtering file: {}. Ignoring cleanup of this log", (Object)path, (Object)ex);
            return false;
        }
        return false;
    }

    private static boolean isHMasterWAL(Path path) {
        String fn = path.getName();
        return fn.startsWith("pv2-") || fn.endsWith("$masterlocalwal$");
    }
}

