/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Hbck;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SharedConnection
implements Connection {
    private final Connection conn;

    public SharedConnection(Connection conn) {
        this.conn = conn;
    }

    public void close() throws IOException {
        throw new UnsupportedOperationException("Shared connection");
    }

    public boolean isClosed() {
        return this.conn.isClosed();
    }

    public void abort(String why, Throwable e) {
        throw new UnsupportedOperationException("Shared connection");
    }

    public boolean isAborted() {
        return this.conn.isAborted();
    }

    public Configuration getConfiguration() {
        return this.conn.getConfiguration();
    }

    public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        return this.conn.getBufferedMutator(tableName);
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
        return this.conn.getBufferedMutator(params);
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        return this.conn.getRegionLocator(tableName);
    }

    public Admin getAdmin() throws IOException {
        return this.conn.getAdmin();
    }

    public TableBuilder getTableBuilder(TableName tableName, ExecutorService pool) {
        return this.conn.getTableBuilder(tableName, pool);
    }

    public void clearRegionLocationCache() {
        this.conn.clearRegionLocationCache();
    }

    public Hbck getHbck() throws IOException {
        return this.conn.getHbck();
    }

    public Hbck getHbck(ServerName masterServer) throws IOException {
        return this.conn.getHbck(masterServer);
    }

    public String getClusterId() {
        return this.conn.getClusterId();
    }
}

