/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.SnapshotProcedure;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDoesNotExistException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class RecoverySnapshotUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RecoverySnapshotUtils.class);

    private RecoverySnapshotUtils() {
    }

    public static boolean isRecoveryEnabled(MasterProcedureEnv env) {
        return env.getMasterConfiguration().getBoolean("hbase.snapshot.before.destructive.action.enabled", false) && env.getMasterConfiguration().getBoolean("hbase.snapshot.enabled", true);
    }

    public static long getRecoverySnapshotTtl(MasterProcedureEnv env, TableDescriptor tableDescriptor) {
        String tableLevelTtl;
        if (tableDescriptor != null && (tableLevelTtl = tableDescriptor.getValue("RECOVERY_SNAPSHOT_TTL")) != null) {
            try {
                long ttl = Long.parseLong(tableLevelTtl);
                LOG.debug("Using table-level recovery snapshot TTL {} seconds for table {}", (Object)ttl, (Object)tableDescriptor.getTableName());
                return ttl;
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid table-level recovery snapshot TTL '{}' for table {}, using default", (Object)tableLevelTtl, (Object)tableDescriptor.getTableName());
            }
        }
        return env.getMasterConfiguration().getLong("hbase.snapshot.before.destructive.action.ttl", 86400L);
    }

    public static String generateSnapshotName(TableName tableName) {
        return RecoverySnapshotUtils.generateSnapshotName(tableName, EnvironmentEdgeManager.currentTime());
    }

    public static String generateSnapshotName(TableName tableName, long timestamp) {
        return "auto_" + tableName.getNameAsString() + "_" + timestamp;
    }

    public static SnapshotProtos.SnapshotDescription buildSnapshotDescription(TableName tableName, String snapshotName) {
        return RecoverySnapshotUtils.buildSnapshotDescription(tableName, snapshotName, 0L, SnapshotProtos.SnapshotDescription.Type.FLUSH);
    }

    public static SnapshotProtos.SnapshotDescription buildSnapshotDescription(TableName tableName, String snapshotName, long ttl, SnapshotProtos.SnapshotDescription.Type type) {
        SnapshotProtos.SnapshotDescription.Builder builder = SnapshotProtos.SnapshotDescription.newBuilder();
        builder.setVersion(2);
        builder.setName(snapshotName);
        builder.setTable(tableName.getNameAsString());
        builder.setType(type);
        builder.setCreationTime(EnvironmentEdgeManager.currentTime());
        builder.setTtl(ttl);
        return builder.build();
    }

    public static SnapshotProcedure createSnapshotProcedure(MasterProcedureEnv env, TableName tableName, String snapshotName, TableDescriptor tableDescriptor) throws IOException {
        return new SnapshotProcedure(env, RecoverySnapshotUtils.buildSnapshotDescription(tableName, snapshotName, RecoverySnapshotUtils.getRecoverySnapshotTtl(env, tableDescriptor), env.getMasterServices().getTableStateManager().isTableState(tableName, TableState.State.DISABLED) ? SnapshotProtos.SnapshotDescription.Type.SKIPFLUSH : SnapshotProtos.SnapshotDescription.Type.FLUSH));
    }

    public static void deleteRecoverySnapshot(MasterProcedureEnv env, String snapshotName, TableName tableName) {
        try {
            LOG.debug("Deleting recovery snapshot {} for table {} during rollback", (Object)snapshotName, (Object)tableName);
            SnapshotManager snapshotManager = env.getMasterServices().getSnapshotManager();
            if (snapshotManager == null) {
                LOG.warn("SnapshotManager is not available, cannot delete recovery snapshot {}", (Object)snapshotName);
                return;
            }
            snapshotManager.deleteSnapshot(RecoverySnapshotUtils.buildSnapshotDescription(tableName, snapshotName));
            LOG.info("Successfully deleted recovery snapshot {} for table {} during rollback", (Object)snapshotName, (Object)tableName);
        }
        catch (SnapshotDoesNotExistException e) {
            LOG.debug("Recovery snapshot {} for table {} does not exist, skipping", (Object)snapshotName, (Object)tableName);
        }
        catch (Exception e) {
            LOG.warn("Failed to delete recovery snapshot {} for table {} during rollback: {}. Manual cleanup may be required.", new Object[]{snapshotName, tableName, e.getMessage()});
        }
    }
}

