/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class SnapshotRegionLocator
implements RegionLocator {
    private static final String SNAPSHOT_MANIFEST_DIR_PREFIX = "region.locator.snapshot.manifest.dir.";
    private static final ServerName FAKE_SERVER_NAME = ServerName.parseServerName((String)"www.example.net,1234,1212121212");
    private final TableName tableName;
    private final TreeMap<byte[], HRegionReplicas> regions;
    private final List<HRegionLocation> rawLocations;

    public static SnapshotRegionLocator create(Configuration conf, TableName table) throws IOException {
        Path workingDir = new Path(conf.get(SnapshotRegionLocator.getSnapshotManifestDirKey(table)));
        FileSystem fs = workingDir.getFileSystem(conf);
        SnapshotProtos.SnapshotDescription desc = SnapshotDescriptionUtils.readSnapshotInfo(fs, workingDir);
        SnapshotManifest manifest = SnapshotManifest.open(conf, fs, workingDir, desc);
        TableName tableName = manifest.getTableDescriptor().getTableName();
        TreeMap<byte[], HRegionReplicas> replicas = new TreeMap<byte[], HRegionReplicas>(Bytes.BYTES_COMPARATOR);
        ArrayList<HRegionLocation> rawLocations = new ArrayList<HRegionLocation>();
        for (SnapshotProtos.SnapshotRegionManifest region : manifest.getRegionManifests()) {
            HBaseProtos.RegionInfo ri = region.getRegionInfo();
            byte[] key = ri.getStartKey().toByteArray();
            SnapshotHRegionLocation location = SnapshotRegionLocator.toLocation(ri, tableName);
            rawLocations.add(location);
            HRegionReplicas hrr = replicas.get(key);
            if (hrr == null) {
                hrr = new HRegionReplicas(location);
            } else {
                hrr.addReplica(location);
            }
            replicas.put(key, hrr);
        }
        return new SnapshotRegionLocator(tableName, replicas, rawLocations);
    }

    private SnapshotRegionLocator(TableName tableName, TreeMap<byte[], HRegionReplicas> regions, List<HRegionLocation> rawLocations) {
        this.tableName = tableName;
        this.regions = regions;
        this.rawLocations = rawLocations;
    }

    public HRegionLocation getRegionLocation(byte[] row, int replicaId, boolean reload) throws IOException {
        return this.regions.floorEntry(row).getValue().getReplica(replicaId);
    }

    public List<HRegionLocation> getRegionLocations(byte[] row, boolean reload) throws IOException {
        return Collections.singletonList(this.getRegionLocation(row, reload));
    }

    public void clearRegionLocationCache() {
    }

    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        return this.rawLocations;
    }

    public TableName getName() {
        return this.tableName;
    }

    public void close() throws IOException {
    }

    public static boolean shouldUseSnapshotRegionLocator(Configuration conf, TableName table) {
        return conf.get(SnapshotRegionLocator.getSnapshotManifestDirKey(table)) != null;
    }

    public static void setSnapshotManifestDir(Configuration conf, String dir, TableName table) {
        conf.set(SnapshotRegionLocator.getSnapshotManifestDirKey(table), dir);
    }

    private static String getSnapshotManifestDirKey(TableName table) {
        return SNAPSHOT_MANIFEST_DIR_PREFIX + table.getNameWithNamespaceInclAsString();
    }

    private static SnapshotHRegionLocation toLocation(HBaseProtos.RegionInfo ri, TableName tableName) {
        RegionInfo region = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(ri.getStartKey().toByteArray()).setEndKey(ri.getEndKey().toByteArray()).setRegionId(ri.getRegionId()).setReplicaId(ri.getReplicaId()).build();
        return new SnapshotHRegionLocation(region);
    }

    public static final class SnapshotHRegionLocation
    extends HRegionLocation {
        public SnapshotHRegionLocation(RegionInfo regionInfo) {
            super(regionInfo, FAKE_SERVER_NAME);
        }

        public ServerName getServerName() {
            throw new NotImplementedException("SnapshotHRegionLocation doesn't have a server name");
        }

        public String getHostname() {
            throw new NotImplementedException("SnapshotHRegionLocation doesn't have a host name");
        }

        public int getPort() {
            throw new NotImplementedException("SnapshotHRegionLocation doesn't have a port");
        }

        public int hashCode() {
            return this.getRegion().hashCode();
        }

        public boolean equals(Object o) {
            return super.equals(o);
        }

        public int compareTo(HRegionLocation o) {
            return this.getRegion().compareTo(o.getRegion());
        }
    }

    private static final class HRegionReplicas {
        private final Map<Integer, SnapshotHRegionLocation> replicas = new HashMap<Integer, SnapshotHRegionLocation>();

        private HRegionReplicas(SnapshotHRegionLocation region) {
            this.addReplica(region);
        }

        private void addReplica(SnapshotHRegionLocation replica) {
            this.replicas.put(replica.getRegion().getReplicaId(), replica);
        }

        private HRegionLocation getReplica(int replicaId) {
            return this.replicas.get(replicaId);
        }
    }
}

