/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, ClientTests.class})
public class TestFlushFromClientWithDisabledFlushProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFlushFromClientWithDisabledFlushProcedure.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFlushFromClientWithDisabledFlushProcedure.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static AsyncConnection asyncConn;
    private static final byte[] FAMILY;
    private static final byte[] QUALIFIER;
    @Rule
    public TestName name = new TestName();
    private TableName tableName;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration configuration = TEST_UTIL.getConfiguration();
        configuration.setBoolean("hbase.flush.procedure.enabled", false);
        TEST_UTIL.startMiniCluster(1);
        asyncConn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        Closeables.close((Closeable)asyncConn, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        try (Table t = TEST_UTIL.createTable(this.tableName, FAMILY);){
            ArrayList<Put> puts = new ArrayList<Put>();
            for (int i = 0; i <= 10; ++i) {
                Put put = new Put(Bytes.toBytes((int)i));
                put.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)i));
                puts.add(put);
            }
            t.put(puts);
        }
        List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(this.tableName);
        Assert.assertFalse((boolean)regions.isEmpty());
    }

    @After
    public void tearDown() throws Exception {
        for (TableDescriptor htd : TEST_UTIL.getAdmin().listTableDescriptors()) {
            LOG.info("Tear down, remove table=" + htd.getTableName());
            TEST_UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test
    public void flushTableWithNonExistingFamily() {
        AsyncAdmin admin = asyncConn.getAdmin();
        ArrayList<byte[]> families = new ArrayList<byte[]>();
        families.add(FAMILY);
        families.add(Bytes.toBytes((String)"non_family01"));
        families.add(Bytes.toBytes((String)"non_family02"));
        Assert.assertFalse((boolean)TEST_UTIL.getConfiguration().getBoolean("hbase.flush.procedure.enabled", true));
        CompletableFuture<Void> future = CompletableFuture.allOf(admin.flush(this.tableName, families));
        Assert.assertThrows(NoSuchColumnFamilyException.class, () -> {
            Void cfr_ignored_0 = (Void)FutureUtils.get((Future)future);
        });
    }

    static {
        FAMILY = Bytes.toBytes((String)"info");
        QUALIFIER = Bytes.toBytes((String)"name");
    }
}

