/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ConnectionRule;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MatcherPredicate;
import org.apache.hadoop.hbase.MiniClusterRule;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.trace.StringTraceRenderer;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.trace.OpenTelemetryClassRule;
import org.apache.hadoop.hbase.trace.OpenTelemetryTestRule;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestResultScannerTracing {
    private static final Logger LOG = LoggerFactory.getLogger(TestResultScannerTracing.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestResultScannerTracing.class);
    private static final TableName TABLE_NAME = TableName.valueOf((String)TestResultScannerTracing.class.getSimpleName());
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] CQ = Bytes.toBytes((String)"q");
    private static final int COUNT = 1000;
    private static final OpenTelemetryClassRule otelClassRule = OpenTelemetryClassRule.create();
    private static final MiniClusterRule miniClusterRule = MiniClusterRule.newBuilder().setMiniClusterOption(StartMiniClusterOption.builder().numRegionServers(3).build()).build();
    private static final ConnectionRule connectionRule = ConnectionRule.createConnectionRule(miniClusterRule::createConnection);
    @ClassRule
    public static final TestRule classRule = RuleChain.outerRule((TestRule)otelClassRule).around((TestRule)miniClusterRule).around((TestRule)connectionRule).around((TestRule)new Setup());
    @Rule
    public final OpenTelemetryTestRule otelTestRule = new OpenTelemetryTestRule(otelClassRule);
    @Rule
    public final TestName testName = new TestName();

    @Before
    public void before() throws Exception {
        Connection conn = connectionRule.getConnection();
        try (RegionLocator locator = conn.getRegionLocator(TABLE_NAME);){
            locator.clearRegionLocationCache();
        }
    }

    private static void waitForSpan(Matcher<SpanData> parentSpanMatcher) {
        Configuration conf = miniClusterRule.getTestingUtility().getConfiguration();
        Waiter.waitFor((Configuration)conf, (long)TimeUnit.SECONDS.toMillis(5L), (Waiter.Predicate)new MatcherPredicate("Span for test failed to complete.", otelClassRule::getSpans, Matchers.hasItem(parentSpanMatcher)));
    }

    private Scan buildDefaultScan() {
        return new Scan().withStartRow(Bytes.toBytes((String)String.format("%03d", 1))).withStopRow(Bytes.toBytes((String)String.format("%03d", 998)));
    }

    private void assertDefaultScan(Scan scan) {
        MatcherAssert.assertThat((Object)scan.isReversed(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)scan.isAsyncPrefetch(), (Matcher)Matchers.nullValue());
    }

    private Scan buildAsyncPrefetchScan() {
        return new Scan().withStartRow(Bytes.toBytes((String)String.format("%03d", 1))).withStopRow(Bytes.toBytes((String)String.format("%03d", 998))).setAsyncPrefetch(true);
    }

    private void assertAsyncPrefetchScan(Scan scan) {
        MatcherAssert.assertThat((Object)scan.isReversed(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)scan.isAsyncPrefetch(), (Matcher)Matchers.is((Object)true));
    }

    private Scan buildReversedScan() {
        return new Scan().withStartRow(Bytes.toBytes((String)String.format("%03d", 998))).withStopRow(Bytes.toBytes((String)String.format("%03d", 1))).setReversed(true);
    }

    private void assertReversedScan(Scan scan) {
        MatcherAssert.assertThat((Object)scan.isReversed(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)scan.isAsyncPrefetch(), (Matcher)Matchers.nullValue());
    }

    private void doScan(Supplier<Scan> spanSupplier, Consumer<Scan> scanAssertions) throws Exception {
        Connection conn = connectionRule.getConnection();
        Scan scan = spanSupplier.get();
        scanAssertions.accept(scan);
        try (Table table = conn.getTable(TABLE_NAME);
             ResultScanner scanner = table.getScanner(scan);){
            ArrayList results = new ArrayList(1000);
            scanner.forEach(results::add);
            MatcherAssert.assertThat(results, (Matcher)Matchers.not((Matcher)Matchers.emptyIterable()));
        }
    }

    @Test
    public void testNormalScan() throws Exception {
        TraceUtil.trace(() -> this.doScan(this::buildDefaultScan, this::assertDefaultScan), (String)this.testName.getMethodName());
        String parentSpanName = this.testName.getMethodName();
        Matcher parentSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)parentSpanName), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded());
        TestResultScannerTracing.waitForSpan((Matcher<SpanData>)parentSpanMatcher);
        List spans = otelClassRule.getSpans().stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (LOG.isDebugEnabled()) {
            StringTraceRenderer stringTraceRenderer = new StringTraceRenderer(spans);
            stringTraceRenderer.render(arg_0 -> ((Logger)LOG).debug(arg_0));
        }
        String parentSpanId = spans.stream().filter(arg_0 -> ((Matcher)parentSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().orElseThrow(AssertionError::new);
        Matcher scanOperationSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)("SCAN " + TABLE_NAME.getNameWithNamespaceInclAsString()))), (Matcher)SpanDataMatchers.hasParentSpanId((String)parentSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded());
        MatcherAssert.assertThat(spans, (Matcher)Matchers.hasItem((Matcher)scanOperationSpanMatcher));
        String scanOperationSpanId = spans.stream().filter(arg_0 -> ((Matcher)scanOperationSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().orElseThrow(AssertionError::new);
        Matcher childMetaScanSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"SCAN hbase:meta")), (Matcher)SpanDataMatchers.hasParentSpanId((String)scanOperationSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded());
        MatcherAssert.assertThat((String)"expected a scan of hbase:meta", spans, (Matcher)Matchers.hasItem((Matcher)childMetaScanSpanMatcher));
    }

    @Test
    public void testAsyncPrefetchScan() throws Exception {
        TraceUtil.trace(() -> this.doScan(this::buildAsyncPrefetchScan, this::assertAsyncPrefetchScan), (String)this.testName.getMethodName());
        String parentSpanName = this.testName.getMethodName();
        Matcher parentSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)parentSpanName), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded());
        TestResultScannerTracing.waitForSpan((Matcher<SpanData>)parentSpanMatcher);
        List spans = otelClassRule.getSpans().stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (LOG.isDebugEnabled()) {
            StringTraceRenderer stringTraceRenderer = new StringTraceRenderer(spans);
            stringTraceRenderer.render(arg_0 -> ((Logger)LOG).debug(arg_0));
        }
        String parentSpanId = spans.stream().filter(arg_0 -> ((Matcher)parentSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().orElseThrow(AssertionError::new);
        Matcher scanOperationSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)("SCAN " + TABLE_NAME.getNameWithNamespaceInclAsString()))), (Matcher)SpanDataMatchers.hasParentSpanId((String)parentSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded());
        MatcherAssert.assertThat(spans, (Matcher)Matchers.hasItem((Matcher)scanOperationSpanMatcher));
        String scanOperationSpanId = spans.stream().filter(arg_0 -> ((Matcher)scanOperationSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().orElseThrow(AssertionError::new);
        Matcher childMetaScanSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"SCAN hbase:meta")), (Matcher)SpanDataMatchers.hasParentSpanId((String)scanOperationSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded());
        MatcherAssert.assertThat((String)"expected a scan of hbase:meta", spans, (Matcher)Matchers.hasItem((Matcher)childMetaScanSpanMatcher));
    }

    @Test
    public void testReversedScan() throws Exception {
        TraceUtil.trace(() -> this.doScan(this::buildReversedScan, this::assertReversedScan), (String)this.testName.getMethodName());
        String parentSpanName = this.testName.getMethodName();
        Matcher parentSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)parentSpanName), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded());
        TestResultScannerTracing.waitForSpan((Matcher<SpanData>)parentSpanMatcher);
        List spans = otelClassRule.getSpans().stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (LOG.isDebugEnabled()) {
            StringTraceRenderer stringTraceRenderer = new StringTraceRenderer(spans);
            stringTraceRenderer.render(arg_0 -> ((Logger)LOG).debug(arg_0));
        }
        String parentSpanId = spans.stream().filter(arg_0 -> ((Matcher)parentSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().orElseThrow(AssertionError::new);
        Matcher scanOperationSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)("SCAN " + TABLE_NAME.getNameWithNamespaceInclAsString()))), (Matcher)SpanDataMatchers.hasParentSpanId((String)parentSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded());
        MatcherAssert.assertThat(spans, (Matcher)Matchers.hasItem((Matcher)scanOperationSpanMatcher));
        String scanOperationSpanId = spans.stream().filter(arg_0 -> ((Matcher)scanOperationSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().orElseThrow(AssertionError::new);
        Matcher childMetaScanSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"SCAN hbase:meta")), (Matcher)SpanDataMatchers.hasParentSpanId((String)scanOperationSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded());
        MatcherAssert.assertThat((String)"expected a scan of hbase:meta", spans, (Matcher)Matchers.hasItem((Matcher)childMetaScanSpanMatcher));
    }

    private static final class Setup
    extends ExternalResource {
        private Connection conn;

        private Setup() {
        }

        protected void before() throws Throwable {
            HBaseTestingUtility testUtil = miniClusterRule.getTestingUtility();
            this.conn = testUtil.getConnection();
            byte[][] splitKeys = new byte[8][];
            for (int i2 = 111; i2 < 999; i2 += 111) {
                splitKeys[i2 / 111 - 1] = Bytes.toBytes((String)String.format("%03d", i2));
            }
            testUtil.createTable(TABLE_NAME, FAMILY, (byte[][])splitKeys);
            testUtil.waitTableAvailable(TABLE_NAME);
            try (Table table = this.conn.getTable(TABLE_NAME);){
                table.put(IntStream.range(0, 1000).mapToObj(i -> new Put(Bytes.toBytes((String)String.format("%03d", i))).addColumn(FAMILY, CQ, Bytes.toBytes((int)i))).collect(Collectors.toList()));
            }
        }

        protected void after() {
            try (Admin admin = this.conn.getAdmin();){
                if (!admin.tableExists(TABLE_NAME)) {
                    return;
                }
                admin.disableTable(TABLE_NAME);
                admin.deleteTable(TABLE_NAME);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

