/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.testing.junit4.OpenTelemetryRule;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MatcherPredicate;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.trace.hamcrest.AttributesMatchers;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.BadAuthException;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.ipc.FailingNettyRpcServer;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.HBaseRpcControllerImpl;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerFactory;
import org.apache.hadoop.hbase.ipc.SimpleRpcServer;
import org.apache.hadoop.hbase.ipc.SimpleServerRpcConnection;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegistryProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingRpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestIPC {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestIPC.class);
    private static final byte[] CELL_BYTES = Bytes.toBytes((String)"xyz");
    private static final KeyValue CELL = new KeyValue(CELL_BYTES, CELL_BYTES, CELL_BYTES, CELL_BYTES);
    protected static final Configuration CONF = HBaseConfiguration.create();
    @Rule
    public OpenTelemetryRule traceRule = OpenTelemetryRule.create();
    @Parameterized.Parameter(value=0)
    public Class<? extends RpcServer> rpcServerImpl;

    protected RpcServer createRpcServer(Server server, String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler) throws IOException {
        return RpcServerFactory.createRpcServer((Server)server, (String)name, services, (InetSocketAddress)bindAddress, (Configuration)conf, (RpcScheduler)scheduler);
    }

    private RpcServer createRpcServer(String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler) throws IOException {
        return this.createRpcServer(null, name, services, bindAddress, conf, scheduler);
    }

    protected abstract AbstractRpcClient<?> createRpcClientNoCodec(Configuration var1);

    @Before
    public void setUpBeforeTest() {
        CONF.setClass("hbase.rpc.server.impl", this.rpcServerImpl, RpcServer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoCodec() throws IOException, ServiceException {
        Configuration clientConf = new Configuration(CONF);
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try (AbstractRpcClient<?> client = this.createRpcClientNoCodec(clientConf);){
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(client, rpcServer.getListenerAddress());
            HBaseRpcControllerImpl pcrc = new HBaseRpcControllerImpl();
            String message = "hello";
            Assert.assertEquals((Object)message, (Object)stub.echo((RpcController)pcrc, TestProtos.EchoRequestProto.newBuilder().setMessage(message).build()).getMessage());
            Assert.assertNull((Object)pcrc.cellScanner());
        }
        finally {
            rpcServer.stop();
        }
    }

    protected abstract AbstractRpcClient<?> createRpcClient(Configuration var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompressCellBlock() throws IOException, ServiceException {
        Configuration clientConf = new Configuration(CONF);
        clientConf.set("hbase.client.rpc.compressor", GzipCodec.class.getCanonicalName());
        ArrayList<KeyValue> cells = new ArrayList<KeyValue>();
        int count = 3;
        for (int i = 0; i < count; ++i) {
            cells.add(CELL);
        }
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try (AbstractRpcClient<?> client = this.createRpcClient(clientConf);){
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(client, rpcServer.getListenerAddress());
            HBaseRpcControllerImpl pcrc = new HBaseRpcControllerImpl(CellUtil.createCellScanner(cells));
            String message = "hello";
            Assert.assertEquals((Object)message, (Object)stub.echo((RpcController)pcrc, TestProtos.EchoRequestProto.newBuilder().setMessage(message).build()).getMessage());
            int index = 0;
            CellScanner cellScanner = pcrc.cellScanner();
            Assert.assertNotNull((Object)cellScanner);
            while (cellScanner.advance()) {
                Assert.assertEquals((Object)CELL, (Object)cellScanner.current());
                ++index;
            }
            Assert.assertEquals((long)count, (long)index);
        }
        finally {
            rpcServer.stop();
        }
    }

    protected abstract AbstractRpcClient<?> createRpcClientRTEDuringConnectionSetup(Configuration var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRTEDuringConnectionSetup() throws Exception {
        Configuration clientConf = new Configuration(CONF);
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try (AbstractRpcClient<?> client = this.createRpcClientRTEDuringConnectionSetup(clientConf);){
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(client, rpcServer.getListenerAddress());
            stub.ping(null, TestProtos.EmptyRequestProto.getDefaultInstance());
            Assert.fail((String)"Expected an exception to have been thrown!");
        }
        catch (Exception e) {
            LOG.info("Caught expected exception: " + e.toString());
            Assert.assertTrue((String)e.toString(), (boolean)StringUtils.stringifyException((Throwable)e).contains("Injected fault"));
        }
        finally {
            rpcServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRpcScheduler() throws IOException, ServiceException, InterruptedException {
        Configuration clientConf = new Configuration(CONF);
        RpcScheduler scheduler = (RpcScheduler)Mockito.spy((Object)new FifoRpcScheduler(CONF, 1));
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, scheduler);
        ((RpcScheduler)Mockito.verify((Object)scheduler)).init((RpcScheduler.Context)ArgumentMatchers.any(RpcScheduler.Context.class));
        try (AbstractRpcClient<?> client = this.createRpcClient(clientConf);){
            rpcServer.start();
            ((RpcScheduler)Mockito.verify((Object)scheduler)).start();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(client, rpcServer.getListenerAddress());
            TestProtos.EchoRequestProto param = TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build();
            for (int i = 0; i < 10; ++i) {
                stub.echo(null, param);
            }
            ((RpcScheduler)Mockito.verify((Object)scheduler, (VerificationMode)VerificationModeFactory.times((int)10))).dispatch((CallRunner)ArgumentMatchers.any(CallRunner.class));
        }
        finally {
            rpcServer.stop();
            ((RpcScheduler)Mockito.verify((Object)scheduler)).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRpcMaxRequestSize() throws IOException, ServiceException {
        Configuration clientConf = new Configuration(CONF);
        clientConf.setInt("hbase.ipc.max.request.size", 1000);
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), clientConf, (RpcScheduler)new FifoRpcScheduler(clientConf, 1));
        try (AbstractRpcClient<?> client = this.createRpcClient(clientConf);){
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(client, rpcServer.getListenerAddress());
            StringBuilder message = new StringBuilder(1200);
            for (int i = 0; i < 200; ++i) {
                message.append("hello.");
            }
            TestProtos.EchoRequestProto param = TestProtos.EchoRequestProto.newBuilder().setMessage(message.toString()).build();
            stub.echo((RpcController)new HBaseRpcControllerImpl(CellUtil.createCellScanner((Iterable)ImmutableList.of((Object)CELL))), param);
            Assert.fail((String)"RPC should have failed because it exceeds max request size");
        }
        catch (ServiceException e) {
            LOG.info("Caught expected exception: " + (Object)((Object)e));
            Assert.assertTrue((String)e.toString(), (boolean)StringUtils.stringifyException((Throwable)e).contains("RequestTooBigException"));
        }
        finally {
            rpcServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRpcServerForNotNullRemoteAddressInCallObject() throws IOException, ServiceException {
        Configuration clientConf = new Configuration(CONF);
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        InetSocketAddress localAddr = new InetSocketAddress("localhost", 0);
        try (AbstractRpcClient<?> client = this.createRpcClient(clientConf);){
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(client, rpcServer.getListenerAddress());
            Assert.assertEquals((Object)localAddr.getAddress().getHostAddress(), (Object)stub.addr(null, TestProtos.EmptyRequestProto.getDefaultInstance()).getAddr());
        }
        finally {
            rpcServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoteError() throws IOException, ServiceException {
        Configuration clientConf = new Configuration(CONF);
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try (AbstractRpcClient<?> client = this.createRpcClient(clientConf);){
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(client, rpcServer.getListenerAddress());
            stub.error(null, TestProtos.EmptyRequestProto.getDefaultInstance());
        }
        catch (ServiceException e) {
            LOG.info("Caught expected exception: " + (Object)((Object)e));
            IOException ioe = ProtobufUtil.handleRemoteException((Exception)((Object)e));
            Assert.assertTrue((boolean)(ioe instanceof DoNotRetryIOException));
            Assert.assertTrue((boolean)ioe.getMessage().contains("server error!"));
        }
        finally {
            rpcServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeout() throws IOException {
        Configuration clientConf = new Configuration(CONF);
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try (AbstractRpcClient<?> client = this.createRpcClient(clientConf);){
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(client, rpcServer.getListenerAddress());
            HBaseRpcControllerImpl pcrc = new HBaseRpcControllerImpl();
            int ms = 1000;
            int timeout = 100;
            for (int i = 0; i < 10; ++i) {
                pcrc.reset();
                pcrc.setCallTimeout(timeout);
                long startTime = System.nanoTime();
                try {
                    stub.pause((RpcController)pcrc, TestProtos.PauseRequestProto.newBuilder().setMs(ms).build());
                    continue;
                }
                catch (ServiceException e) {
                    long waitTime = (System.nanoTime() - startTime) / 1000000L;
                    LOG.info("Caught expected exception: " + (Object)((Object)e));
                    IOException ioe = ProtobufUtil.handleRemoteException((Exception)((Object)e));
                    Assert.assertTrue((boolean)(ioe.getCause() instanceof CallTimeoutException));
                    Assert.assertTrue((waitTime < (long)ms ? 1 : 0) != 0);
                }
            }
        }
        finally {
            rpcServer.stop();
        }
    }

    protected RpcServer createTestFailingRpcServer(String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler) throws IOException {
        if (this.rpcServerImpl.equals(NettyRpcServer.class)) {
            return new FailingNettyRpcServer(null, name, services, bindAddress, conf, scheduler);
        }
        return new FailingSimpleRpcServer(null, name, services, bindAddress, conf, scheduler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionCloseWithOutstandingRPCs() throws InterruptedException, IOException {
        Configuration clientConf = new Configuration(CONF);
        RpcServer rpcServer = this.createTestFailingRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try (AbstractRpcClient<?> client = this.createRpcClient(clientConf);){
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(client, rpcServer.getListenerAddress());
            TestProtos.EchoRequestProto param = TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build();
            stub.echo(null, param);
            Assert.fail((String)"RPC should have failed because connection closed");
        }
        catch (ServiceException e) {
            LOG.info("Caught expected exception: " + e.toString());
        }
        finally {
            rpcServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncEcho() throws IOException {
        Configuration clientConf = new Configuration(CONF);
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try (AbstractRpcClient<?> client = this.createRpcClient(clientConf);){
            int i;
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.Interface stub = TestProtobufRpcServiceImpl.newStub(client, rpcServer.getListenerAddress());
            int num = 10;
            ArrayList<HBaseRpcControllerImpl> pcrcList = new ArrayList<HBaseRpcControllerImpl>();
            ArrayList<BlockingRpcCallback> callbackList = new ArrayList<BlockingRpcCallback>();
            for (i = 0; i < num; ++i) {
                HBaseRpcControllerImpl pcrc = new HBaseRpcControllerImpl();
                BlockingRpcCallback done = new BlockingRpcCallback();
                stub.echo((RpcController)pcrc, TestProtos.EchoRequestProto.newBuilder().setMessage("hello-" + i).build(), (RpcCallback)done);
                pcrcList.add(pcrc);
                callbackList.add(done);
            }
            for (i = 0; i < num; ++i) {
                TestProtos.EchoResponseProto resp = (TestProtos.EchoResponseProto)((BlockingRpcCallback)callbackList.get(i)).get();
                HBaseRpcController pcrc = (HBaseRpcController)pcrcList.get(i);
                Assert.assertEquals((Object)("hello-" + i), (Object)resp.getMessage());
                Assert.assertFalse((boolean)pcrc.failed());
                Assert.assertNull((Object)pcrc.cellScanner());
            }
        }
        finally {
            rpcServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncRemoteError() throws IOException {
        Configuration clientConf = new Configuration(CONF);
        AbstractRpcClient<?> client = this.createRpcClient(clientConf);
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try {
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.Interface stub = TestProtobufRpcServiceImpl.newStub(client, rpcServer.getListenerAddress());
            BlockingRpcCallback callback = new BlockingRpcCallback();
            HBaseRpcControllerImpl pcrc = new HBaseRpcControllerImpl();
            stub.error((RpcController)pcrc, TestProtos.EmptyRequestProto.getDefaultInstance(), (RpcCallback)callback);
            Assert.assertNull((Object)callback.get());
            Assert.assertTrue((boolean)pcrc.failed());
            LOG.info("Caught expected exception: " + pcrc.getFailed());
            IOException ioe = ProtobufUtil.handleRemoteException((Exception)pcrc.getFailed());
            Assert.assertTrue((boolean)(ioe instanceof DoNotRetryIOException));
            Assert.assertTrue((boolean)ioe.getMessage().contains("server error!"));
        }
        finally {
            client.close();
            rpcServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncTimeout() throws IOException {
        Configuration clientConf = new Configuration(CONF);
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try (AbstractRpcClient<?> client = this.createRpcClient(clientConf);){
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.Interface stub = TestProtobufRpcServiceImpl.newStub(client, rpcServer.getListenerAddress());
            ArrayList<HBaseRpcControllerImpl> pcrcList = new ArrayList<HBaseRpcControllerImpl>();
            ArrayList<BlockingRpcCallback> callbackList = new ArrayList<BlockingRpcCallback>();
            int ms = 1000;
            int timeout = 100;
            long startTime = System.nanoTime();
            for (int i = 0; i < 10; ++i) {
                HBaseRpcControllerImpl pcrc = new HBaseRpcControllerImpl();
                pcrc.setCallTimeout(timeout);
                BlockingRpcCallback callback = new BlockingRpcCallback();
                stub.pause((RpcController)pcrc, TestProtos.PauseRequestProto.newBuilder().setMs(ms).build(), (RpcCallback)callback);
                pcrcList.add(pcrc);
                callbackList.add(callback);
            }
            for (BlockingRpcCallback callback : callbackList) {
                Assert.assertNull((Object)callback.get());
            }
            long waitTime = (System.nanoTime() - startTime) / 1000000L;
            for (HBaseRpcController hBaseRpcController : pcrcList) {
                Assert.assertTrue((boolean)hBaseRpcController.failed());
                LOG.info("Caught expected exception: " + hBaseRpcController.getFailed());
                IOException ioe = ProtobufUtil.handleRemoteException((Exception)hBaseRpcController.getFailed());
                Assert.assertTrue((boolean)(ioe.getCause() instanceof CallTimeoutException));
            }
            Assert.assertTrue((waitTime < (long)ms ? 1 : 0) != 0);
        }
        finally {
            rpcServer.stop();
        }
    }

    private SpanData waitSpan(Matcher<SpanData> matcher) {
        Waiter.waitFor((Configuration)CONF, (long)1000L, (Waiter.Predicate)new MatcherPredicate(() -> this.traceRule.getSpans(), Matchers.hasItem(matcher)));
        return this.traceRule.getSpans().stream().filter(arg_0 -> matcher.matches(arg_0)).findFirst().orElseThrow(AssertionError::new);
    }

    private static String buildIpcSpanName(String packageAndService, String methodName) {
        return packageAndService + "/" + methodName;
    }

    private static Matcher<SpanData> buildIpcClientSpanMatcher(String packageAndService, String methodName) {
        return Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)AbstractTestIPC.buildIpcSpanName(packageAndService, methodName)), (Matcher)SpanDataMatchers.hasKind((SpanKind)SpanKind.CLIENT));
    }

    private static Matcher<SpanData> buildIpcServerSpanMatcher(String packageAndService, String methodName) {
        return Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)AbstractTestIPC.buildIpcSpanName(packageAndService, methodName)), (Matcher)SpanDataMatchers.hasKind((SpanKind)SpanKind.SERVER));
    }

    private static Matcher<SpanData> buildIpcClientSpanAttributesMatcher(String packageAndService, String methodName, InetSocketAddress isa) {
        return SpanDataMatchers.hasAttributes((Matcher)Matchers.allOf((Matcher)AttributesMatchers.containsEntry((String)"rpc.system", (String)"HBASE_RPC"), (Matcher)AttributesMatchers.containsEntry((String)"rpc.service", (String)packageAndService), (Matcher)AttributesMatchers.containsEntry((String)"rpc.method", (String)methodName), (Matcher)AttributesMatchers.containsEntry((String)"net.peer.name", (String)isa.getHostName()), (Matcher)AttributesMatchers.containsEntry((AttributeKey)AttributeKey.longKey((String)"net.peer.port"), (Object)isa.getPort())));
    }

    private static Matcher<SpanData> buildIpcServerSpanAttributesMatcher(String packageAndService, String methodName) {
        return SpanDataMatchers.hasAttributes((Matcher)Matchers.allOf((Matcher)AttributesMatchers.containsEntry((String)"rpc.system", (String)"HBASE_RPC"), (Matcher)AttributesMatchers.containsEntry((String)"rpc.service", (String)packageAndService), (Matcher)AttributesMatchers.containsEntry((String)"rpc.method", (String)methodName)));
    }

    private void assertRemoteSpan() {
        SpanData data = this.waitSpan((Matcher<SpanData>)SpanDataMatchers.hasName((String)"RpcServer.process"));
        Assert.assertTrue((boolean)data.getParentSpanContext().isRemote());
        Assert.assertEquals((Object)SpanKind.SERVER, (Object)data.getKind());
    }

    @Test
    public void testTracingSuccessIpc() throws IOException, ServiceException {
        Configuration clientConf = new Configuration(CONF);
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try (AbstractRpcClient<?> client = this.createRpcClient(clientConf);){
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(client, rpcServer.getListenerAddress());
            stub.pause(null, TestProtos.PauseRequestProto.newBuilder().setMs(100).build());
            InetSocketAddress isa = rpcServer.getListenerAddress();
            SpanData pauseClientSpan = this.waitSpan(AbstractTestIPC.buildIpcClientSpanMatcher("hbase.test.pb.TestProtobufRpcProto", "pause"));
            MatcherAssert.assertThat((Object)pauseClientSpan, AbstractTestIPC.buildIpcClientSpanAttributesMatcher("hbase.test.pb.TestProtobufRpcProto", "pause", isa));
            SpanData pauseServerSpan = this.waitSpan(AbstractTestIPC.buildIpcServerSpanMatcher("hbase.test.pb.TestProtobufRpcProto", "pause"));
            MatcherAssert.assertThat((Object)pauseServerSpan, AbstractTestIPC.buildIpcServerSpanAttributesMatcher("hbase.test.pb.TestProtobufRpcProto", "pause"));
            this.assertRemoteSpan();
            Assert.assertFalse((String)"no spans provided", (boolean)this.traceRule.getSpans().isEmpty());
            MatcherAssert.assertThat((Object)this.traceRule.getSpans(), (Matcher)Matchers.everyItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasTraceId((String)((SpanData)this.traceRule.getSpans().iterator().next()).getTraceId()), (Matcher)SpanDataMatchers.hasDuration((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Duration.ofMillis(100L))))));
        }
    }

    @Test
    public void testTracingErrorIpc() throws IOException {
        Configuration clientConf = new Configuration(CONF);
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try (AbstractRpcClient<?> client = this.createRpcClient(clientConf);){
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(client, rpcServer.getListenerAddress());
            Assert.assertThrows(ServiceException.class, () -> stub.error(null, TestProtos.EmptyRequestProto.getDefaultInstance()));
            InetSocketAddress isa = rpcServer.getListenerAddress();
            SpanData errorClientSpan = this.waitSpan(AbstractTestIPC.buildIpcClientSpanMatcher("hbase.test.pb.TestProtobufRpcProto", "error"));
            MatcherAssert.assertThat((Object)errorClientSpan, AbstractTestIPC.buildIpcClientSpanAttributesMatcher("hbase.test.pb.TestProtobufRpcProto", "error", isa));
            SpanData errorServerSpan = this.waitSpan(AbstractTestIPC.buildIpcServerSpanMatcher("hbase.test.pb.TestProtobufRpcProto", "error"));
            MatcherAssert.assertThat((Object)errorServerSpan, AbstractTestIPC.buildIpcServerSpanAttributesMatcher("hbase.test.pb.TestProtobufRpcProto", "error"));
            this.assertRemoteSpan();
            Assert.assertFalse((String)"no spans provided", (boolean)this.traceRule.getSpans().isEmpty());
            MatcherAssert.assertThat((Object)this.traceRule.getSpans(), (Matcher)Matchers.everyItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.ERROR), (Matcher)SpanDataMatchers.hasTraceId((String)((SpanData)this.traceRule.getSpans().iterator().next()).getTraceId()))));
        }
    }

    protected abstract AbstractRpcClient<?> createBadAuthRpcClient(Configuration var1);

    private IOException doBadPreableHeaderCall(TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub) {
        ServiceException se = (ServiceException)Assert.assertThrows(ServiceException.class, () -> stub.echo(null, TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build()));
        return ProtobufUtil.handleRemoteException((Exception)((Object)se));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadPreambleHeader() throws Exception {
        Configuration clientConf = new Configuration(CONF);
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Collections.emptyList(), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try (AbstractRpcClient<?> client = this.createBadAuthRpcClient(clientConf);){
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(client, rpcServer.getListenerAddress());
            BadAuthException error = null;
            for (int i = 0; i < 10; ++i) {
                IOException ioe = this.doBadPreableHeaderCall(stub);
                if (ioe instanceof BadAuthException) {
                    error = (BadAuthException)ioe;
                    break;
                }
                Thread.sleep(100L);
            }
            Assert.assertNotNull((String)"Can not get expected BadAuthException", error);
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"authName=unknown"));
        }
        finally {
            rpcServer.stop();
        }
    }

    @Test
    public void testGetConnectionRegistry() throws IOException, ServiceException {
        Configuration clientConf = new Configuration(CONF);
        String clusterId = "test_cluster_id";
        HRegionServer server = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)server.getClusterId()).thenReturn((Object)clusterId);
        RpcServer rpcServer = this.createRpcServer((Server)server, "testRpcServer", Collections.emptyList(), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try (AbstractRpcClient<?> client = this.createRpcClient(clientConf);){
            rpcServer.start();
            InetSocketAddress addr = rpcServer.getListenerAddress();
            BlockingRpcChannel channel = client.createBlockingRpcChannel(ServerName.valueOf((String)addr.getHostName(), (int)addr.getPort(), (long)EnvironmentEdgeManager.currentTime()), User.getCurrent(), 0);
            RegistryProtos.ConnectionRegistryService.BlockingInterface stub = RegistryProtos.ConnectionRegistryService.newBlockingStub((BlockingRpcChannel)channel);
            RegistryProtos.GetConnectionRegistryResponse resp = stub.getConnectionRegistry(null, RegistryProtos.GetConnectionRegistryRequest.getDefaultInstance());
            Assert.assertEquals((Object)clusterId, (Object)resp.getClusterId());
        }
    }

    @Test
    public void testGetConnectionRegistryError() throws IOException, ServiceException {
        Configuration clientConf = new Configuration(CONF);
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Collections.emptyList(), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try (AbstractRpcClient<?> client = this.createRpcClient(clientConf);){
            rpcServer.start();
            InetSocketAddress addr = rpcServer.getListenerAddress();
            RpcChannel channel = client.createRpcChannel(ServerName.valueOf((String)addr.getHostName(), (int)addr.getPort(), (long)EnvironmentEdgeManager.currentTime()), User.getCurrent(), 0);
            RegistryProtos.ConnectionRegistryService.Stub stub = RegistryProtos.ConnectionRegistryService.newStub((RpcChannel)channel);
            HBaseRpcControllerImpl pcrc = new HBaseRpcControllerImpl();
            BlockingRpcCallback done = new BlockingRpcCallback();
            stub.getConnectionRegistry((RpcController)pcrc, RegistryProtos.GetConnectionRegistryRequest.getDefaultInstance(), (RpcCallback)done);
            Assert.assertNull((Object)done.get());
            Assert.assertTrue((boolean)pcrc.failed());
            MatcherAssert.assertThat((Object)pcrc.getFailed(), (Matcher)Matchers.instanceOf(RemoteException.class));
            Assert.assertEquals((Object)FatalConnectionException.class.getName(), (Object)((RemoteException)((Object)pcrc.getFailed())).getClassName());
            MatcherAssert.assertThat((Object)pcrc.getFailed().getMessage(), (Matcher)Matchers.startsWith((String)"Expected HEADER="));
        }
    }

    private static class FailingSimpleRpcServer
    extends SimpleRpcServer {
        FailingSimpleRpcServer(Server server, String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler) throws IOException {
            super(server, name, services, bindAddress, conf, scheduler, true);
        }

        protected SimpleServerRpcConnection getConnection(SocketChannel channel, long time) {
            return new FailingConnection(this, channel, time);
        }

        final class FailingConnection
        extends SimpleServerRpcConnection {
            private FailingConnection(FailingSimpleRpcServer rpcServer, SocketChannel channel, long lastContact) {
                super((SimpleRpcServer)rpcServer, channel, lastContact);
            }

            public void processRequest(ByteBuff buf) throws IOException, InterruptedException {
                throw new DoNotRetryIOException("Failing for test");
            }
        }
    }
}

