/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServer;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestSecurityRpcSentBytesMetrics {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSecurityRpcSentBytesMetrics.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static final File KEYTAB_FILE = new File(TEST_UTIL.getDataTestDir("keytab").toUri().getPath());
    protected static MiniKdc KDC;
    protected static String HOST;
    protected static String PRINCIPAL;
    protected String krbKeytab;
    protected String krbPrincipal;
    protected UserGroupInformation ugi;
    protected Configuration clientConf;
    protected Configuration serverConf;

    protected static void initKDCAndConf() throws Exception {
        KDC = TEST_UTIL.setupMiniKdc(KEYTAB_FILE);
        PRINCIPAL = "hbase/" + HOST;
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL});
        HBaseKerberosUtils.setPrincipalForTesting((String)(PRINCIPAL + "@" + KDC.getRealm()));
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.socket.timeout.read", 2000000000);
        TEST_UTIL.getConfiguration().setInt("hbase.security.relogin.maxretries", 1);
    }

    protected static void stopKDC() throws InterruptedException {
        if (KDC != null) {
            KDC.stop();
        }
    }

    protected final void setUpPrincipalAndConf() throws Exception {
        this.krbKeytab = HBaseKerberosUtils.getKeytabFileForTesting();
        this.krbPrincipal = HBaseKerberosUtils.getPrincipalForTesting();
        this.ugi = HBaseKerberosUtils.loginKerberosPrincipal((String)this.krbKeytab, (String)this.krbPrincipal);
        this.clientConf = new Configuration(TEST_UTIL.getConfiguration());
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)this.clientConf);
        this.serverConf = new Configuration(TEST_UTIL.getConfiguration());
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)this.serverConf);
    }

    @BeforeClass
    public static void setUp() throws Exception {
        TestSecurityRpcSentBytesMetrics.initKDCAndConf();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestSecurityRpcSentBytesMetrics.stopKDC();
        TEST_UTIL.cleanupTestDir();
    }

    @Before
    public void setUpTest() throws Exception {
        this.setUpPrincipalAndConf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        SecurityInfo securityInfoMock = (SecurityInfo)Mockito.mock(SecurityInfo.class);
        Mockito.when((Object)securityInfoMock.getServerPrincipals()).thenReturn(Collections.singletonList("hbase.regionserver.kerberos.principal"));
        SecurityInfo.addInfo((String)"TestProtobufRpcProto", (SecurityInfo)securityInfoMock);
        NettyRpcServer rpcServer = new NettyRpcServer(null, this.getClass().getSimpleName(), Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress(HOST, 0), this.serverConf, (RpcScheduler)new FifoRpcScheduler(this.serverConf, 1), true){

            public void start() {
                this.metrics = (MetricsHBaseServer)Mockito.spy((Object)this.metrics);
                super.start();
            }
        };
        rpcServer.start();
        try (NettyRpcClient rpcClient = new NettyRpcClient(this.clientConf, HConstants.DEFAULT_CLUSTER_ID.toString(), null, null);){
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub((RpcClient)rpcClient, rpcServer.getListenerAddress(), User.create((UserGroupInformation)UserGroupInformation.getCurrentUser()));
            String response = stub.echo(null, TestProtos.EchoRequestProto.newBuilder().setMessage("test").build()).getMessage();
            Assert.assertTrue((boolean)"test".equals(response));
        }
        finally {
            rpcServer.stop();
        }
        ((MetricsHBaseServer)Mockito.verify((Object)rpcServer.metrics, (VerificationMode)Mockito.atLeast((int)2))).sentBytes(Mockito.anyLong());
    }

    static {
        HOST = "localhost";
    }
}

