/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.Optional;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionServerHostingReplicaSlowOpenCoprocessor
implements RegionCoprocessor,
RegionObserver {
    private static final Logger LOG = LoggerFactory.getLogger(RegionServerHostingReplicaSlowOpenCoprocessor.class);
    static volatile boolean slowDownReplicaOpen = false;

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        int replicaId = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getReplicaId();
        if (replicaId != 0) {
            while (slowDownReplicaOpen) {
                LOG.info("Slow down replica region open a bit");
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException ignored) {
                    return;
                }
            }
        }
    }
}

