/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.DummyMetricsStochasticBalancer;
import org.apache.hadoop.hbase.master.balancer.MetricsStochasticBalancer;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalancerTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(BalancerTestBase.class);
    static int regionId = 0;
    protected static Configuration conf;
    protected static StochasticLoadBalancer loadBalancer;
    protected static DummyMetricsStochasticBalancer dummyMetricsStochasticBalancer;
    protected int[] largeCluster = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56};
    protected int[][] clusterStateMocks = new int[][]{{0}, {1}, {10}, {0, 0}, {2, 0}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {1, 1}, {0, 1}, {10, 1}, {514, 1432}, {48, 53}, {0, 1, 2}, {1, 2, 3}, {0, 2, 2}, {0, 3, 0}, {0, 4, 0}, {20, 20, 0}, {0, 1, 2, 3}, {4, 0, 0, 0}, {5, 0, 0, 0}, {6, 6, 0, 0}, {6, 2, 0, 0}, {6, 1, 0, 0}, {6, 0, 0, 0}, {4, 4, 4, 7}, {4, 4, 4, 8}, {0, 0, 0, 7}, {1, 1, 1, 1, 4}, {1500, 500, 500, 500, 10, 0}, {1500, 500, 500, 500, 500, 0}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 10}, {6, 6, 5, 6, 6, 6, 6, 6, 6, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 54}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 55}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 56}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 16}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 8}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 9}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 10}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 123}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 155}, {10, 7, 12, 8, 11, 10, 9, 14}, {13, 14, 6, 10, 10, 10, 8, 10}, {130, 14, 60, 10, 100, 10, 80, 10}, {130, 140, 60, 100, 100, 100, 80, 100}, {0, 5, 5, 5, 5}, this.largeCluster};
    protected int[][] clusterStateMocksWithNoSlop = new int[][]{{0}, {1}, {10}, {0, 0}, {2, 1}, {2, 2}, {2, 3}, {1, 1}, {80, 120}, {1428, 1432}, {100, 90, 120, 90, 110, 100, 90, 120}};
    protected int[][] clusterStateMocksWithSlop = new int[][]{{1, 4}, {10, 20}, {80, 123}, {100, 100, 100, 100, 100, 100, 100, 100, 100, 200}, {10, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5}};
    private Queue<RegionInfo> regionQueue = new LinkedList<RegionInfo>();
    private Queue<ServerName> serverQueue = new LinkedList<ServerName>();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        conf = HBaseConfiguration.create();
        conf.setClass("hbase.util.ip.to.rack.determiner", MockMapping.class, DNSToSwitchMapping.class);
        conf.setFloat("hbase.master.balancer.stochastic.localityCost", 0.0f);
        loadBalancer = new StochasticLoadBalancer((MetricsStochasticBalancer)dummyMetricsStochasticBalancer);
        MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)services.getConfiguration()).thenReturn((Object)conf);
        loadBalancer.setMasterServices(services);
        loadBalancer.initialize();
    }

    public void assertClusterAsBalanced(List<ServerAndLoad> servers) {
        int numServers = servers.size();
        int numRegions = 0;
        int maxRegions = 0;
        int minRegions = Integer.MAX_VALUE;
        for (ServerAndLoad server : servers) {
            int nr = server.getLoad();
            if (nr > maxRegions) {
                maxRegions = nr;
            }
            if (nr < minRegions) {
                minRegions = nr;
            }
            numRegions += nr;
        }
        if (maxRegions - minRegions < 2) {
            return;
        }
        int min = numRegions / numServers;
        int max = numRegions % numServers == 0 ? min : min + 1;
        for (ServerAndLoad server : servers) {
            Assert.assertTrue((String)("All servers should have a positive load. " + server), (server.getLoad() >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("All servers should have load no more than " + max + ". " + server), (server.getLoad() <= max ? 1 : 0) != 0);
            Assert.assertTrue((String)("All servers should have load no less than " + min + ". " + server), (server.getLoad() >= min ? 1 : 0) != 0);
        }
    }

    public boolean assertClusterOverallAsBalanced(List<ServerAndLoad> servers, int tablenum) {
        int numServers = servers.size();
        int numRegions = 0;
        int maxRegions = 0;
        int minRegions = Integer.MAX_VALUE;
        for (ServerAndLoad server : servers) {
            int nr = server.getLoad();
            if (nr > maxRegions) {
                maxRegions = nr;
            }
            if (nr < minRegions) {
                minRegions = nr;
            }
            numRegions += nr;
        }
        if (maxRegions - minRegions < 2) {
            return true;
        }
        int min = numRegions / numServers;
        int max = numRegions % numServers == 0 ? min : min + 1;
        for (ServerAndLoad server : servers) {
            if (server.getLoad() >= 0 && server.getLoad() <= max + (tablenum / 2 + 5) && server.getLoad() >= min - tablenum / 2 - 5) continue;
            LOG.warn("server={}, load={}, max={}, tablenum={}, min={}", new Object[]{server.getServerName(), server.getLoad(), max, tablenum, min});
            return false;
        }
        return true;
    }

    public void assertRegionReplicaPlacement(Map<ServerName, List<RegionInfo>> serverMap, RackManager rackManager) {
        RegionInfo primaryInfo;
        Set<RegionInfo> infos;
        TreeMap regionsPerHost = new TreeMap();
        TreeMap<String, Set<RegionInfo>> regionsPerRack = new TreeMap<String, Set<RegionInfo>>();
        for (Map.Entry<ServerName, List<RegionInfo>> entry : serverMap.entrySet()) {
            String hostname = entry.getKey().getHostname();
            infos = (HashSet)regionsPerHost.get(hostname);
            if (infos == null) {
                infos = new HashSet();
                regionsPerHost.put(hostname, infos);
            }
            for (RegionInfo info : entry.getValue()) {
                primaryInfo = RegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)info);
                if (infos.add(primaryInfo)) continue;
                Assert.fail((String)"Two or more region replicas are hosted on the same host after balance");
            }
        }
        if (rackManager == null) {
            return;
        }
        for (Map.Entry<ServerName, List<RegionInfo>> entry : serverMap.entrySet()) {
            String rack = rackManager.getRack(entry.getKey());
            infos = (Set)regionsPerRack.get(rack);
            if (infos == null) {
                infos = new HashSet();
                regionsPerRack.put(rack, infos);
            }
            for (RegionInfo info : entry.getValue()) {
                primaryInfo = RegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)info);
                if (infos.add(primaryInfo)) continue;
                Assert.fail((String)"Two or more region replicas are hosted on the same rack after balance");
            }
        }
    }

    protected void setMaxRunTime(Duration maxRunTime) {
        conf.setLong("hbase.master.balancer.stochastic.maxRunningTime", maxRunTime.toMillis());
        loadBalancer.loadConf(conf);
    }

    protected String printStats(List<ServerAndLoad> servers) {
        int numServers = servers.size();
        int totalRegions = 0;
        for (ServerAndLoad server : servers) {
            totalRegions += server.getLoad();
        }
        float average = (float)totalRegions / (float)numServers;
        int max = (int)Math.ceil(average);
        int min = (int)Math.floor(average);
        return "[srvr=" + numServers + " rgns=" + totalRegions + " avg=" + average + " max=" + max + " min=" + min + "]";
    }

    protected List<ServerAndLoad> convertToList(Map<ServerName, List<RegionInfo>> servers) {
        ArrayList<ServerAndLoad> list = new ArrayList<ServerAndLoad>(servers.size());
        for (Map.Entry<ServerName, List<RegionInfo>> e : servers.entrySet()) {
            list.add(new ServerAndLoad(e.getKey(), e.getValue().size()));
        }
        return list;
    }

    protected String printMock(List<ServerAndLoad> balancedCluster) {
        if (balancedCluster == null) {
            return "null";
        }
        TreeSet<ServerAndLoad> sorted = new TreeSet<ServerAndLoad>(balancedCluster);
        ServerAndLoad[] arr = sorted.toArray(new ServerAndLoad[sorted.size()]);
        StringBuilder sb = new StringBuilder(sorted.size() * 4 + 4);
        sb.append("{ ");
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                sb.append(" , ");
            }
            sb.append(arr[i].getServerName().getHostname());
            sb.append(":");
            sb.append(arr[i].getLoad());
        }
        sb.append(" }");
        return sb.toString();
    }

    protected List<ServerAndLoad> reconcile(List<ServerAndLoad> list, List<RegionPlan> plans, Map<ServerName, List<RegionInfo>> servers) {
        ArrayList<ServerAndLoad> result = new ArrayList<ServerAndLoad>(list.size());
        HashMap<ServerName, ServerAndLoad> map = new HashMap<ServerName, ServerAndLoad>(list.size());
        for (ServerAndLoad sl : list) {
            map.put(sl.getServerName(), sl);
        }
        if (plans != null) {
            for (RegionPlan plan : plans) {
                ServerName source = plan.getSource();
                this.updateLoad(map, source, -1);
                ServerName destination = plan.getDestination();
                this.updateLoad(map, destination, 1);
                servers.get(source).remove(plan.getRegionInfo());
                servers.get(destination).add(plan.getRegionInfo());
            }
        }
        result.clear();
        result.addAll(map.values());
        return result;
    }

    protected void updateLoad(Map<ServerName, ServerAndLoad> map, ServerName sn, int diff) {
        ServerAndLoad sal = map.get(sn);
        if (sal == null) {
            sal = new ServerAndLoad(sn, 0);
        }
        sal = new ServerAndLoad(sn, sal.getLoad() + diff);
        map.put(sn, sal);
    }

    protected TreeMap<ServerName, List<RegionInfo>> mockClusterServers(int[][] mockCluster) {
        int numTables = mockCluster.length;
        TreeMap<ServerName, List<RegionInfo>> servers = new TreeMap<ServerName, List<RegionInfo>>();
        for (int i = 0; i < numTables; ++i) {
            TableName tableName = TableName.valueOf((String)("table" + i));
            for (int j = 0; j < mockCluster[i].length; ++j) {
                ServerName serverName = ServerName.valueOf((String)("server" + j), (int)1000, (long)-1L);
                int numRegions = mockCluster[i][j];
                List<RegionInfo> regions = this.createRegions(numRegions, tableName);
                servers.putIfAbsent(serverName, new ArrayList());
                servers.get(serverName).addAll(regions);
            }
        }
        return servers;
    }

    protected TreeMap<ServerName, List<RegionInfo>> mockClusterServers(int[] mockCluster) {
        return this.mockClusterServers(mockCluster, -1);
    }

    protected BalancerClusterState mockCluster(int[] mockCluster) {
        return new BalancerClusterState(this.mockClusterServers(mockCluster, -1), null, null, null);
    }

    protected TreeMap<ServerName, List<RegionInfo>> mockClusterServers(int[] mockCluster, int numTables) {
        int numServers = mockCluster.length;
        TreeMap<ServerName, List<RegionInfo>> servers = new TreeMap<ServerName, List<RegionInfo>>();
        for (int i = 0; i < numServers; ++i) {
            int numRegions = mockCluster[i];
            ServerAndLoad sal = this.randomServer(0);
            List<RegionInfo> regions = this.randomRegions(numRegions, numTables);
            servers.put(sal.getServerName(), regions);
        }
        return servers;
    }

    protected Map<ServerName, List<RegionInfo>> mockClusterServersUnsorted(int[] mockCluster, int numTables) {
        int numServers = mockCluster.length;
        LinkedHashMap<ServerName, List<RegionInfo>> servers = new LinkedHashMap<ServerName, List<RegionInfo>>();
        for (int i = 0; i < numServers; ++i) {
            int numRegions = mockCluster[i];
            ServerAndLoad sal = this.randomServer(0);
            List<RegionInfo> regions = this.randomRegions(numRegions, numTables);
            servers.put(sal.getServerName(), regions);
        }
        return servers;
    }

    protected TreeMap<ServerName, List<RegionInfo>> mockUniformClusterServers(int[] mockCluster) {
        int numServers = mockCluster.length;
        TreeMap<ServerName, List<RegionInfo>> servers = new TreeMap<ServerName, List<RegionInfo>>();
        for (int i = 0; i < numServers; ++i) {
            int numRegions = mockCluster[i];
            ServerAndLoad sal = this.randomServer(0);
            List<RegionInfo> regions = this.uniformRegions(numRegions);
            servers.put(sal.getServerName(), regions);
        }
        return servers;
    }

    protected HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> mockClusterServersWithTables(Map<ServerName, List<RegionInfo>> clusterServers) {
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> result = new HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>>();
        for (Map.Entry<ServerName, List<RegionInfo>> entry : clusterServers.entrySet()) {
            ServerName sal = entry.getKey();
            List<RegionInfo> regions = entry.getValue();
            for (RegionInfo hri : regions) {
                List<RegionInfo> hrilist;
                TreeMap<Object, List<Object>> servers = result.get(hri.getTable());
                if (servers == null) {
                    servers = new TreeMap();
                    result.put(hri.getTable(), servers);
                }
                if ((hrilist = servers.get(sal)) == null) {
                    hrilist = new ArrayList<RegionInfo>();
                    servers.put(sal, hrilist);
                }
                hrilist.add(hri);
            }
        }
        for (Map.Entry<Object, List<Object>> entry : result.entrySet()) {
            for (ServerName srn : clusterServers.keySet()) {
                if (((TreeMap)((Object)entry.getValue())).containsKey(srn)) continue;
                ((TreeMap)((Object)entry.getValue())).put(srn, new ArrayList());
            }
        }
        return result;
    }

    protected List<RegionInfo> randomRegions(int numRegions) {
        return this.randomRegions(numRegions, -1);
    }

    protected List<RegionInfo> createRegions(int numRegions, TableName tableName) {
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(numRegions);
        byte[] start = new byte[16];
        Bytes.random((byte[])start);
        byte[] end = new byte[16];
        Bytes.random((byte[])end);
        for (int i = 0; i < numRegions; ++i) {
            Bytes.putInt((byte[])start, (int)0, (int)(numRegions << 1));
            Bytes.putInt((byte[])end, (int)0, (int)((numRegions << 1) + 1));
            RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(start).setEndKey(end).setSplit(false).build();
            regions.add(hri);
        }
        return regions;
    }

    protected List<RegionInfo> randomRegions(int numRegions, int numTables) {
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(numRegions);
        byte[] start = new byte[16];
        Bytes.random((byte[])start);
        byte[] end = new byte[16];
        Bytes.random((byte[])end);
        for (int i = 0; i < numRegions; ++i) {
            if (!this.regionQueue.isEmpty()) {
                regions.add(this.regionQueue.poll());
                continue;
            }
            Bytes.putInt((byte[])start, (int)0, (int)(numRegions << 1));
            Bytes.putInt((byte[])end, (int)0, (int)((numRegions << 1) + 1));
            TableName tableName = TableName.valueOf((String)("table" + (numTables > 0 ? ThreadLocalRandom.current().nextInt(numTables) : i)));
            RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(start).setEndKey(end).setSplit(false).setRegionId((long)regionId++).build();
            regions.add(hri);
        }
        return regions;
    }

    protected List<RegionInfo> uniformRegions(int numRegions) {
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(numRegions);
        byte[] start = new byte[16];
        Bytes.random((byte[])start);
        byte[] end = new byte[16];
        Bytes.random((byte[])end);
        for (int i = 0; i < numRegions; ++i) {
            Bytes.putInt((byte[])start, (int)0, (int)(numRegions << 1));
            Bytes.putInt((byte[])end, (int)0, (int)((numRegions << 1) + 1));
            TableName tableName = TableName.valueOf((String)("table" + i));
            RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(start).setEndKey(end).setSplit(false).build();
            regions.add(hri);
        }
        return regions;
    }

    protected void returnRegions(List<RegionInfo> regions) {
        this.regionQueue.addAll(regions);
    }

    protected ServerAndLoad randomServer(int numRegionsPerServer) {
        if (!this.serverQueue.isEmpty()) {
            ServerName sn = this.serverQueue.poll();
            return new ServerAndLoad(sn, numRegionsPerServer);
        }
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        String host = "srv" + ((Random)rand).nextInt(Integer.MAX_VALUE);
        int port = ((Random)rand).nextInt(60000);
        long startCode = ((Random)rand).nextLong();
        ServerName sn = ServerName.valueOf((String)host, (int)port, (long)startCode);
        return new ServerAndLoad(sn, numRegionsPerServer);
    }

    protected List<ServerAndLoad> randomServers(int numServers, int numRegionsPerServer) {
        ArrayList<ServerAndLoad> servers = new ArrayList<ServerAndLoad>(numServers);
        for (int i = 0; i < numServers; ++i) {
            servers.add(this.randomServer(numRegionsPerServer));
        }
        return servers;
    }

    protected void returnServer(ServerName server) {
        this.serverQueue.add(server);
    }

    protected void returnServers(List<ServerName> servers) {
        this.serverQueue.addAll(servers);
    }

    protected void testWithCluster(int numNodes, int numRegions, int numRegionsPerServer, int replication, int numTables, boolean assertFullyBalanced, boolean assertFullyBalancedForReplicas) {
        Map<ServerName, List<RegionInfo>> serverMap = this.createServerMap(numNodes, numRegions, numRegionsPerServer, replication, numTables);
        this.testWithCluster(serverMap, null, assertFullyBalanced, assertFullyBalancedForReplicas);
    }

    protected void testWithClusterWithIteration(int numNodes, int numRegions, int numRegionsPerServer, int replication, int numTables, boolean assertFullyBalanced, boolean assertFullyBalancedForReplicas) {
        Map<ServerName, List<RegionInfo>> serverMap = this.createServerMap(numNodes, numRegions, numRegionsPerServer, replication, numTables);
        this.testWithClusterWithIteration(serverMap, null, assertFullyBalanced, assertFullyBalancedForReplicas);
    }

    protected void testWithCluster(Map<ServerName, List<RegionInfo>> serverMap, RackManager rackManager, boolean assertFullyBalanced, boolean assertFullyBalancedForReplicas) {
        List<ServerAndLoad> list = this.convertToList(serverMap);
        LOG.info("Mock Cluster : " + this.printMock(list) + " " + this.printStats(list));
        loadBalancer.setRackManager(rackManager);
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> LoadOfAllTable = this.mockClusterServersWithTables(serverMap);
        List plans = loadBalancer.balanceCluster(LoadOfAllTable);
        Assert.assertNotNull((String)"Initial cluster balance should produce plans.", (Object)plans);
        if (assertFullyBalanced || assertFullyBalancedForReplicas) {
            List<ServerAndLoad> balancedCluster = this.reconcile(list, plans, serverMap);
            LOG.info("Mock after Balance : " + this.printMock(balancedCluster));
            if (assertFullyBalanced) {
                this.assertClusterAsBalanced(balancedCluster);
                LoadOfAllTable = this.mockClusterServersWithTables(serverMap);
                List secondPlans = loadBalancer.balanceCluster(LoadOfAllTable);
                Assert.assertNull((String)"Given a requirement to be fully balanced, second attempt at plans should produce none.", (Object)secondPlans);
            }
            if (assertFullyBalancedForReplicas) {
                this.assertRegionReplicaPlacement(serverMap, rackManager);
            }
        }
    }

    protected void testWithClusterWithIteration(Map<ServerName, List<RegionInfo>> serverMap, RackManager rackManager, boolean assertFullyBalanced, boolean assertFullyBalancedForReplicas) {
        List<ServerAndLoad> list = this.convertToList(serverMap);
        LOG.info("Mock Cluster : " + this.printMock(list) + " " + this.printStats(list));
        loadBalancer.setRackManager(rackManager);
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> LoadOfAllTable = this.mockClusterServersWithTables(serverMap);
        List plans = loadBalancer.balanceCluster(LoadOfAllTable);
        Assert.assertNotNull((String)"Initial cluster balance should produce plans.", (Object)plans);
        List<ServerAndLoad> balancedCluster = null;
        while (plans != null && (assertFullyBalanced || assertFullyBalancedForReplicas)) {
            balancedCluster = this.reconcile(list, plans, serverMap);
            LOG.info("Mock after balance: " + this.printMock(balancedCluster));
            LoadOfAllTable = this.mockClusterServersWithTables(serverMap);
            plans = loadBalancer.balanceCluster(LoadOfAllTable);
        }
        LOG.info("Mock Final balance: " + this.printMock(balancedCluster));
        if (assertFullyBalanced) {
            Assert.assertNull((String)"Given a requirement to be fully balanced, second attempt at plans should produce none.", (Object)plans);
        }
        if (assertFullyBalancedForReplicas) {
            this.assertRegionReplicaPlacement(serverMap, rackManager);
        }
    }

    protected Map<ServerName, List<RegionInfo>> createServerMap(int numNodes, int numRegions, int numRegionsPerServer, int replication, int numTables) {
        int[] cluster = new int[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            cluster[i] = numRegionsPerServer;
        }
        cluster[cluster.length - 1] = numRegions - (cluster.length - 1) * numRegionsPerServer;
        TreeMap<ServerName, List<RegionInfo>> clusterState = this.mockClusterServers(cluster, numTables);
        if (replication > 0) {
            for (List regions : clusterState.values()) {
                int length = regions.size();
                for (int i = 0; i < length; ++i) {
                    for (int r = 1; r < replication; ++r) {
                        regions.add(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)((RegionInfo)regions.get(i)), (int)r));
                    }
                }
            }
        }
        return clusterState;
    }

    static {
        dummyMetricsStochasticBalancer = new DummyMetricsStochasticBalancer();
    }

    public static class MockMapping
    implements DNSToSwitchMapping {
        public MockMapping(Configuration conf) {
        }

        public List<String> resolve(List<String> names) {
            return Stream.generate(() -> "rack").limit(names.size()).collect(Collectors.toList());
        }

        public void reloadCachedMappings() {
        }

        public void reloadCachedMappings(List<String> arg0) {
        }
    }
}

