/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.EnableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterFailoverWithProceduresTestBase;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestEnableTableWithMasterFailover
extends MasterFailoverWithProceduresTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestEnableTableWithMasterFailover.class);

    @Test
    public void testEnableTableWithFailover() throws Exception {
        this.testEnableTableWithFailoverAtStep(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_MARK_REGIONS_ONLINE.ordinal());
    }

    private void testEnableTableWithFailoverAtStep(int step) throws Exception {
        TableName tableName = TableName.valueOf((String)("testEnableTableWithFailoverAtStep" + step));
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        MasterProcedureTestingUtility.createTable(TestEnableTableWithMasterFailover.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = TestEnableTableWithMasterFailover.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new EnableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        TestEnableTableWithMasterFailover.testRecoveryAndDoubleExecution(UTIL, procId, step);
        MasterProcedureTestingUtility.validateTableIsEnabled(UTIL.getHBaseCluster().getMaster(), tableName);
    }
}

