/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.master.procedure.TruncateRegionProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestTruncateRegionProcedure
extends TestTableDDLProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTruncateRegionProcedure.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestTruncateRegionProcedure.class);
    @Rule
    public TestName name = new TestName();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
        conf.setLong(HConstants.MAJOR_COMPACTION_PERIOD, 0L);
        conf.setInt("hbase.client.sync.wait.timeout.msec", 60000);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestTruncateRegionProcedure.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Override
    @Before
    public void setup() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        UTIL.getAdmin().balancerSwitch(false, true);
        UTIL.getHBaseCluster().getMaster().setCatalogJanitorEnabled(false);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        for (TableDescriptor htd : UTIL.getAdmin().listTableDescriptors()) {
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test
    public void testTruncateRegionProcedure() throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String[] families = new String[]{"f1", "f2"};
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"30"), Bytes.toBytes((String)"60"), Bytes.toBytes((String)"90")};
        MasterProcedureTestingUtility.createTable(procExec, tableName, splitKeys, families);
        AssignmentTestingUtil.insertData(UTIL, tableName, 2, 20, families);
        AssignmentTestingUtil.insertData(UTIL, tableName, 2, 31, families);
        AssignmentTestingUtil.insertData(UTIL, tableName, 2, 61, families);
        AssignmentTestingUtil.insertData(UTIL, tableName, 2, 91, families);
        Assert.assertEquals((long)8L, (long)UTIL.countRows(tableName));
        int rowsBeforeDropRegion = 8;
        MasterProcedureEnv environment = (MasterProcedureEnv)procExec.getEnvironment();
        RegionInfo regionToBeTruncated = environment.getAssignmentManager().getAssignedRegions().stream().filter(r -> tableName.getNameAsString().equals(r.getTable().getNameAsString())).min((o1, o2) -> Bytes.compareTo((byte[])o1.getStartKey(), (byte[])o2.getStartKey())).get();
        long procId = procExec.submitProcedure((Procedure)new TruncateRegionProcedure(environment, regionToBeTruncated));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Assert.assertEquals((long)6L, (long)UTIL.countRows(tableName));
        int rowsAfterDropRegion = UTIL.countRows(tableName);
        Assert.assertTrue((String)"Row counts after truncate region should be less than row count before it", (rowsAfterDropRegion < rowsBeforeDropRegion ? 1 : 0) != 0);
        Assert.assertEquals((long)rowsBeforeDropRegion, (long)(rowsAfterDropRegion + 2));
        AssignmentTestingUtil.insertData(UTIL, tableName, 2, 20, families);
        Assert.assertEquals((long)8L, (long)UTIL.countRows(tableName));
    }

    @Test
    public void testTruncateRegionProcedureErrorWhenSpecifiedReplicaRegionID() throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String[] families = new String[]{"f1", "f2"};
        this.createTable(tableName, families, 2);
        AssignmentTestingUtil.insertData(UTIL, tableName, 2, 20, families);
        AssignmentTestingUtil.insertData(UTIL, tableName, 2, 30, families);
        AssignmentTestingUtil.insertData(UTIL, tableName, 2, 60, families);
        Assert.assertEquals((long)6L, (long)UTIL.countRows(tableName));
        MasterProcedureEnv environment = (MasterProcedureEnv)procExec.getEnvironment();
        RegionInfo regionToBeTruncated = environment.getAssignmentManager().getAssignedRegions().stream().filter(r -> tableName.getNameAsString().equals(r.getTable().getNameAsString())).min((o1, o2) -> Bytes.compareTo((byte[])o1.getStartKey(), (byte[])o2.getStartKey())).get();
        RegionInfo replicatedRegionId = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)regionToBeTruncated, (int)1);
        long procId = procExec.submitProcedure((Procedure)new TruncateRegionProcedure(environment, replicatedRegionId));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Procedure result = procExec.getResult(procId);
        Assert.assertEquals((Object)ProcedureProtos.ProcedureState.ROLLEDBACK, (Object)result.getState());
        Assert.assertTrue((boolean)result.getException().getMessage().endsWith("Can't truncate replicas directly. Replicas are auto-truncated when their primary is truncated."));
    }

    private TableDescriptor tableDescriptor(TableName tableName, String[] families, int replicaCount) {
        return TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(replicaCount).setColumnFamilies(this.columnFamilyDescriptor(families)).build();
    }

    private List<ColumnFamilyDescriptor> columnFamilyDescriptor(String[] families) {
        return Arrays.stream(families).map(ColumnFamilyDescriptorBuilder::of).collect(Collectors.toList());
    }

    private void createTable(TableName tableName, String[] families, int replicaCount) throws IOException {
        UTIL.getAdmin().createTable(this.tableDescriptor(tableName, families, replicaCount));
    }
}

