/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.mob.MobFile;
import org.apache.hadoop.hbase.mob.MobTestUtil;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SmallTests.class})
public class TestMobFile {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobFile.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf = TEST_UTIL.getConfiguration();
    private CacheConfig cacheConf = new CacheConfig(this.conf);
    @Rule
    public TestName testName = new TestName();

    @Test
    public void testReadKeyValue() throws Exception {
        Path testDir = TEST_UTIL.getDataTestDir();
        FileSystem fs = testDir.getFileSystem(this.conf);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, fs).withOutputDir(testDir).withFileContext(meta).build();
        String caseName = this.testName.getMethodName();
        MobTestUtil.writeStoreFile(writer, caseName);
        StoreFileInfo storeFileInfo = StoreFileInfo.createStoreFileInfoForHFile((Configuration)this.conf, (FileSystem)fs, (Path)writer.getPath(), (boolean)true);
        MobFile mobFile = new MobFile(new HStoreFile(storeFileInfo, BloomType.NONE, this.cacheConf));
        byte[] family = Bytes.toBytes((String)caseName);
        byte[] qualify = Bytes.toBytes((String)caseName);
        byte[] startKey = Bytes.toBytes((String)"aa");
        KeyValue expectedKey = new KeyValue(startKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, startKey);
        KeyValue seekKey = expectedKey.createKeyOnly(false);
        Cell cell = mobFile.readCell((Cell)seekKey, false).getCell();
        MobTestUtil.assertCellEquals((Cell)expectedKey, cell);
        byte[] endKey = Bytes.toBytes((String)"zz");
        expectedKey = new KeyValue(endKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, endKey);
        seekKey = expectedKey.createKeyOnly(false);
        cell = mobFile.readCell((Cell)seekKey, false).getCell();
        MobTestUtil.assertCellEquals((Cell)expectedKey, cell);
        byte[] randomKey = Bytes.toBytes((String)MobTestUtil.generateRandomString(2));
        expectedKey = new KeyValue(randomKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, randomKey);
        seekKey = expectedKey.createKeyOnly(false);
        cell = mobFile.readCell((Cell)seekKey, false).getCell();
        MobTestUtil.assertCellEquals((Cell)expectedKey, cell);
        byte[] lowerKey = Bytes.toBytes((String)"a1");
        expectedKey = new KeyValue(startKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, startKey);
        seekKey = new KeyValue(lowerKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, lowerKey);
        cell = mobFile.readCell((Cell)seekKey, false).getCell();
        MobTestUtil.assertCellEquals((Cell)expectedKey, cell);
        byte[] upperKey = Bytes.toBytes((String)"z{");
        seekKey = new KeyValue(upperKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, upperKey);
        Assert.assertNull((Object)mobFile.readCell((Cell)seekKey, false));
    }

    @Test
    public void testGetScanner() throws Exception {
        Path testDir = TEST_UTIL.getDataTestDir();
        FileSystem fs = testDir.getFileSystem(this.conf);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, fs).withOutputDir(testDir).withFileContext(meta).build();
        MobTestUtil.writeStoreFile(writer, this.testName.getMethodName());
        StoreFileInfo storeFileInfo = StoreFileInfo.createStoreFileInfoForHFile((Configuration)this.conf, (FileSystem)fs, (Path)writer.getPath(), (boolean)true);
        MobFile mobFile = new MobFile(new HStoreFile(storeFileInfo, BloomType.NONE, this.cacheConf));
        Assert.assertNotNull((Object)mobFile.getScanner());
        Assert.assertTrue((boolean)(mobFile.getScanner() instanceof StoreFileScanner));
    }
}

