/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.mob.CachedMobFile;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SmallTests.class})
public class TestMobFileCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobFileCache.class);
    static final Logger LOG = LoggerFactory.getLogger(TestMobFileCache.class);
    private HBaseTestingUtility UTIL;
    private HRegion region;
    private Configuration conf;
    private MobFileCache mobFileCache;
    private Date currentDate = new Date();
    private static final String TEST_CACHE_SIZE = "2";
    private static final int EXPECTED_CACHE_SIZE_ZERO = 0;
    private static final int EXPECTED_CACHE_SIZE_ONE = 1;
    private static final int EXPECTED_CACHE_SIZE_TWO = 2;
    private static final int EXPECTED_CACHE_SIZE_THREE = 3;
    private static final long EXPECTED_REFERENCE_ONE = 1L;
    private static final long EXPECTED_REFERENCE_TWO = 2L;
    private static final String TABLE = "tableName";
    private static final String FAMILY1 = "family1";
    private static final String FAMILY2 = "family2";
    private static final String FAMILY3 = "family3";
    private static final byte[] ROW = Bytes.toBytes((String)"row");
    private static final byte[] ROW2 = Bytes.toBytes((String)"row2");
    private static final byte[] VALUE = Bytes.toBytes((String)"value");
    private static final byte[] VALUE2 = Bytes.toBytes((String)"value2");
    private static final byte[] QF1 = Bytes.toBytes((String)"qf1");
    private static final byte[] QF2 = Bytes.toBytes((String)"qf2");
    private static final byte[] QF3 = Bytes.toBytes((String)"qf3");

    @Before
    public void setUp() throws Exception {
        this.UTIL = HBaseTestingUtility.createLocalHTU();
        this.conf = this.UTIL.getConfiguration();
        this.conf.set("hbase.mob.file.cache.size", TEST_CACHE_SIZE);
        HTableDescriptor htd = this.UTIL.createTableDescriptor("testMobFileCache");
        HColumnDescriptor hcd1 = new HColumnDescriptor(FAMILY1);
        hcd1.setMobEnabled(true);
        hcd1.setMobThreshold(0L);
        HColumnDescriptor hcd2 = new HColumnDescriptor(FAMILY2);
        hcd2.setMobEnabled(true);
        hcd2.setMobThreshold(0L);
        HColumnDescriptor hcd3 = new HColumnDescriptor(FAMILY3);
        hcd3.setMobEnabled(true);
        hcd3.setMobThreshold(0L);
        htd.addFamily(hcd1);
        htd.addFamily(hcd2);
        htd.addFamily(hcd3);
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
        this.mobFileCache = new MobFileCache(this.conf);
        this.region = HBaseTestingUtility.createRegionAndWAL(regionInfo, this.UTIL.getDataTestDir(), this.conf, (TableDescriptor)htd, this.mobFileCache);
    }

    @After
    public void tearDown() throws Exception {
        this.region.close();
        this.region.getFilesystem().delete(this.UTIL.getDataTestDir(), true);
    }

    private Pair<Path, StoreContext> createAndGetMobStoreFileContextPair(String family) throws IOException {
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)family)).setMaxVersions(4).setMobEnabled(true).build();
        TableName tn = TableName.valueOf((String)TABLE);
        HMobStore mobStore = (HMobStore)this.region.getStore(columnFamilyDescriptor.getName());
        KeyValue key1 = new KeyValue(ROW, columnFamilyDescriptor.getName(), QF1, 1L, VALUE);
        KeyValue key2 = new KeyValue(ROW, columnFamilyDescriptor.getName(), QF2, 1L, VALUE);
        KeyValue key3 = new KeyValue(ROW2, columnFamilyDescriptor.getName(), QF3, 1L, VALUE2);
        KeyValue[] keys = new KeyValue[]{key1, key2, key3};
        int maxKeyCount = keys.length;
        HRegionInfo regionInfo = new HRegionInfo(tn);
        StoreFileWriter mobWriter = mobStore.createWriterInTmp(this.currentDate, (long)maxKeyCount, columnFamilyDescriptor.getCompactionCompressionType(), regionInfo.getStartKey(), false);
        Path mobFilePath = mobWriter.getPath();
        String fileName = mobFilePath.getName();
        mobWriter.append((Cell)key1);
        mobWriter.append((Cell)key2);
        mobWriter.append((Cell)key3);
        mobWriter.close();
        String targetPathName = MobUtils.formatDate((Date)this.currentDate);
        Path targetPath = new Path(mobStore.getPath(), targetPathName);
        mobStore.commitFile(mobFilePath, targetPath);
        return new Pair((Object)new Path(targetPath, fileName), (Object)mobStore.getStoreContext());
    }

    @Test
    public void testMobFileCache() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Pair<Path, StoreContext> fileAndContextPair1 = this.createAndGetMobStoreFileContextPair(FAMILY1);
        Pair<Path, StoreContext> fileAndContextPair2 = this.createAndGetMobStoreFileContextPair(FAMILY2);
        Pair<Path, StoreContext> fileAndContextPair3 = this.createAndGetMobStoreFileContextPair(FAMILY3);
        Path file1Path = (Path)fileAndContextPair1.getFirst();
        Path file2Path = (Path)fileAndContextPair2.getFirst();
        Path file3Path = (Path)fileAndContextPair3.getFirst();
        CacheConfig cacheConf = new CacheConfig(this.conf);
        Assert.assertEquals((long)0L, (long)this.mobFileCache.getCacheSize());
        CachedMobFile cachedMobFile1 = (CachedMobFile)this.mobFileCache.openFile(fs, file1Path, cacheConf, (StoreContext)fileAndContextPair1.getSecond());
        Assert.assertEquals((long)1L, (long)this.mobFileCache.getCacheSize());
        Assert.assertNotNull((Object)cachedMobFile1);
        Assert.assertEquals((long)2L, (long)cachedMobFile1.getReferenceCount());
        this.mobFileCache.evict();
        Assert.assertEquals((long)1L, (long)this.mobFileCache.getCacheSize());
        Assert.assertEquals((long)2L, (long)cachedMobFile1.getReferenceCount());
        this.mobFileCache.evictFile(file1Path.getName());
        Assert.assertEquals((long)0L, (long)this.mobFileCache.getCacheSize());
        Assert.assertEquals((long)1L, (long)cachedMobFile1.getReferenceCount());
        cachedMobFile1.close();
        cachedMobFile1 = (CachedMobFile)this.mobFileCache.openFile(fs, file1Path, cacheConf, (StoreContext)fileAndContextPair1.getSecond());
        Assert.assertEquals((long)1L, (long)this.mobFileCache.getCacheSize());
        CachedMobFile cachedMobFile2 = (CachedMobFile)this.mobFileCache.openFile(fs, file2Path, cacheConf, (StoreContext)fileAndContextPair2.getSecond());
        Assert.assertEquals((long)2L, (long)this.mobFileCache.getCacheSize());
        CachedMobFile cachedMobFile3 = (CachedMobFile)this.mobFileCache.openFile(fs, file3Path, cacheConf, (StoreContext)fileAndContextPair3.getSecond());
        Assert.assertEquals((long)3L, (long)this.mobFileCache.getCacheSize());
        Assert.assertEquals((long)2L, (long)cachedMobFile1.getReferenceCount());
        Assert.assertEquals((long)2L, (long)cachedMobFile2.getReferenceCount());
        Assert.assertEquals((long)2L, (long)cachedMobFile3.getReferenceCount());
        this.mobFileCache.evict();
        Assert.assertEquals((long)1L, (long)this.mobFileCache.getCacheSize());
        Assert.assertEquals((long)1L, (long)cachedMobFile1.getReferenceCount());
        Assert.assertEquals((long)1L, (long)cachedMobFile2.getReferenceCount());
        Assert.assertEquals((long)2L, (long)cachedMobFile3.getReferenceCount());
    }
}

