/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.quotas.QuotaCache;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.ThrottleQuotaTestUtil;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestQuotaCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestQuotaCache.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int REFRESH_TIME_MS = 1000;

    @After
    public void tearDown() throws Exception {
        ThrottleQuotaTestUtil.clearQuotaCache(TEST_UTIL);
        EnvironmentEdgeManager.reset();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 1000);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.default.user.machine.read.num", 1000);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
    }

    @Test
    public void testUserQuotaLookup() throws Exception {
        QuotaCache quotaCache = (QuotaCache)ThrottleQuotaTestUtil.getQuotaCaches(TEST_UTIL).stream().findAny().get();
        Admin admin = TEST_UTIL.getAdmin();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)"my_user", (ThrottleType)ThrottleType.READ_NUMBER, (long)3737L, (TimeUnit)TimeUnit.MINUTES));
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"my_user");
        QuotaLimiter quotaLimiter = quotaCache.getUserLimiter(ugi, TableName.valueOf((String)"my_table"));
        Assert.assertEquals((long)3737L, (long)quotaLimiter.getReadNumLimit());
        ugi = UserGroupInformation.createRemoteUser((String)"my_user2");
        quotaLimiter = quotaCache.getUserLimiter(ugi, TableName.valueOf((String)"my_table"));
        Assert.assertEquals((long)1000L, (long)quotaLimiter.getReadNumLimit());
        quotaCache.forceSynchronousCacheRefresh();
        ugi = UserGroupInformation.createRemoteUser((String)"my_user");
        quotaLimiter = quotaCache.getUserLimiter(ugi, TableName.valueOf((String)"my_table"));
        Assert.assertEquals((long)3737L, (long)quotaLimiter.getReadNumLimit());
        ugi = UserGroupInformation.createRemoteUser((String)"my_user2");
        quotaLimiter = quotaCache.getUserLimiter(ugi, TableName.valueOf((String)"my_table"));
        Assert.assertEquals((long)1000L, (long)quotaLimiter.getReadNumLimit());
    }

    @Test
    public void testTableQuotaLookup() throws Exception {
        QuotaCache quotaCache = (QuotaCache)ThrottleQuotaTestUtil.getQuotaCaches(TEST_UTIL).stream().findAny().get();
        Admin admin = TEST_UTIL.getAdmin();
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TableName.valueOf((String)"my_table"), (ThrottleType)ThrottleType.READ_NUMBER, (long)3737L, (TimeUnit)TimeUnit.MINUTES));
        QuotaLimiter quotaLimiter = quotaCache.getTableLimiter(TableName.valueOf((String)"my_table"));
        Assert.assertEquals((long)3737L, (long)quotaLimiter.getReadNumLimit());
        quotaLimiter = quotaCache.getTableLimiter(TableName.valueOf((String)"my_table2"));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)quotaLimiter.getReadNumLimit());
        quotaCache.forceSynchronousCacheRefresh();
        quotaLimiter = quotaCache.getTableLimiter(TableName.valueOf((String)"my_table"));
        Assert.assertEquals((long)3737L, (long)quotaLimiter.getReadNumLimit());
        quotaLimiter = quotaCache.getTableLimiter(TableName.valueOf((String)"my_table2"));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)quotaLimiter.getReadNumLimit());
    }

    @Test
    public void testNamespaceQuotaLookup() throws Exception {
        QuotaCache quotaCache = (QuotaCache)ThrottleQuotaTestUtil.getQuotaCaches(TEST_UTIL).stream().findAny().get();
        Admin admin = TEST_UTIL.getAdmin();
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)"my_namespace", (ThrottleType)ThrottleType.READ_NUMBER, (long)3737L, (TimeUnit)TimeUnit.MINUTES));
        QuotaLimiter quotaLimiter = quotaCache.getNamespaceLimiter("my_namespace");
        Assert.assertEquals((long)3737L, (long)quotaLimiter.getReadNumLimit());
        quotaLimiter = quotaCache.getNamespaceLimiter("my_namespace2");
        Assert.assertEquals((long)Long.MAX_VALUE, (long)quotaLimiter.getReadNumLimit());
        quotaCache.forceSynchronousCacheRefresh();
        quotaLimiter = quotaCache.getNamespaceLimiter("my_namespace");
        Assert.assertEquals((long)3737L, (long)quotaLimiter.getReadNumLimit());
        quotaLimiter = quotaCache.getNamespaceLimiter("my_namespace2");
        Assert.assertEquals((long)Long.MAX_VALUE, (long)quotaLimiter.getReadNumLimit());
    }

    @Test
    public void testRegionServerQuotaLookup() throws Exception {
        QuotaCache quotaCache = (QuotaCache)ThrottleQuotaTestUtil.getQuotaCaches(TEST_UTIL).stream().findAny().get();
        Admin admin = TEST_UTIL.getAdmin();
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)"my_region_server", (ThrottleType)ThrottleType.READ_NUMBER, (long)3737L, (TimeUnit)TimeUnit.MINUTES));
        QuotaLimiter quotaLimiter = quotaCache.getRegionServerQuotaLimiter("my_region_server");
        Assert.assertEquals((long)3737L, (long)quotaLimiter.getReadNumLimit());
        quotaLimiter = quotaCache.getRegionServerQuotaLimiter("my_region_server2");
        Assert.assertEquals((long)Long.MAX_VALUE, (long)quotaLimiter.getReadNumLimit());
        quotaCache.forceSynchronousCacheRefresh();
        quotaLimiter = quotaCache.getRegionServerQuotaLimiter("my_region_server");
        Assert.assertEquals((long)3737L, (long)quotaLimiter.getReadNumLimit());
        quotaLimiter = quotaCache.getRegionServerQuotaLimiter("my_region_server2");
        Assert.assertEquals((long)Long.MAX_VALUE, (long)quotaLimiter.getReadNumLimit());
    }
}

