/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.metrics.Snapshot;
import org.apache.hadoop.hbase.metrics.impl.DropwizardMeter;
import org.apache.hadoop.hbase.metrics.impl.HistogramImpl;
import org.apache.hadoop.hbase.regionserver.metrics.MetricsTableRequests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestMetricsTableRequests {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsTableRequests.class);

    @Test
    public void testMetricsTableLatencies() {
        TableName tn1 = TableName.valueOf((String)"table1");
        TableName tn2 = TableName.valueOf((String)"table2");
        MetricsTableRequests requests1 = new MetricsTableRequests(tn1, new Configuration());
        MetricsTableRequests requests2 = new MetricsTableRequests(tn2, new Configuration());
        Assert.assertTrue((String)("'requests' is actually " + requests1.getClass()), (boolean)(requests1 instanceof MetricsTableRequests));
        Assert.assertTrue((String)("'requests' is actually " + requests2.getClass()), (boolean)(requests2 instanceof MetricsTableRequests));
        MetricRegistryInfo info1 = requests1.getMetricRegistryInfo();
        MetricRegistryInfo info2 = requests2.getMetricRegistryInfo();
        Optional registry1 = MetricRegistries.global().get(info1);
        Assert.assertTrue((boolean)registry1.isPresent());
        Optional registry2 = MetricRegistries.global().get(info2);
        Assert.assertTrue((boolean)registry2.isPresent());
        requests1.updateGet(500L, 5000L);
        Snapshot latencies1SnapshotGet = ((HistogramImpl)((MetricRegistry)registry1.get()).get("getTime").get()).snapshot();
        Assert.assertEquals((long)500L, (long)latencies1SnapshotGet.get999thPercentile());
        Snapshot blockBytesScanned1SnapshotGet = ((HistogramImpl)((MetricRegistry)registry1.get()).get("getBlockBytesScanned").get()).snapshot();
        Assert.assertEquals((long)5000L, (long)blockBytesScanned1SnapshotGet.get999thPercentile());
        requests1.updatePut(50L);
        Snapshot latencies1SnapshotPut = ((HistogramImpl)((MetricRegistry)registry1.get()).get("putTime").get()).snapshot();
        Assert.assertEquals((long)50L, (long)latencies1SnapshotPut.get99thPercentile());
        requests2.updateGet(300L, 3000L);
        Snapshot latencies2SnapshotGet = ((HistogramImpl)((MetricRegistry)registry2.get()).get("getTime").get()).snapshot();
        Assert.assertEquals((long)300L, (long)latencies2SnapshotGet.get999thPercentile());
        Snapshot blockBytesScanned2SnapshotGet = ((HistogramImpl)((MetricRegistry)registry2.get()).get("getBlockBytesScanned").get()).snapshot();
        Assert.assertEquals((long)3000L, (long)blockBytesScanned2SnapshotGet.get999thPercentile());
        requests2.updatePut(75L);
        Snapshot latencies2SnapshotPut = ((HistogramImpl)((MetricRegistry)registry2.get()).get("putTime").get()).snapshot();
        Assert.assertEquals((long)75L, (long)latencies2SnapshotPut.get99thPercentile());
    }

    @Test
    public void testTableQueryMeterSwitch() {
        TableName tn1 = TableName.valueOf((String)"table1");
        Configuration conf = new Configuration();
        boolean enableTableQueryMeter = conf.getBoolean("hbase.regionserver.enable.table.query.meter", true);
        Assert.assertTrue((boolean)enableTableQueryMeter);
        MetricsTableRequests requests = new MetricsTableRequests(tn1, conf);
        Assert.assertTrue((String)("'requests' is actually " + requests.getClass()), (boolean)(requests instanceof MetricsTableRequests));
        MetricRegistryInfo info = requests.getMetricRegistryInfo();
        Optional registry = MetricRegistries.global().get(info);
        Assert.assertTrue((boolean)registry.isPresent());
        requests.updateTableReadQueryMeter(500L);
        Optional read = ((MetricRegistry)registry.get()).get("tableReadQueryPerSecond");
        Assert.assertTrue((boolean)read.isPresent());
        Assert.assertEquals((long)((DropwizardMeter)read.get()).getCount(), (long)500L);
        requests.removeRegistry();
        conf.setBoolean("hbase.regionserver.enable.table.query.meter", false);
        enableTableQueryMeter = conf.getBoolean("hbase.regionserver.enable.table.query.meter", true);
        Assert.assertFalse((boolean)enableTableQueryMeter);
        requests = new MetricsTableRequests(tn1, conf);
        Assert.assertTrue((String)("'requests' is actually " + requests.getClass()), (boolean)(requests instanceof MetricsTableRequests));
        info = requests.getMetricRegistryInfo();
        registry = MetricRegistries.global().get(info);
        Assert.assertTrue((boolean)registry.isPresent());
        requests.updateTableReadQueryMeter(500L);
        read = ((MetricRegistry)registry.get()).get("tableReadQueryPerSecond");
        Assert.assertFalse((boolean)read.isPresent());
    }
}

