/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.BusyRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.DelimitedKeyPrefixRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.IncreasingToUpperBoundRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.KeyPrefixRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.SteppingSplitPolicy;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestRegionSplitPolicy {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionSplitPolicy.class);
    private Configuration conf;
    private HRegion mockRegion;
    private List<HStore> stores;
    private static final TableName TABLENAME = TableName.valueOf((String)"t");

    @Before
    public void setupMocks() {
        this.conf = HBaseConfiguration.create();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)TABLENAME).build();
        this.mockRegion = (HRegion)Mockito.mock(HRegion.class);
        ((HRegion)Mockito.doReturn((Object)hri).when((Object)this.mockRegion)).getRegionInfo();
        ((HRegion)Mockito.doReturn((Object)true).when((Object)this.mockRegion)).isAvailable();
        this.stores = new ArrayList<HStore>();
        ((HRegion)Mockito.doReturn(this.stores).when((Object)this.mockRegion)).getStores();
    }

    @Test
    public void testForceSplitRegionWithReference() throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLENAME).setMaxFileSize(1024L).build();
        ((HRegion)Mockito.doReturn((Object)td).when((Object)this.mockRegion)).getTableDescriptor();
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)false).when((Object)mockStore)).canSplit();
        this.stores.add(mockStore);
        this.conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        ConstantSizeRegionSplitPolicy policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        Assert.assertFalse((boolean)policy.shouldSplit());
        this.conf.set("hbase.regionserver.region.split.policy", IncreasingToUpperBoundRegionSplitPolicy.class.getName());
        policy = (IncreasingToUpperBoundRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        Assert.assertFalse((boolean)policy.shouldSplit());
    }

    @Test
    public void testIncreasingToUpperBoundRegionSplitPolicy() throws IOException {
        this.conf.set("hbase.regionserver.region.split.policy", IncreasingToUpperBoundRegionSplitPolicy.class.getName());
        RegionServerServices rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        ArrayList<HRegion> regions = new ArrayList<HRegion>();
        ((RegionServerServices)Mockito.doReturn(regions).when((Object)rss)).getRegions(TABLENAME);
        Mockito.when((Object)this.mockRegion.getRegionServerServices()).thenReturn((Object)rss);
        long maxSplitSize = 1024L;
        long flushSize = maxSplitSize / 8L;
        this.conf.setLong(HConstants.HREGION_MEMSTORE_FLUSH_SIZE, flushSize);
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLENAME).setMaxFileSize(maxSplitSize).setMemStoreFlushSize(flushSize).build();
        ((HRegion)Mockito.doReturn((Object)td).when((Object)this.mockRegion)).getTableDescriptor();
        IncreasingToUpperBoundRegionSplitPolicy policy = (IncreasingToUpperBoundRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        this.doConstantSizePolicyTests((ConstantSizeRegionSplitPolicy)policy);
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        this.stores.add(mockStore);
        Assert.assertTrue((boolean)policy.shouldSplit());
        regions.add(this.mockRegion);
        ((HStore)Mockito.doReturn((Object)flushSize).when((Object)mockStore)).getSize();
        Assert.assertFalse((boolean)policy.shouldSplit());
        ((HStore)Mockito.doReturn((Object)(flushSize * 2L + 1L)).when((Object)mockStore)).getSize();
        Assert.assertTrue((boolean)policy.shouldSplit());
        regions.add(this.mockRegion);
        Assert.assertFalse((boolean)policy.shouldSplit());
        ((HStore)Mockito.doReturn((Object)((long)((double)maxSplitSize * 1.25 + 1.0))).when((Object)mockStore)).getSize();
        Assert.assertTrue((boolean)policy.shouldSplit());
        this.assertWithinJitter(maxSplitSize, policy.getSizeToCheck(1000));
        this.assertWithinJitter(maxSplitSize, policy.getSizeToCheck(0));
    }

    @Test
    public void testSteppingSplitPolicyWithRegionReplication() throws IOException {
        this.conf.set("hbase.regionserver.region.split.policy", SteppingSplitPolicy.class.getName());
        RegionServerServices rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        ((HRegion)Mockito.doReturn((Object)rss).when((Object)this.mockRegion)).getRegionServerServices();
        long maxFileSize = 0x280000000L;
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLENAME).setMaxFileSize(maxFileSize).build();
        ((HRegion)Mockito.doReturn((Object)td).when((Object)this.mockRegion)).getTableDescriptor();
        Assert.assertEquals((long)td.getMaxFileSize(), (long)maxFileSize);
        ArrayList<HStore> storefiles = new ArrayList<HStore>();
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        long flushSize = this.conf.getLong(HConstants.HREGION_MEMSTORE_FLUSH_SIZE, 0x8000000L);
        long exceedSize = flushSize * 2L + 1L;
        ((HStore)Mockito.doReturn((Object)exceedSize).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        storefiles.add(mockStore);
        ((HRegion)Mockito.doReturn(storefiles).when((Object)this.mockRegion)).getStores();
        ArrayList<HRegion> regions = new ArrayList<HRegion>();
        HRegion r1 = (HRegion)Mockito.mock(HRegion.class);
        RegionInfo regionInfo1 = (RegionInfo)Mockito.mock(RegionInfo.class);
        ((HRegion)Mockito.doReturn((Object)regionInfo1).when((Object)r1)).getRegionInfo();
        ((RegionInfo)Mockito.doReturn((Object)0).when((Object)regionInfo1)).getReplicaId();
        HRegion r2 = (HRegion)Mockito.mock(HRegion.class);
        RegionInfo regionInfo2 = (RegionInfo)Mockito.mock(RegionInfo.class);
        ((HRegion)Mockito.doReturn((Object)regionInfo2).when((Object)r2)).getRegionInfo();
        ((RegionInfo)Mockito.doReturn((Object)1).when((Object)regionInfo2)).getReplicaId();
        regions.add(r1);
        regions.add(r2);
        ((RegionServerServices)Mockito.doReturn(regions).when((Object)rss)).getRegions(td.getTableName());
        SteppingSplitPolicy policy = (SteppingSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        Assert.assertTrue((boolean)policy.shouldSplit());
    }

    @Test
    public void testIsExceedSize() throws IOException {
        this.conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        this.conf.set("hbase.hregion.split.overallfiles", "true");
        RegionServerServices rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        ArrayList<HRegion> regions = new ArrayList<HRegion>();
        ((RegionServerServices)Mockito.doReturn(regions).when((Object)rss)).getRegions(TABLENAME);
        Mockito.when((Object)this.mockRegion.getRegionServerServices()).thenReturn((Object)rss);
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLENAME).build();
        ((HRegion)Mockito.doReturn((Object)td).when((Object)this.mockRegion)).getTableDescriptor();
        ConstantSizeRegionSplitPolicy policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        regions.add(this.mockRegion);
        HStore mockStore1 = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)100L).when((Object)mockStore1)).getSize();
        HStore mockStore2 = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)924L).when((Object)mockStore2)).getSize();
        HStore mockStore3 = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)925L).when((Object)mockStore3)).getSize();
        this.stores.add(mockStore1);
        this.stores.add(mockStore2);
        Assert.assertFalse((boolean)policy.isExceedSize(1024L));
        this.stores.clear();
        this.stores.add(mockStore1);
        this.stores.add(mockStore3);
        Assert.assertTrue((boolean)policy.isExceedSize(1024L));
    }

    @Test
    public void testBusyRegionSplitPolicy() throws Exception {
        ((HRegion)Mockito.doReturn((Object)TableDescriptorBuilder.newBuilder((TableName)TABLENAME).build()).when((Object)this.mockRegion)).getTableDescriptor();
        this.conf.set("hbase.regionserver.region.split.policy", BusyRegionSplitPolicy.class.getName());
        this.conf.setLong("hbase.busy.policy.minAge", 1000000L);
        this.conf.setFloat("hbase.busy.policy.blockedRequests", 0.1f);
        RegionServerServices rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        ArrayList regions = new ArrayList();
        ((RegionServerServices)Mockito.doReturn(regions).when((Object)rss)).getRegions(TABLENAME);
        Mockito.when((Object)this.mockRegion.getRegionServerServices()).thenReturn((Object)rss);
        Mockito.when((Object)this.mockRegion.getBlockedRequestsCount()).thenReturn((Object)0L);
        Mockito.when((Object)this.mockRegion.getWriteRequestsCount()).thenReturn((Object)0L);
        BusyRegionSplitPolicy policy = (BusyRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        Mockito.when((Object)this.mockRegion.getBlockedRequestsCount()).thenReturn((Object)10L);
        Mockito.when((Object)this.mockRegion.getWriteRequestsCount()).thenReturn((Object)10L);
        Assert.assertFalse((boolean)policy.shouldSplit());
        this.conf.setLong("hbase.busy.policy.minAge", 0L);
        this.conf.setLong("hbase.busy.policy.aggWindow", 500L);
        policy = (BusyRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        long start = EnvironmentEdgeManager.currentTime();
        Mockito.when((Object)this.mockRegion.getBlockedRequestsCount()).thenReturn((Object)10L);
        Mockito.when((Object)this.mockRegion.getWriteRequestsCount()).thenReturn((Object)20L);
        Thread.sleep(300L);
        Assert.assertFalse((boolean)policy.shouldSplit());
        Mockito.when((Object)this.mockRegion.getBlockedRequestsCount()).thenReturn((Object)12L);
        Mockito.when((Object)this.mockRegion.getWriteRequestsCount()).thenReturn((Object)30L);
        Thread.sleep(2L);
        if (EnvironmentEdgeManager.currentTime() - start < 500L) {
            Assert.assertFalse((boolean)policy.shouldSplit());
        }
        Mockito.when((Object)this.mockRegion.getBlockedRequestsCount()).thenReturn((Object)14L);
        Mockito.when((Object)this.mockRegion.getWriteRequestsCount()).thenReturn((Object)40L);
        Thread.sleep(200L);
        Assert.assertTrue((boolean)policy.shouldSplit());
    }

    private void assertWithinJitter(long maxSplitSize, long sizeToCheck) {
        Assert.assertTrue((String)"Size greater than lower bound of jitter", ((long)((double)maxSplitSize * 0.75) <= sizeToCheck ? 1 : 0) != 0);
        Assert.assertTrue((String)"Size less than upper bound of jitter", ((long)((double)maxSplitSize * 1.25) >= sizeToCheck ? 1 : 0) != 0);
    }

    @Test
    public void testCreateDefault() throws IOException {
        this.conf.setLong(HConstants.HREGION_MAX_FILESIZE, 1234L);
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLENAME).build();
        ((HRegion)Mockito.doReturn((Object)td).when((Object)this.mockRegion)).getTableDescriptor();
        ConstantSizeRegionSplitPolicy policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        this.assertWithinJitter(1234L, policy.getDesiredMaxFileSize());
        td = TableDescriptorBuilder.newBuilder((TableName)TABLENAME).setMaxFileSize(9999L).build();
        ((HRegion)Mockito.doReturn((Object)td).when((Object)this.mockRegion)).getTableDescriptor();
        policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        this.assertWithinJitter(9999L, policy.getDesiredMaxFileSize());
    }

    @Test
    public void testCustomPolicy() throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLENAME).setRegionSplitPolicyClassName(KeyPrefixRegionSplitPolicy.class.getName()).setValue("KeyPrefixRegionSplitPolicy.prefix_length", "2").build();
        ((HRegion)Mockito.doReturn((Object)td).when((Object)this.mockRegion)).getTableDescriptor();
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        ((HStore)Mockito.doReturn(Optional.of(Bytes.toBytes((String)"abcd"))).when((Object)mockStore)).getSplitPoint();
        this.stores.add(mockStore);
        KeyPrefixRegionSplitPolicy policy = (KeyPrefixRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])policy.getSplitPoint()));
    }

    @Test
    public void testConstantSizePolicy() throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLENAME).setMaxFileSize(1024L).build();
        ((HRegion)Mockito.doReturn((Object)td).when((Object)this.mockRegion)).getTableDescriptor();
        ConstantSizeRegionSplitPolicy policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        this.doConstantSizePolicyTests(policy);
    }

    private void doConstantSizePolicyTests(ConstantSizeRegionSplitPolicy policy) {
        Assert.assertFalse((boolean)policy.shouldSplit());
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        this.stores.add(mockStore);
        Assert.assertTrue((boolean)policy.shouldSplit());
        ((HStore)Mockito.doReturn((Object)false).when((Object)mockStore)).canSplit();
        Assert.assertFalse((boolean)policy.shouldSplit());
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        ((HStore)Mockito.doReturn((Object)100L).when((Object)mockStore)).getSize();
        Assert.assertFalse((boolean)policy.shouldSplit());
        this.stores.clear();
    }

    @Test
    public void testGetSplitPoint() throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLENAME).build();
        ((HRegion)Mockito.doReturn((Object)td).when((Object)this.mockRegion)).getTableDescriptor();
        ConstantSizeRegionSplitPolicy policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        Assert.assertFalse((boolean)policy.shouldSplit());
        Assert.assertNull((Object)policy.getSplitPoint());
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        ((HStore)Mockito.doReturn(Optional.of(Bytes.toBytes((String)"store 1 split"))).when((Object)mockStore)).getSplitPoint();
        this.stores.add(mockStore);
        Assert.assertEquals((Object)"store 1 split", (Object)Bytes.toString((byte[])policy.getSplitPoint()));
        HStore mockStore2 = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)4000L).when((Object)mockStore2)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore2)).canSplit();
        ((HStore)Mockito.doReturn(Optional.of(Bytes.toBytes((String)"store 2 split"))).when((Object)mockStore2)).getSplitPoint();
        this.stores.add(mockStore2);
        Assert.assertEquals((Object)"store 2 split", (Object)Bytes.toString((byte[])policy.getSplitPoint()));
    }

    @Test
    public void testDelimitedKeyPrefixRegionSplitPolicy() throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLENAME).setRegionSplitPolicyClassName(DelimitedKeyPrefixRegionSplitPolicy.class.getName()).setValue("DelimitedKeyPrefixRegionSplitPolicy.delimiter", ",").build();
        ((HRegion)Mockito.doReturn((Object)td).when((Object)this.mockRegion)).getTableDescriptor();
        ((HRegion)Mockito.doReturn(this.stores).when((Object)this.mockRegion)).getStores();
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        ((HStore)Mockito.doReturn(Optional.of(Bytes.toBytes((String)"ab,cd"))).when((Object)mockStore)).getSplitPoint();
        this.stores.add(mockStore);
        DelimitedKeyPrefixRegionSplitPolicy policy = (DelimitedKeyPrefixRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])policy.getSplitPoint()));
        ((HStore)Mockito.doReturn(Optional.of(Bytes.toBytes((String)"ijk"))).when((Object)mockStore)).getSplitPoint();
        Assert.assertEquals((Object)"ijk", (Object)Bytes.toString((byte[])policy.getSplitPoint()));
    }

    @Test
    public void testConstantSizePolicyWithJitter() throws IOException {
        this.conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLENAME).setMaxFileSize(Long.MAX_VALUE).build();
        ((HRegion)Mockito.doReturn((Object)td).when((Object)this.mockRegion)).getTableDescriptor();
        boolean positiveJitter = false;
        ConstantSizeRegionSplitPolicy policy = null;
        while (!positiveJitter) {
            policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create((HRegion)this.mockRegion, (Configuration)this.conf);
            positiveJitter = policy.positiveJitterRate();
        }
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        this.stores.add(mockStore);
        Assert.assertFalse((boolean)policy.shouldSplit());
    }
}

