/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.exceptions.ConnectionClosedException;
import org.apache.hadoop.hbase.io.crypto.tls.KeyStoreFileType;
import org.apache.hadoop.hbase.io.crypto.tls.X509KeyType;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestContext;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestContextProvider;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;

public abstract class AbstractTestTlsRejectPlainText {
    protected static HBaseCommonTestingUtility UTIL;
    protected static File DIR;
    protected static X509TestContextProvider PROVIDER;
    @Parameterized.Parameter(value=0)
    public X509KeyType caKeyType;
    @Parameterized.Parameter(value=1)
    public X509KeyType certKeyType;
    @Parameterized.Parameter(value=2)
    public char[] keyPassword;
    private X509TestContext x509TestContext;
    protected RpcServer rpcServer;
    protected RpcClient rpcClient;

    @Parameterized.Parameters(name="{index}: caKeyType={0}, certKeyType={1}, keyPassword={2}")
    public static List<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (X509KeyType caKeyType : X509KeyType.values()) {
            for (X509KeyType certKeyType : X509KeyType.values()) {
                for (char[] keyPassword : new char[][]{"".toCharArray(), "pa$$w0rd".toCharArray()}) {
                    params.add(new Object[]{caKeyType, certKeyType, keyPassword});
                }
            }
        }
        return params;
    }

    protected static void initialize() throws IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        DIR = new File(UTIL.getDataTestDir(AbstractTestTlsRejectPlainText.class.getSimpleName()).toString()).getCanonicalFile();
        FileUtils.forceMkdir((File)DIR);
        Configuration conf = UTIL.getConfiguration();
        conf.setClass("hbase.rpc.client.impl", NettyRpcClient.class, RpcClient.class);
        conf.setClass("hbase.rpc.server.impl", NettyRpcServer.class, RpcServer.class);
        conf.setBoolean("hbase.server.netty.tls.enabled", true);
        conf.setBoolean("hbase.server.netty.tls.supportplaintext", false);
        conf.setBoolean("hbase.client.netty.tls.enabled", false);
        PROVIDER = new X509TestContextProvider(conf, DIR);
    }

    protected static void cleanUp() {
        Security.removeProvider("BC");
        UTIL.cleanupTestDir();
    }

    @Before
    public void setUp() throws Exception {
        this.x509TestContext = PROVIDER.get(this.caKeyType, this.certKeyType, this.keyPassword);
        this.x509TestContext.setConfigurations(KeyStoreFileType.JKS, KeyStoreFileType.JKS);
        Configuration conf = UTIL.getConfiguration();
        this.rpcServer = new NettyRpcServer(null, "testRpcServer", (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), conf, (RpcScheduler)new FifoRpcScheduler(conf, 1), true);
        this.rpcServer.start();
        this.rpcClient = new NettyRpcClient(conf);
    }

    @After
    public void tearDown() throws IOException {
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        Closeables.close((Closeable)this.rpcClient, (boolean)true);
        this.x509TestContext.clearConfigurations();
        this.x509TestContext.getConf().unset("hbase.rpc.tls.ocsp");
        this.x509TestContext.getConf().unset("hbase.rpc.tls.clr");
        this.x509TestContext.getConf().unset("hbase.rpc.tls.protocol");
        System.clearProperty("com.sun.net.ssl.checkRevocation");
        System.clearProperty("com.sun.security.enableCRLDP");
        Security.setProperty("ocsp.enable", Boolean.FALSE.toString());
        Security.setProperty("com.sun.security.enableCRLDP", Boolean.FALSE.toString());
    }

    protected abstract TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface createStub() throws Exception;

    @Test
    public void testReject() throws Exception {
        TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = this.createStub();
        ServiceException se = (ServiceException)Assert.assertThrows(ServiceException.class, () -> stub.echo(null, TestProtos.EchoRequestProto.newBuilder().setMessage("hello world").build()));
        MatcherAssert.assertThat((Object)se.getCause(), (Matcher)Matchers.instanceOf(ConnectionClosedException.class));
    }
}

