/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.File;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.security.AbstractTestTlsRejectPlainText;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
@Category(value={SecurityTests.class, MediumTests.class})
public class TestSaslTlsIPCRejectPlainText
extends AbstractTestTlsRejectPlainText {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSaslTlsIPCRejectPlainText.class);
    private static File KEYTAB_FILE;
    private static MiniKdc KDC;
    private static String HOST;
    private static String PRINCIPAL;
    private static UserGroupInformation UGI;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        HBaseTestingUtility util = new HBaseTestingUtility();
        UTIL = util;
        TestSaslTlsIPCRejectPlainText.initialize();
        KEYTAB_FILE = new File(util.getDataTestDir("keytab").toUri().getPath());
        KDC = util.setupMiniKdc(KEYTAB_FILE);
        PRINCIPAL = "hbase/" + HOST;
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL});
        HBaseKerberosUtils.setPrincipalForTesting((String)(PRINCIPAL + "@" + KDC.getRealm()));
        UGI = HBaseKerberosUtils.loginKerberosPrincipal((String)KEYTAB_FILE.getCanonicalPath(), (String)PRINCIPAL);
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)util.getConfiguration());
        SecurityInfo securityInfoMock = (SecurityInfo)Mockito.mock(SecurityInfo.class);
        Mockito.when((Object)securityInfoMock.getServerPrincipals()).thenReturn(Collections.singletonList("hbase.regionserver.kerberos.principal"));
        SecurityInfo.addInfo((String)"TestProtobufRpcProto", (SecurityInfo)securityInfoMock);
    }

    @AfterClass
    public static void tearDownAfterClass() {
        if (KDC != null) {
            KDC.stop();
        }
        TestSaslTlsIPCRejectPlainText.cleanUp();
    }

    @Override
    protected TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface createStub() throws Exception {
        return TestProtobufRpcServiceImpl.newBlockingStub(this.rpcClient, this.rpcServer.getListenerAddress(), User.create((UserGroupInformation)UGI));
    }

    static {
        HOST = "localhost";
    }
}

