/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.ClientTokenUtil;
import org.apache.hadoop.hbase.security.token.SecureTestCluster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SecurityTests.class, MediumTests.class})
public class TestGenerateDelegationToken
extends SecureTestCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestGenerateDelegationToken.class);
    @Parameterized.Parameter
    public String rpcClientImpl;

    @BeforeClass
    public static void setUp() throws Exception {
        SecureTestCluster.setUp();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());){
            Token token = ClientTokenUtil.obtainToken((Connection)conn);
            UserGroupInformation.getCurrentUser().addToken(token);
        }
    }

    @Parameterized.Parameters(name="{index}: rpcClientImpl={0}")
    public static Collection<Object> parameters() {
        return Arrays.asList(NettyRpcClient.class.getName());
    }

    @Before
    public void setUpBeforeMethod() {
        TEST_UTIL.getConfiguration().set("hbase.rpc.client.impl", this.rpcClientImpl);
    }

    private void testToken() throws Exception {
        try (AsyncConnection conn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();){
            AsyncTable table = conn.getTable(TableName.META_TABLE_NAME);
            AuthenticationProtos.WhoAmIResponse response = (AuthenticationProtos.WhoAmIResponse)table.coprocessorService(AuthenticationProtos.AuthenticationService::newStub, (s, c, r) -> s.whoAmI(c, AuthenticationProtos.WhoAmIRequest.getDefaultInstance(), r), HConstants.EMPTY_START_ROW).get();
            Assert.assertEquals((Object)USERNAME, (Object)response.getUsername());
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.TOKEN.name(), (Object)response.getAuthMethod());
            IOException ioe = (IOException)Assert.assertThrows(IOException.class, () -> {
                AuthenticationProtos.GetAuthenticationTokenResponse cfr_ignored_0 = (AuthenticationProtos.GetAuthenticationTokenResponse)FutureUtils.get((Future)table.coprocessorService(AuthenticationProtos.AuthenticationService::newStub, (s, c, r) -> s.getAuthenticationToken(c, AuthenticationProtos.GetAuthenticationTokenRequest.getDefaultInstance(), r), HConstants.EMPTY_START_ROW));
            });
            MatcherAssert.assertThat((Object)ioe, (Matcher)CoreMatchers.instanceOf(AccessDeniedException.class));
            MatcherAssert.assertThat((Object)ioe.getMessage(), (Matcher)CoreMatchers.containsString((String)"Token generation only allowed for Kerberos authenticated clients"));
        }
    }

    @Test
    public void testTokenFirst() throws Exception {
        this.testToken();
    }

    @Test
    public void testOnlyToken() throws Exception {
        User user = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"no_krb_user", (String[])new String[0]);
        for (Token token : User.getCurrent().getUGI().getCredentials().getAllTokens()) {
            user.getUGI().addToken(token);
        }
        user.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestGenerateDelegationToken.this.testToken();
                return null;
            }
        });
    }
}

