/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class VisibilityLabelsWithDeletesTestBase {
    protected static final String TOPSECRET = "TOPSECRET";
    protected static final String PUBLIC = "PUBLIC";
    protected static final String PRIVATE = "PRIVATE";
    protected static final String CONFIDENTIAL = "CONFIDENTIAL";
    protected static final String SECRET = "SECRET";
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static final byte[] row1 = Bytes.toBytes((String)"row1");
    protected static final byte[] row2 = Bytes.toBytes((String)"row2");
    protected static final byte[] fam = Bytes.toBytes((String)"info");
    protected static final byte[] qual = Bytes.toBytes((String)"qual");
    protected static final byte[] qual1 = Bytes.toBytes((String)"qual1");
    protected static final byte[] qual2 = Bytes.toBytes((String)"qual2");
    protected static final byte[] value = Bytes.toBytes((String)"value");
    protected static final byte[] value1 = Bytes.toBytes((String)"value1");
    protected static Configuration conf;
    @Rule
    public final TestName testName = new TestName();
    protected static User SUPERUSER;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        VisibilityTestUtil.enableVisiblityLabels(conf);
        conf.setClass("hbase.regionserver.scan.visibility.label.generator.class", SimpleScanLabelGenerator.class, ScanLabelGenerator.class);
        conf.set("hbase.superuser", "admin");
        TEST_UTIL.startMiniCluster(2);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        VisibilityLabelsWithDeletesTestBase.addLabels();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    public static void addLabels() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{VisibilityLabelsWithDeletesTestBase.SECRET, VisibilityLabelsWithDeletesTestBase.TOPSECRET, VisibilityLabelsWithDeletesTestBase.CONFIDENTIAL, VisibilityLabelsWithDeletesTestBase.PUBLIC, VisibilityLabelsWithDeletesTestBase.PRIVATE};
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    VisibilityClient.addLabels((Connection)conn, (String[])labels);
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    protected abstract Table createTable(byte[] var1) throws IOException;

    protected final void setAuths() throws IOException, InterruptedException {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.setAuths((Connection)conn, (String[])new String[]{VisibilityLabelsWithDeletesTestBase.CONFIDENTIAL, VisibilityLabelsWithDeletesTestBase.PRIVATE, VisibilityLabelsWithDeletesTestBase.SECRET, VisibilityLabelsWithDeletesTestBase.TOPSECRET}, (String)SUPERUSER.getShortName());
                    return visibilityLabelsResponse;
                }
                catch (Throwable throwable6) {
                    return null;
                }
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    private Table createTableAndWriteDataWithLabels(String ... labelExps) throws Exception {
        Table table = this.createTable(fam);
        int i = 1;
        ArrayList<Put> puts = new ArrayList<Put>(labelExps.length);
        for (String labelExp : labelExps) {
            Put put = new Put(Bytes.toBytes((String)("row" + i)));
            put.addColumn(fam, qual, Long.MAX_VALUE, value);
            put.setCellVisibility(new CellVisibility(labelExp));
            puts.add(put);
            table.put(put);
            ++i;
        }
        return table;
    }

    private Table createTableAndWriteDataWithLabels(long[] timestamp, String ... labelExps) throws Exception {
        Table table = this.createTable(fam);
        int i = 1;
        ArrayList<Put> puts = new ArrayList<Put>(labelExps.length);
        for (String labelExp : labelExps) {
            Put put = new Put(Bytes.toBytes((String)("row" + i)));
            put.addColumn(fam, qual, timestamp[i - 1], value);
            put.setCellVisibility(new CellVisibility(labelExp));
            puts.add(put);
            table.put(put);
            TEST_UTIL.getAdmin().flush(table.getName());
            ++i;
        }
        return table;
    }

    @Test
    public void testVisibilityLabelsWithDeleteColumns() throws Throwable {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.createTableAndWriteDataWithLabels("SECRET&TOPSECRET", SECRET);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("TOPSECRET&SECRET"));
                        d.addColumns(fam, qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteFamily() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.createTableAndWriteDataWithLabels(SECRET, "CONFIDENTIAL|TOPSECRET");){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row2);
                        d.setCellVisibility(new CellVisibility("TOPSECRET|CONFIDENTIAL"));
                        d.addFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteFamilyVersion() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        long[] ts = new long[]{123L, 125L};
        try (Table table = this.createTableAndWriteDataWithLabels(ts, "CONFIDENTIAL|TOPSECRET", SECRET);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("TOPSECRET|CONFIDENTIAL"));
                        d.addFamilyVersion(fam, 123L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteColumnExactVersion() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        long[] ts = new long[]{123L, 125L};
        try (Table table = this.createTableAndWriteDataWithLabels(ts, "CONFIDENTIAL|TOPSECRET", SECRET);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("TOPSECRET|CONFIDENTIAL"));
                        d.addColumn(fam, qual, 123L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }
}

