/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.conf;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ConfigKey {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigKey.class);
    private static final Map<String, Validator> validators = new ConcurrentHashMap<String, Validator>();

    private ConfigKey() {
    }

    @SafeVarargs
    public static String INT(String key, Predicate<Integer> ... predicates) {
        return ConfigKey.register(key, conf -> ConfigKey.validateNumeric(key, "an integer", () -> conf.getInt(key, 0), predicates));
    }

    @SafeVarargs
    public static String LONG(String key, Predicate<Long> ... predicates) {
        return ConfigKey.register(key, conf -> ConfigKey.validateNumeric(key, "a long", () -> conf.getLong(key, 0L), predicates));
    }

    @SafeVarargs
    public static String FLOAT(String key, Predicate<Float> ... predicates) {
        return ConfigKey.register(key, conf -> ConfigKey.validateNumeric(key, "a float", () -> Float.valueOf(conf.getFloat(key, 0.0f)), predicates));
    }

    @SafeVarargs
    public static String DOUBLE(String key, Predicate<Double> ... predicates) {
        return ConfigKey.register(key, conf -> ConfigKey.validateNumeric(key, "a double", () -> conf.getDouble(key, 0.0), predicates));
    }

    public static <T> String CLASS(String key, Class<T> expected) {
        return ConfigKey.register(key, conf -> {
            String value = conf.get(key);
            try {
                if (!expected.isAssignableFrom(Class.forName(value))) {
                    throw new IllegalArgumentException(String.format("%s ('%s') is not compatible to %s.", value, key, expected.getName()));
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("'%s' must be a class.", key), e);
            }
        });
    }

    public static String BOOLEAN(String key) {
        return key;
    }

    public static void validate(Configuration conf) {
        conf.iterator().forEachRemaining(entry -> {
            Validator validator = validators.get(entry.getKey());
            if (validator != null) {
                validator.validate(conf);
            }
        });
    }

    private static <T> void validateNumeric(String name, String expected, NumberGetter<T> getter, Predicate<T> ... predicates) {
        try {
            T value = getter.get();
            for (Predicate<T> predicate : predicates) {
                if (predicate.test(value)) continue;
                throw new IllegalArgumentException("Invalid value for '" + name + "': " + value + ".");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("'%s' must be %s.", name, expected), e);
        }
    }

    private static String register(String key, Validator validator) {
        LOG.debug("Registering config validator for {}", (Object)key);
        validators.put(key, validator);
        return key;
    }

    @FunctionalInterface
    private static interface NumberGetter<T> {
        public T get() throws NumberFormatException;
    }

    @FunctionalInterface
    private static interface Validator {
        public void validate(Configuration var1);
    }
}

