/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.client.AsyncBufferedMutator;
import org.apache.hadoop.hbase.client.AsyncBufferedMutatorBuilder;
import org.apache.hadoop.hbase.client.AsyncBufferedMutatorImpl;
import org.apache.hadoop.hbase.client.AsyncConnectionConfiguration;
import org.apache.hadoop.hbase.client.AsyncTableBuilder;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.io.netty.util.HashedWheelTimer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncBufferedMutatorBuilderImpl
implements AsyncBufferedMutatorBuilder {
    private final HashedWheelTimer periodicalFlushTimer;
    private final AsyncTableBuilder<?> tableBuilder;
    private long writeBufferSize;
    private long periodicFlushTimeoutNs;
    private int maxKeyValueSize;
    private int maxMutations;

    public AsyncBufferedMutatorBuilderImpl(AsyncConnectionConfiguration connConf, AsyncTableBuilder<?> tableBuilder, HashedWheelTimer periodicalFlushTimer) {
        this.tableBuilder = tableBuilder;
        this.writeBufferSize = connConf.getWriteBufferSize();
        this.periodicFlushTimeoutNs = connConf.getWriteBufferPeriodicFlushTimeoutNs();
        this.maxKeyValueSize = connConf.getMaxKeyValueSize();
        this.maxMutations = connConf.getBufferedMutatorMaxMutations();
        this.periodicalFlushTimer = periodicalFlushTimer;
    }

    @Override
    public AsyncBufferedMutatorBuilder setOperationTimeout(long timeout, TimeUnit unit) {
        this.tableBuilder.setOperationTimeout(timeout, unit);
        return this;
    }

    @Override
    public AsyncBufferedMutatorBuilder setRpcTimeout(long timeout, TimeUnit unit) {
        this.tableBuilder.setRpcTimeout(timeout, unit);
        return this;
    }

    @Override
    public AsyncBufferedMutatorBuilder setRetryPause(long pause, TimeUnit unit) {
        this.tableBuilder.setRetryPause(pause, unit);
        return this;
    }

    @Override
    public AsyncBufferedMutatorBuilder setMaxAttempts(int maxAttempts) {
        this.tableBuilder.setMaxAttempts(maxAttempts);
        return this;
    }

    @Override
    public AsyncBufferedMutatorBuilder setStartLogErrorsCnt(int startLogErrorsCnt) {
        this.tableBuilder.setStartLogErrorsCnt(startLogErrorsCnt);
        return this;
    }

    @Override
    public AsyncBufferedMutatorBuilder setRequestAttribute(String key, byte[] value) {
        this.tableBuilder.setRequestAttribute(key, value);
        return this;
    }

    @Override
    public AsyncBufferedMutatorBuilder setRequestAttributes(Map<String, byte[]> requestAttributes) {
        for (Map.Entry<String, byte[]> requestAttribute : requestAttributes.entrySet()) {
            this.tableBuilder.setRequestAttribute(requestAttribute.getKey(), requestAttribute.getValue());
        }
        return this;
    }

    @Override
    public AsyncBufferedMutatorBuilder setWriteBufferSize(long writeBufferSize) {
        Preconditions.checkArgument(writeBufferSize > 0L, "writeBufferSize %d must be > 0", writeBufferSize);
        this.writeBufferSize = writeBufferSize;
        return this;
    }

    @Override
    public AsyncBufferedMutatorBuilder setWriteBufferPeriodicFlush(long timeout, TimeUnit unit) {
        this.periodicFlushTimeoutNs = unit.toNanos(timeout);
        return this;
    }

    @Override
    public AsyncBufferedMutatorBuilder setMaxKeyValueSize(int maxKeyValueSize) {
        Preconditions.checkArgument(maxKeyValueSize > 0, "maxKeyValueSize %d must be > 0", maxKeyValueSize);
        this.maxKeyValueSize = maxKeyValueSize;
        return this;
    }

    @Override
    public AsyncBufferedMutatorBuilder setMaxMutations(int maxMutations) {
        Preconditions.checkArgument(maxMutations > 0, "maxMutations %d must be > 0", maxMutations);
        this.maxMutations = maxMutations;
        return this;
    }

    @Override
    public AsyncBufferedMutator build() {
        return new AsyncBufferedMutatorImpl(this.periodicalFlushTimer, this.tableBuilder.build(), this.writeBufferSize, this.periodicFlushTimeoutNs, this.maxKeyValueSize, this.maxMutations);
    }
}

