/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Cursor;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.ScannerCallableWithReplicas;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.regionserver.LeaseException;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class ClientScanner
extends AbstractClientScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ClientScanner.class);
    protected final Scan scan;
    private final Scan scanForMetrics;
    protected boolean closed = false;
    protected HRegionInfo currentRegion = null;
    protected ScannerCallableWithReplicas callable = null;
    protected Queue<Result> cache;
    private final ScanResultCache scanResultCache;
    protected final int caching;
    protected long lastNext;
    protected Result lastResult = null;
    protected final long maxScannerResultSize;
    private final ClusterConnection connection;
    protected final TableName tableName;
    protected final int readRpcTimeout;
    protected final int scannerTimeout;
    private final boolean useScannerTimeoutForNextCalls;
    protected boolean scanMetricsPublished = false;
    protected RpcRetryingCaller<Result[]> caller;
    protected RpcControllerFactory rpcControllerFactory;
    protected Configuration conf;
    protected final Span span;
    protected final int primaryOperationTimeout;
    private int retries;
    protected final ExecutorService pool;
    protected final Map<String, byte[]> requestAttributes;

    public ClientScanner(Configuration conf, Scan scan, Scan scanForMetrics, TableName tableName, ClusterConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory, ExecutorService pool, int scanReadRpcTimeout, int scannerTimeout, int primaryOperationTimeout, ConnectionConfiguration connectionConfiguration, Map<String, byte[]> requestAttributes) throws IOException {
        this.scanForMetrics = scanForMetrics;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Scan table=" + tableName + ", startRow=" + Bytes.toStringBinary(scan.getStartRow()));
        }
        this.scan = scan;
        this.tableName = tableName;
        this.lastNext = EnvironmentEdgeManager.currentTime();
        this.connection = connection;
        this.pool = pool;
        this.primaryOperationTimeout = primaryOperationTimeout;
        this.retries = connectionConfiguration.getRetriesNumber();
        this.maxScannerResultSize = scan.getMaxResultSize() > 0L ? scan.getMaxResultSize() : connectionConfiguration.getScannerMaxResultSize();
        this.readRpcTimeout = scanReadRpcTimeout;
        this.scannerTimeout = scannerTimeout;
        this.useScannerTimeoutForNextCalls = connectionConfiguration.isUseScannerTimeoutForNextCalls();
        this.requestAttributes = requestAttributes;
        if (scan.isScanMetricsByRegionEnabled() && scan.getConsistency() == Consistency.TIMELINE) {
            scan.setEnableScanMetricsByRegion(false);
            scanForMetrics.setEnableScanMetricsByRegion(false);
            LOG.warn("Scan metrics by region is not supported for timeline consistency in HBase 2");
        }
        this.initScanMetrics(scan);
        this.caching = this.scan.getCaching() > 0 ? this.scan.getCaching() : connectionConfiguration.getScannerCaching();
        this.caller = rpcFactory.newCaller();
        this.rpcControllerFactory = controllerFactory;
        this.conf = conf;
        this.span = Span.current();
        this.scanResultCache = ConnectionUtils.createScanResultCache(scan);
        this.initCache();
    }

    protected final int getScanReplicaId() {
        return Math.max(this.scan.getReplicaId(), 0);
    }

    protected ClusterConnection getConnection() {
        return this.connection;
    }

    protected TableName getTable() {
        return this.tableName;
    }

    protected int getRetries() {
        return this.retries;
    }

    protected int getScannerTimeout() {
        return this.scannerTimeout;
    }

    protected Configuration getConf() {
        return this.conf;
    }

    protected Scan getScan() {
        return this.scan;
    }

    protected ExecutorService getPool() {
        return this.pool;
    }

    protected int getPrimaryOperationTimeout() {
        return this.primaryOperationTimeout;
    }

    protected int getCaching() {
        return this.caching;
    }

    protected long getTimestamp() {
        return this.lastNext;
    }

    protected long getMaxResultSize() {
        return this.maxScannerResultSize;
    }

    private void closeScanner() throws IOException {
        if (this.callable != null) {
            this.callable.setClose();
            this.call(this.callable, this.caller, this.scannerTimeout, false);
            this.callable = null;
        }
    }

    protected abstract boolean setNewStartKey();

    protected abstract ScannerCallable createScannerCallable();

    protected boolean moveToNextRegion() {
        block7: {
            try {
                this.closeScanner();
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug("close scanner for " + this.currentRegion + " failed", (Throwable)e);
            }
        }
        if (this.currentRegion != null) {
            if (!this.setNewStartKey()) {
                return false;
            }
            this.scan.resetMvccReadPoint();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Finished " + this.currentRegion);
            }
        }
        if (LOG.isDebugEnabled() && this.currentRegion != null) {
            LOG.debug("Advancing internal scanner to startKey at '" + Bytes.toStringBinary(this.scan.getStartRow()) + "', " + (this.scan.includeStartRow() ? "inclusive" : "exclusive"));
        }
        this.currentRegion = null;
        if (this.isScanMetricsByRegionEnabled()) {
            this.scanMetrics.moveToNextRegion();
        }
        this.callable = new ScannerCallableWithReplicas(this.getTable(), this.getConnection(), this.createScannerCallable(), this.pool, this.primaryOperationTimeout, this.scan, this.getRetries(), this.readRpcTimeout, this.scannerTimeout, this.useScannerTimeoutForNextCalls, this.caching, this.conf, this.caller);
        this.callable.setCaching(this.caching);
        ConnectionUtils.incRegionCountMetrics(this.scanMetrics);
        return true;
    }

    boolean isAnyRPCcancelled() {
        return this.callable.isAnyRPCcancelled();
    }

    private Result[] call(ScannerCallableWithReplicas callable, RpcRetryingCaller<Result[]> caller, int scannerTimeout, boolean updateCurrentRegion) throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        Result[] rrs = caller.callWithoutRetries(callable, scannerTimeout);
        if (this.currentRegion == null && updateCurrentRegion) {
            this.currentRegion = callable.getHRegionInfo();
            this.initScanMetricsRegionInfo();
        }
        return rrs;
    }

    protected void writeScanMetrics() {
        if (this.scanMetrics == null || this.scanMetricsPublished) {
            return;
        }
        this.scanForMetrics.setAttribute("scan.attributes.metrics.data", ProtobufUtil.toScanMetrics(this.scanMetrics, false).toByteArray());
        this.scanMetricsPublished = true;
    }

    protected void initSyncCache() {
        this.cache = new ArrayDeque<Result>();
    }

    protected Result nextWithSyncCache() throws IOException {
        Result result = this.cache.poll();
        if (result != null) {
            return result;
        }
        if (this.closed) {
            return null;
        }
        this.loadCache();
        result = this.cache.poll();
        if (result == null) {
            this.writeScanMetrics();
        }
        return result;
    }

    public int getCacheSize() {
        return this.cache != null ? this.cache.size() : 0;
    }

    private boolean scanExhausted() {
        return this.callable.moreResultsForScan() == ScannerCallable.MoreResults.NO;
    }

    private boolean regionExhausted(Result[] values) {
        return values.length == 0 && !this.callable.isHeartbeatMessage() || this.callable.moreResultsInRegion() == ScannerCallable.MoreResults.NO;
    }

    private void closeScannerIfExhausted(boolean exhausted) throws IOException {
        if (exhausted) {
            this.closeScanner();
        }
    }

    private void handleScanError(DoNotRetryIOException e, MutableBoolean retryAfterOutOfOrderException, int retriesLeft) throws DoNotRetryIOException {
        this.scanResultCache.clear();
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof NotServingRegionException || cause != null && cause instanceof RegionServerStoppedException || e instanceof OutOfOrderScannerNextException || e instanceof UnknownScannerException || e instanceof ScannerResetException || e instanceof LeaseException) {
            if (retriesLeft <= 0) {
                throw e;
            }
        } else {
            throw e;
        }
        if (this.lastResult != null) {
            this.scan.withStartRow(this.lastResult.getRow(), this.lastResult.mayHaveMoreCellsInRow());
        }
        if (e instanceof OutOfOrderScannerNextException) {
            if (retryAfterOutOfOrderException.isTrue()) {
                retryAfterOutOfOrderException.setValue(false);
            } else {
                throw new DoNotRetryIOException("Failed after retry of OutOfOrderScannerNextException: was there a rpc timeout?", e);
            }
        }
        this.currentRegion = null;
        this.callable = null;
    }

    protected void loadCache() throws IOException {
        block18: {
            if (this.closed) {
                return;
            }
            long remainingResultSize = this.maxScannerResultSize;
            int countdown = this.caching;
            if (this.callable == null && !this.moveToNextRegion()) {
                this.closed = true;
                return;
            }
            MutableBoolean retryAfterOutOfOrderException = new MutableBoolean(true);
            int retriesLeft = this.getRetries();
            while (true) {
                Result[] values;
                try {
                    values = this.call(this.callable, this.caller, this.scannerTimeout, true);
                    if (this.callable.switchedToADifferentReplica()) {
                        this.scanResultCache.clear();
                        this.currentRegion = this.callable.getHRegionInfo();
                    }
                    retryAfterOutOfOrderException.setValue(true);
                }
                catch (DoNotRetryIOException e) {
                    this.handleScanError(e, retryAfterOutOfOrderException, retriesLeft--);
                    if (this.moveToNextRegion()) continue;
                    break block18;
                }
                long currentTime = EnvironmentEdgeManager.currentTime();
                if (this.scanMetrics != null) {
                    this.scanMetrics.addToCounter("MILLIS_BETWEEN_NEXTS", currentTime - this.lastNext);
                }
                this.lastNext = currentTime;
                int numberOfCompleteRowsBefore = this.scanResultCache.numberOfCompleteRows();
                Result[] resultsToAddToCache = this.scanResultCache.addAndGet(values, this.callable.isHeartbeatMessage());
                int numberOfCompleteRows = this.scanResultCache.numberOfCompleteRows() - numberOfCompleteRowsBefore;
                for (Result rs : resultsToAddToCache) {
                    this.cache.add(rs);
                    long estimatedHeapSizeOfResult = ConnectionUtils.calcEstimatedSize(rs);
                    --countdown;
                    remainingResultSize -= estimatedHeapSizeOfResult;
                    this.addEstimatedSize(estimatedHeapSizeOfResult);
                    this.lastResult = rs;
                }
                if (this.scan.getLimit() > 0) {
                    int newLimit = this.scan.getLimit() - numberOfCompleteRows;
                    assert (newLimit >= 0);
                    this.scan.setLimit(newLimit);
                }
                if (this.scan.getLimit() == 0 || this.scanExhausted()) {
                    this.closeScanner();
                    this.closed = true;
                    break block18;
                }
                boolean regionExhausted = this.regionExhausted(values);
                if (this.callable.isHeartbeatMessage() && !this.cache.isEmpty()) {
                    LOG.trace("Heartbeat message received and cache contains Results. Breaking out of scan loop");
                    break block18;
                }
                if (this.cache.isEmpty() && !this.closed && this.scan.isNeedCursorResult()) {
                    if (this.callable.isHeartbeatMessage() && this.callable.getCursor() != null) {
                        this.cache.add(Result.createCursorResult(this.callable.getCursor()));
                        break block18;
                    }
                    if (values.length > 0) {
                        this.cache.add(Result.createCursorResult(new Cursor(values[values.length - 1].getRow())));
                        break block18;
                    }
                }
                if (countdown <= 0) {
                    this.closeScannerIfExhausted(regionExhausted);
                    break block18;
                }
                if (remainingResultSize <= 0L) {
                    if (!this.cache.isEmpty()) {
                        this.closeScannerIfExhausted(regionExhausted);
                        break block18;
                    }
                    remainingResultSize = this.maxScannerResultSize;
                }
                if (regionExhausted && !this.moveToNextRegion()) break;
            }
            this.closed = true;
        }
    }

    protected void addEstimatedSize(long estimatedHeapSizeOfResult) {
    }

    public int getCacheCount() {
        return this.cache != null ? this.cache.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try (Scope ignored = this.span.makeCurrent();){
            if (!this.scanMetricsPublished) {
                this.writeScanMetrics();
            }
            if (this.callable != null) {
                this.callable.setClose();
                try {
                    this.call(this.callable, this.caller, this.scannerTimeout, false);
                }
                catch (UnknownScannerException e) {
                    LOG.debug("scanner failed to close", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.warn("scanner failed to close.", (Throwable)e);
                    this.span.recordException((Throwable)e);
                    this.span.setStatus(StatusCode.ERROR);
                }
                this.callable = null;
            }
            this.closed = true;
            this.span.setStatus(StatusCode.OK);
        }
        finally {
            this.span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean renewLease() {
        Throwable throwable = null;
        try (Scope ignored = this.span.makeCurrent();){
            if (this.callable == null) {
                boolean bl = false;
                return bl;
            }
            this.callable.setRenew(true);
            try {
                this.caller.callWithoutRetries(this.callable, this.scannerTimeout);
                boolean bl = true;
                this.callable.setRenew(false);
                return bl;
            }
            catch (Exception e) {
                boolean bl;
                block24: {
                    block25: {
                        LOG.debug("scanner failed to renew lease", (Throwable)e);
                        this.span.recordException((Throwable)e);
                        bl = false;
                        this.callable.setRenew(false);
                        if (ignored == null) break block24;
                        if (throwable == null) break block25;
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block24;
                    }
                    ignored.close();
                }
                return bl;
                {
                    catch (Throwable throwable3) {
                        try {
                            this.callable.setRenew(false);
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                    }
                }
            }
        }
    }

    protected void initCache() {
        this.initSyncCache();
    }

    @Override
    public Result next() throws IOException {
        try (Scope ignored = this.span.makeCurrent();){
            Result result = this.nextWithSyncCache();
            return result;
        }
    }

    private void initScanMetricsRegionInfo() {
        if (this.isScanMetricsByRegionEnabled()) {
            HRegionLocation location = this.callable.getLocation();
            String encodedRegionName = location.getRegion().getEncodedName();
            this.scanMetrics.initScanMetricsRegionInfo(encodedRegionName, location.getServerName());
        }
    }
}

