/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.joni;

import org.apache.hadoop.hbase.shaded.org.joni.Region;

public class SingleRegion
extends Region {
    int beg;
    int end;

    public SingleRegion(int num) {
        if (num != 1) {
            throw new IndexOutOfBoundsException("" + num);
        }
    }

    public SingleRegion(int begin, int end) {
        this.beg = begin;
        this.end = end;
    }

    @Override
    public int getNumRegs() {
        return 1;
    }

    @Override
    public SingleRegion clone() {
        SingleRegion region = new SingleRegion(this.beg, this.end);
        if (this.getCaptureTree() != null) {
            region.setCaptureTree(this.getCaptureTree().cloneTree());
        }
        return region;
    }

    @Override
    public int getBeg(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return this.beg;
    }

    @Override
    public int setBeg(int index, int value) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("" + index);
        }
        this.beg = value;
        return this.beg;
    }

    @Override
    public int getEnd(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return this.end;
    }

    @Override
    public int setEnd(int index, int value) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("" + index);
        }
        this.end = value;
        return this.end;
    }

    @Override
    void clear() {
        this.end = -1;
        this.beg = -1;
    }
}

