/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.uam;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.AMRMClientUtils;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.AMRMClientRelayer;
import org.apache.hadoop.yarn.server.uam.UnmanagedApplicationManager;
import org.apache.hadoop.yarn.util.AsyncCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class UnmanagedAMPoolManager
extends AbstractService {
    public static final Logger LOG = LoggerFactory.getLogger(UnmanagedAMPoolManager.class);
    private Map<String, UnmanagedApplicationManager> unmanagedAppMasterMap;
    private Map<String, ApplicationId> appIdMap;
    private ExecutorService threadpool;

    public UnmanagedAMPoolManager(ExecutorService threadpool) {
        super(UnmanagedAMPoolManager.class.getName());
        this.threadpool = threadpool;
    }

    protected void serviceStart() throws Exception {
        if (this.threadpool == null) {
            this.threadpool = Executors.newCachedThreadPool();
        }
        this.unmanagedAppMasterMap = new ConcurrentHashMap<String, UnmanagedApplicationManager>();
        this.appIdMap = new ConcurrentHashMap<String, ApplicationId>();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        ExecutorCompletionService<KillApplicationResponse> completionService = new ExecutorCompletionService<KillApplicationResponse>(this.threadpool);
        if (this.unmanagedAppMasterMap.isEmpty()) {
            return;
        }
        HashSet<String> addressList = new HashSet<String>(this.unmanagedAppMasterMap.keySet());
        LOG.warn("Abnormal shutdown of UAMPoolManager, still {} UAMs in map", (Object)addressList.size());
        for (final String uamId : addressList) {
            completionService.submit(new Callable<KillApplicationResponse>(){

                @Override
                public KillApplicationResponse call() throws Exception {
                    try {
                        LOG.info("Force-killing UAM id " + uamId + " for application " + UnmanagedAMPoolManager.this.appIdMap.get(uamId));
                        return ((UnmanagedApplicationManager)UnmanagedAMPoolManager.this.unmanagedAppMasterMap.remove(uamId)).forceKillApplication();
                    }
                    catch (Exception e) {
                        LOG.error("Failed to kill unmanaged application master", (Throwable)e);
                        return null;
                    }
                }
            });
        }
        for (int i = 0; i < addressList.size(); ++i) {
            try {
                Future future = completionService.take();
                future.get();
                continue;
            }
            catch (Exception e) {
                LOG.error("Failed to kill unmanaged application master", (Throwable)e);
            }
        }
        this.appIdMap.clear();
        super.serviceStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createAndRegisterNewUAM(RegisterApplicationMasterRequest registerRequest, Configuration conf, String queueName, String submitter, String appNameSuffix, boolean keepContainersAcrossApplicationAttempts, String rmName) throws YarnException, IOException {
        ApplicationClientProtocol rmClient;
        ApplicationId appId = null;
        try {
            UserGroupInformation appSubmitter = UserGroupInformation.createRemoteUser((String)submitter);
            rmClient = (ApplicationClientProtocol)AMRMClientUtils.createRMProxy((Configuration)conf, ApplicationClientProtocol.class, (UserGroupInformation)appSubmitter, null);
            GetNewApplicationResponse response = rmClient.getNewApplication(GetNewApplicationRequest.newInstance());
            if (response == null) {
                throw new YarnException("getNewApplication got null response");
            }
            appId = response.getApplicationId();
            LOG.info("Received new application ID {} from RM", (Object)appId);
        }
        finally {
            rmClient = null;
        }
        this.launchUAM(appId.toString(), conf, appId, queueName, submitter, appNameSuffix, keepContainersAcrossApplicationAttempts, rmName);
        this.registerApplicationMaster(appId.toString(), registerRequest);
        return appId.toString();
    }

    public Token<AMRMTokenIdentifier> launchUAM(String uamId, Configuration conf, ApplicationId appId, String queueName, String submitter, String appNameSuffix, boolean keepContainersAcrossApplicationAttempts, String rmName) throws YarnException, IOException {
        if (this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " already exists");
        }
        UnmanagedApplicationManager uam = this.createUAM(conf, appId, queueName, submitter, appNameSuffix, keepContainersAcrossApplicationAttempts, rmName);
        this.unmanagedAppMasterMap.put(uamId, uam);
        Token<AMRMTokenIdentifier> amrmToken = null;
        try {
            LOG.info("Launching UAM id {} for application {}", (Object)uamId, (Object)appId);
            amrmToken = uam.launchUAM();
        }
        catch (Exception e) {
            this.unmanagedAppMasterMap.remove(uamId);
            throw e;
        }
        this.appIdMap.put(uamId, uam.getAppId());
        return amrmToken;
    }

    public void reAttachUAM(String uamId, Configuration conf, ApplicationId appId, String queueName, String submitter, String appNameSuffix, Token<AMRMTokenIdentifier> uamToken, String rmName) throws YarnException, IOException {
        if (this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " already exists");
        }
        UnmanagedApplicationManager uam = this.createUAM(conf, appId, queueName, submitter, appNameSuffix, true, rmName);
        this.unmanagedAppMasterMap.put(uamId, uam);
        try {
            LOG.info("Reattaching UAM id {} for application {}", (Object)uamId, (Object)appId);
            uam.reAttachUAM(uamToken);
        }
        catch (Exception e) {
            this.unmanagedAppMasterMap.remove(uamId);
            throw e;
        }
        this.appIdMap.put(uamId, uam.getAppId());
    }

    @VisibleForTesting
    protected UnmanagedApplicationManager createUAM(Configuration conf, ApplicationId appId, String queueName, String submitter, String appNameSuffix, boolean keepContainersAcrossApplicationAttempts, String rmName) {
        return new UnmanagedApplicationManager(conf, appId, queueName, submitter, appNameSuffix, keepContainersAcrossApplicationAttempts, rmName);
    }

    public RegisterApplicationMasterResponse registerApplicationMaster(String uamId, RegisterApplicationMasterRequest registerRequest) throws YarnException, IOException {
        if (!this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " does not exist");
        }
        LOG.info("Registering UAM id {} for application {}", (Object)uamId, (Object)this.appIdMap.get(uamId));
        return this.unmanagedAppMasterMap.get(uamId).registerApplicationMaster(registerRequest);
    }

    public void allocateAsync(String uamId, AllocateRequest request, AsyncCallback<AllocateResponse> callback) throws YarnException, IOException {
        if (!this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " does not exist");
        }
        this.unmanagedAppMasterMap.get(uamId).allocateAsync(request, callback);
    }

    public FinishApplicationMasterResponse finishApplicationMaster(String uamId, FinishApplicationMasterRequest request) throws YarnException, IOException {
        if (!this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " does not exist");
        }
        LOG.info("Finishing UAM id {} for application {}", (Object)uamId, (Object)this.appIdMap.get(uamId));
        FinishApplicationMasterResponse response = this.unmanagedAppMasterMap.get(uamId).finishApplicationMaster(request);
        if (response.getIsUnregistered()) {
            this.unmanagedAppMasterMap.remove(uamId);
            this.appIdMap.remove(uamId);
            LOG.info("UAM id {} is unregistered", (Object)uamId);
        }
        return response;
    }

    public void shutDownConnections(String uamId) throws YarnException {
        if (!this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " does not exist");
        }
        LOG.info("Shutting down UAM id {} for application {} without killing the UAM", (Object)uamId, (Object)this.appIdMap.get(uamId));
        this.unmanagedAppMasterMap.remove(uamId).shutDownConnections();
    }

    public void shutDownConnections() throws YarnException {
        for (String uamId : this.unmanagedAppMasterMap.keySet()) {
            this.shutDownConnections(uamId);
        }
    }

    public Set<String> getAllUAMIds() {
        return new HashSet<String>(this.unmanagedAppMasterMap.keySet());
    }

    public boolean hasUAMId(String uamId) {
        return this.unmanagedAppMasterMap.containsKey(uamId);
    }

    public AMRMClientRelayer getAMRMClientRelayer(String uamId) throws YarnException {
        if (!this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " does not exist");
        }
        return this.unmanagedAppMasterMap.get(uamId).getAMRMClientRelayer();
    }

    @VisibleForTesting
    public int getRequestQueueSize(String uamId) throws YarnException {
        if (!this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " does not exist");
        }
        return this.unmanagedAppMasterMap.get(uamId).getRequestQueueSize();
    }

    @VisibleForTesting
    public void drainUAMHeartbeats() {
        for (UnmanagedApplicationManager uam : this.unmanagedAppMasterMap.values()) {
            uam.drainHeartbeatThread();
        }
    }
}

