/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.journal;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.ChangeType;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.journal.Journal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(JournalInterceptor.class);
    private boolean journalEnabled;
    private AtomicLong revision;
    private Journal journal;

    public JournalInterceptor() {
        super(InterceptorEnum.JOURNAL_INTERCEPTOR);
    }

    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        if (directoryService.getJournal().isEnabled()) {
            this.journalEnabled = true;
            this.journal = directoryService.getJournal();
            this.revision = new AtomicLong(System.currentTimeMillis());
        }
        LOG.debug("JournalInterceptor has been initialized");
    }

    private void log(OperationContext opCtx, long revision, LdifEntry ldif) throws LdapException {
        this.journal.log(JournalInterceptor.getPrincipal((OperationContext)opCtx), revision, ldif);
    }

    public void add(AddOperationContext addContext) throws LdapException {
        long opRevision = 0L;
        if (this.journalEnabled) {
            opRevision = this.revision.incrementAndGet();
            Entry addEntry = addContext.getEntry();
            LdifEntry ldif = new LdifEntry();
            ldif.setChangeType(ChangeType.Add);
            ldif.setDn(addContext.getDn());
            for (Attribute attribute : addEntry.getAttributes()) {
                AttributeType attributeType = attribute.getAttributeType();
                ldif.addAttribute(addEntry.get(attributeType).clone());
            }
            this.log((OperationContext)addContext, opRevision, ldif);
        }
        try {
            this.next(addContext);
            if (this.journalEnabled) {
                this.journal.ack(opRevision);
            }
        }
        catch (LdapException le) {
            if (this.journalEnabled) {
                this.journal.nack(opRevision);
            }
            throw le;
        }
    }

    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        long opRevision = 0L;
        if (this.journalEnabled) {
            opRevision = this.revision.incrementAndGet();
            LdifEntry ldif = new LdifEntry();
            ldif.setChangeType(ChangeType.Delete);
            ldif.setDn(deleteContext.getDn());
            this.journal.log(JournalInterceptor.getPrincipal((OperationContext)deleteContext), opRevision, ldif);
        }
        try {
            this.next(deleteContext);
            if (this.journalEnabled) {
                this.journal.ack(opRevision);
            }
        }
        catch (LdapException e) {
            if (this.journalEnabled) {
                this.journal.nack(opRevision);
            }
            throw e;
        }
    }

    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        long opRevision = 0L;
        if (this.journalEnabled) {
            opRevision = this.revision.incrementAndGet();
            LdifEntry ldif = new LdifEntry();
            ldif.setChangeType(ChangeType.Modify);
            ldif.setDn(modifyContext.getDn());
            for (Modification modification : modifyContext.getModItems()) {
                ldif.addModification(modification);
            }
            this.journal.log(JournalInterceptor.getPrincipal((OperationContext)modifyContext), opRevision, ldif);
        }
        try {
            this.next(modifyContext);
            if (this.journalEnabled) {
                this.journal.ack(opRevision);
            }
        }
        catch (LdapException e) {
            if (this.journalEnabled) {
                this.journal.nack(opRevision);
            }
            throw e;
        }
    }

    public void move(MoveOperationContext moveContext) throws LdapException {
        long opRevision = 0L;
        if (this.journalEnabled) {
            opRevision = this.revision.incrementAndGet();
            LdifEntry ldif = new LdifEntry();
            ldif.setChangeType(ChangeType.ModDn);
            ldif.setDn(moveContext.getDn());
            ldif.setNewSuperior(moveContext.getNewSuperior().getNormName());
            this.journal.log(JournalInterceptor.getPrincipal((OperationContext)moveContext), opRevision, ldif);
        }
        try {
            this.next(moveContext);
            if (this.journalEnabled) {
                this.journal.ack(opRevision);
            }
        }
        catch (LdapException e) {
            if (this.journalEnabled) {
                this.journal.nack(opRevision);
            }
            throw e;
        }
    }

    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        long opRevision = 0L;
        if (this.journalEnabled) {
            opRevision = this.revision.incrementAndGet();
            LdifEntry ldif = new LdifEntry();
            ldif.setChangeType(ChangeType.ModDn);
            ldif.setDn(moveAndRenameContext.getDn());
            ldif.setNewRdn(moveAndRenameContext.getNewRdn().getNormName());
            ldif.setDeleteOldRdn(moveAndRenameContext.getDeleteOldRdn());
            ldif.setNewSuperior(moveAndRenameContext.getNewDn().getNormName());
            this.journal.log(JournalInterceptor.getPrincipal((OperationContext)moveAndRenameContext), opRevision, ldif);
        }
        try {
            this.next(moveAndRenameContext);
            if (this.journalEnabled) {
                this.journal.ack(opRevision);
            }
        }
        catch (LdapException e) {
            if (this.journalEnabled) {
                this.journal.nack(opRevision);
            }
            throw e;
        }
    }

    public void rename(RenameOperationContext renameContext) throws LdapException {
        long opRevision = 0L;
        if (this.journalEnabled) {
            opRevision = this.revision.incrementAndGet();
            LdifEntry ldif = new LdifEntry();
            ldif.setChangeType(ChangeType.ModRdn);
            ldif.setDn(renameContext.getDn());
            ldif.setNewRdn(renameContext.getNewRdn().getNormName());
            ldif.setDeleteOldRdn(renameContext.getDeleteOldRdn());
            this.journal.log(JournalInterceptor.getPrincipal((OperationContext)renameContext), opRevision, ldif);
        }
        try {
            this.next(renameContext);
            if (this.journalEnabled) {
                this.journal.ack(opRevision);
            }
        }
        catch (LdapException e) {
            if (this.journalEnabled) {
                this.journal.nack(opRevision);
            }
            throw e;
        }
    }
}

