/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import javax.security.sasl.SaslClient;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.handler.codec.MessageToByteEncoder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SaslWrapHandler
extends MessageToByteEncoder<ByteBuf> {
    private final SaslClient saslClient;

    public SaslWrapHandler(SaslClient saslClient) {
        this.saslClient = saslClient;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        byte[] bytes = new byte[msg.readableBytes()];
        msg.readBytes(bytes);
        byte[] wrapperBytes = this.saslClient.wrap(bytes, 0, bytes.length);
        out.ensureWritable(4 + wrapperBytes.length);
        out.writeInt(wrapperBytes.length);
        out.writeBytes(wrapperBytes);
    }
}

