/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.constraint.dataprovider;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.ZNRecord;
import org.apache.helix.api.rebalancer.constraint.dataprovider.PartitionWeightProvider;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.store.zk.ZkHelixPropertyStore;

public class ZkBasedPartitionWeightProvider
implements PartitionWeightProvider {
    public static final int DEFAULT_WEIGHT_VALUE = 1;
    private static final String ROOT = "/RESOURCE_WEIGHT";
    private final ZkHelixPropertyStore<ZNRecord> _propertyStore;
    private final String _dimensionPath;
    private PartitionWeight _weights;

    public ZkBasedPartitionWeightProvider(ZkHelixPropertyStore<ZNRecord> propertyStore, String dimensionName) {
        this._propertyStore = propertyStore;
        this._dimensionPath = "/RESOURCE_WEIGHT/" + dimensionName;
        ZNRecord existingRecord = (ZNRecord)this._propertyStore.get(this._dimensionPath, null, AccessOption.PERSISTENT);
        this._weights = existingRecord == null ? new PartitionWeight(dimensionName) : new PartitionWeight(existingRecord);
    }

    public ZkBasedPartitionWeightProvider(String zkAddr, String clusterName, String dimensionName) {
        this(new ZkHelixPropertyStore<ZNRecord>(zkAddr, new ZNRecordSerializer(), PropertyPathBuilder.propertyStore(clusterName)), dimensionName);
    }

    public void updateWeights(Map<String, Integer> resourceDefaultWeightMap, Map<String, Map<String, Integer>> partitionWeightMap, int defaultWeight) {
        for (String resource : resourceDefaultWeightMap.keySet()) {
            this._weights.setResourceDefaultWeight(resource, resourceDefaultWeightMap.get(resource));
        }
        for (String resource : partitionWeightMap.keySet()) {
            Map<String, Integer> detailMap = partitionWeightMap.get(resource);
            for (String partition : detailMap.keySet()) {
                this._weights.setPartitionWeight(resource, partition, detailMap.get(partition));
            }
        }
        this._weights.setDefaultWeight(defaultWeight);
    }

    public boolean persistWeights() {
        if (this._weights.isValid()) {
            return this._propertyStore.set(this._dimensionPath, this._weights.getRecord(), AccessOption.PERSISTENT);
        }
        throw new HelixException("Invalid ParticipantCapacity: " + this._weights.getRecord().toString());
    }

    @Override
    public int getPartitionWeight(String resource, String partition) {
        return this._weights.getWeight(resource, partition);
    }

    private static class PartitionWeight
    extends HelixProperty {
        PartitionWeight(String dimensionName) {
            super(dimensionName);
            this._record.setIntField(ResourceWeightProperty.DEFAULT_WEIGHT.name(), 1);
        }

        PartitionWeight(ZNRecord record) {
            super(record);
            if (!this.isValid()) {
                throw new HelixException("Invalid ResourceWeight: " + record.toString());
            }
        }

        private String getWeightKey(String resource) {
            return ResourceWeightProperty.DEFAULT_RESOURCE_WEIGHT.name() + "_" + resource;
        }

        int getWeight(String resource, String partition) {
            Map<String, String> partitionWeightMap = this._record.getMapField(resource);
            if (partitionWeightMap != null && partitionWeightMap.containsKey(partition)) {
                return Integer.parseInt(partitionWeightMap.get(partition));
            }
            return this._record.getIntField(this.getWeightKey(resource), this.getDefaultWeight());
        }

        void setResourceDefaultWeight(String resource, int weight) {
            this._record.setIntField(this.getWeightKey(resource), weight);
        }

        void setPartitionWeight(String resource, String partition, int weight) {
            Map<String, String> partitionWeightMap = this._record.getMapField(resource);
            if (partitionWeightMap == null) {
                partitionWeightMap = new HashMap<String, String>();
                this._record.setMapField(resource, partitionWeightMap);
            }
            partitionWeightMap.put(partition, new Integer(weight).toString());
        }

        void setDefaultWeight(int defaultCapacity) {
            this._record.setIntField(ResourceWeightProperty.DEFAULT_WEIGHT.name(), defaultCapacity);
        }

        private int getDefaultWeight() {
            return this._record.getIntField(ResourceWeightProperty.DEFAULT_WEIGHT.name(), 1);
        }

        @Override
        public boolean isValid() {
            try {
                for (String string : this._record.getSimpleFields().values()) {
                    if (Integer.parseInt(string) >= 0) continue;
                    return false;
                }
                for (Map map : this._record.getMapFields().values()) {
                    for (String weightStr : map.values()) {
                        if (Integer.parseInt(weightStr) >= 0) continue;
                        return false;
                    }
                }
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }

        static enum ResourceWeightProperty {
            DEFAULT_WEIGHT,
            DEFAULT_RESOURCE_WEIGHT;

        }
    }
}

