/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.io.IOException;
import org.apache.helix.task.TaskPartitionState;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskExecutionInfo {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final long TIMESTAMP_NOT_SET = -1L;
    private final String _jobName;
    private final Integer _taskPartitionIndex;
    private final TaskPartitionState _taskPartitionState;
    private final Long _startTimeStamp;

    @JsonCreator
    public TaskExecutionInfo(@JsonProperty(value="jobName") String job, @JsonProperty(value="taskPartitionIndex") Integer index, @JsonProperty(value="taskPartitionState") TaskPartitionState state, @JsonProperty(value="startTimeStamp") Long timeStamp) {
        this._jobName = job;
        this._taskPartitionIndex = index;
        this._taskPartitionState = state;
        this._startTimeStamp = timeStamp == null ? -1L : timeStamp;
    }

    public String getJobName() {
        return this._jobName;
    }

    public Integer getTaskPartitionIndex() {
        return this._taskPartitionIndex;
    }

    public TaskPartitionState getTaskPartitionState() {
        return this._taskPartitionState;
    }

    public Long getStartTimeStamp() {
        return this._startTimeStamp;
    }

    public String toJson() throws IOException {
        return OBJECT_MAPPER.writeValueAsString((Object)this);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TaskExecutionInfo)) {
            return false;
        }
        TaskExecutionInfo infoObj = (TaskExecutionInfo)obj;
        return this.nullOrEquals(this.getJobName(), infoObj.getJobName()) && this.nullOrEquals(this.getTaskPartitionIndex(), infoObj.getTaskPartitionIndex()) && this.nullOrEquals((Object)this.getTaskPartitionState(), (Object)infoObj.getTaskPartitionState()) && this.nullOrEquals(this.getStartTimeStamp(), infoObj.getStartTimeStamp());
    }

    private boolean nullOrEquals(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o2 != null && o1.equals(o2);
    }
}

