/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.IdealState;

public class IdealStateCalculatorByShuffling {
    public static ZNRecord calculateIdealState(List<String> instanceNames, int partitions, int replicas, String resourceName, long randomSeed) {
        return IdealStateCalculatorByShuffling.calculateIdealState(instanceNames, partitions, replicas, resourceName, randomSeed, "MASTER", "SLAVE");
    }

    public static ZNRecord calculateIdealState(List<String> instanceNames, int partitions, int replicas, String resourceName, long randomSeed, String masterValue, String slaveValue) {
        if (instanceNames.size() <= replicas) {
            throw new IllegalArgumentException("Replicas must be less than number of storage nodes");
        }
        Collections.sort(instanceNames);
        ZNRecord result = new ZNRecord(resourceName);
        ArrayList<Integer> partitionList = new ArrayList<Integer>(partitions);
        for (int i = 0; i < partitions; ++i) {
            partitionList.add(new Integer(i));
        }
        Random rand = new Random(randomSeed);
        Collections.shuffle(partitionList, rand);
        for (int i = 0; i < partitionList.size(); ++i) {
            int partitionId = (Integer)partitionList.get(i);
            TreeMap<String, String> partitionAssignment = new TreeMap<String, String>();
            int masterNode = i % instanceNames.size();
            partitionAssignment.put(instanceNames.get(masterNode), masterValue);
            for (int j = 1; j <= replicas; ++j) {
                int index = (masterNode + j * partitionList.size()) % instanceNames.size();
                while (partitionAssignment.keySet().contains(instanceNames.get(index))) {
                    index = (index + 1) % instanceNames.size();
                }
                partitionAssignment.put(instanceNames.get(index), slaveValue);
            }
            String partitionName = resourceName + "_" + partitionId;
            result.setMapField(partitionName, partitionAssignment);
        }
        result.setSimpleField(IdealState.IdealStateProperty.NUM_PARTITIONS.toString(), String.valueOf(partitions));
        return result;
    }

    public static ZNRecord calculateIdealState(List<String> instanceNames, int partitions, int replicas, String resourceName) {
        long randomSeed = 888997632L;
        return IdealStateCalculatorByShuffling.calculateIdealState(instanceNames, partitions, replicas, resourceName, randomSeed);
    }
}

