/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.helix.HelixException;
import org.apache.helix.rest.common.HelixRestNamespace;
import org.apache.helix.rest.server.HelixRestServer;
import org.apache.helix.rest.server.auditlog.auditloggers.FileBasedAuditLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class HelixRestMain {
    private static Logger LOG = LoggerFactory.getLogger(HelixRestServer.class);
    private static final String HELP = "help";
    private static final String ZKSERVERADDRESS = "zkSvr";
    private static final String NAMESPACE_MANIFEST_FILE = "namespace-manifest-file";
    private static final String PORT = "port";
    private static final int DEFAULT_PORT = 8100;
    private static final String URI_PREFIX = "/admin/v2";

    private static void printUsage(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("java " + HelixRestServer.class.getName(), cliOptions);
    }

    private static Options constructCommandLineOptions() {
        OptionBuilder.withLongOpt((String)HELP);
        OptionBuilder.withDescription((String)"Prints command-line options info");
        Option helpOption = OptionBuilder.create();
        helpOption.setArgs(0);
        helpOption.setRequired(false);
        helpOption.setArgName("print help message");
        OptionBuilder.withLongOpt((String)ZKSERVERADDRESS);
        OptionBuilder.withDescription((String)"Provide zookeeper address");
        Option zkServerOption = OptionBuilder.create();
        zkServerOption.setArgs(1);
        zkServerOption.setRequired(true);
        zkServerOption.setArgName("ZookeeperServerAddress(Required)");
        OptionBuilder.withLongOpt((String)NAMESPACE_MANIFEST_FILE);
        OptionBuilder.withDescription((String)"A yaml file describing helix namespace");
        Option helixRestNamespaceOption = OptionBuilder.create();
        helixRestNamespaceOption.setArgs(1);
        helixRestNamespaceOption.setRequired(false);
        helixRestNamespaceOption.setArgName("NamespaceManifestFile(Optional)");
        OptionBuilder.withLongOpt((String)PORT);
        OptionBuilder.withDescription((String)"Provide web service port");
        Option portOption = OptionBuilder.create();
        portOption.setArgs(1);
        portOption.setRequired(false);
        portOption.setArgName("web service port, default: 8100");
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(zkServerOption);
        options.addOption(portOption);
        options.addOption(helixRestNamespaceOption);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCommandLineArgs(String[] cliArgs) throws Exception {
        GnuParser cliParser = new GnuParser();
        Options cliOptions = HelixRestMain.constructCommandLineOptions();
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(cliOptions, cliArgs);
        }
        catch (ParseException pe) {
            LOG.error("RestAdminApplication: failed to parse command-line options: " + pe.toString());
            HelixRestMain.printUsage(cliOptions);
            System.exit(1);
        }
        int port = 8100;
        ArrayList<HelixRestNamespace> namespaces = new ArrayList<HelixRestNamespace>();
        if (cmd.hasOption(HELP)) {
            HelixRestMain.printUsage(cliOptions);
            return;
        }
        if (cmd.hasOption(PORT)) {
            port = Integer.parseInt(cmd.getOptionValue(PORT));
        }
        String zkAddr = String.valueOf(cmd.getOptionValue(ZKSERVERADDRESS));
        namespaces.add(new HelixRestNamespace(zkAddr));
        if (cmd.hasOption(NAMESPACE_MANIFEST_FILE)) {
            HelixRestMain.constructNamespaceFromConfigFile(String.valueOf(cmd.getOptionValue(NAMESPACE_MANIFEST_FILE)), namespaces);
        }
        HelixRestServer restServer = new HelixRestServer(namespaces, port, URI_PREFIX, Arrays.asList(new FileBasedAuditLogger()));
        try {
            restServer.start();
            restServer.join();
        }
        catch (HelixException ex) {
            LOG.error("Failed to start Helix rest server, " + (Object)((Object)ex));
        }
        finally {
            restServer.shutdown();
        }
    }

    private static void constructNamespaceFromConfigFile(String filePath, List<HelixRestNamespace> namespaces) throws IOException {
        Yaml yaml = new Yaml();
        ArrayList configs = (ArrayList)yaml.load((InputStream)new FileInputStream(new File(filePath)));
        for (Map config : configs) {
            namespaces.add(new HelixRestNamespace((String)config.get(HelixRestNamespace.HelixRestNamespaceProperty.NAME.name()), HelixRestNamespace.HelixMetadataStoreType.valueOf((String)config.get(HelixRestNamespace.HelixRestNamespaceProperty.METADATA_STORE_TYPE.name())), (String)config.get(HelixRestNamespace.HelixRestNamespaceProperty.METADATA_STORE_ADDRESS.name()), false));
        }
    }

    public static void main(String[] args) throws Exception {
        HelixRestMain.processCommandLineArgs(args);
    }
}

