/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.resource;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Objects;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.util.SystemUtils;

public abstract class AnnotationInfo {
    protected final String annotationValue;
    protected final Class<?> javaClass;
    protected final Method javaMethod;
    protected final Method javaMethodImpl;

    protected static Class<?> getJavaActualType(Class<?> currentClass, String genericTypeName) {
        Class<?> result = null;
        result = AnnotationInfo.getJavaActualType(currentClass.getGenericSuperclass(), genericTypeName);
        if (result == null) {
            Type[] interfaceTypes = currentClass.getGenericInterfaces();
            for (int i = 0; result == null && i < interfaceTypes.length; ++i) {
                result = AnnotationInfo.getJavaActualType(interfaceTypes[i], genericTypeName);
            }
        }
        return result;
    }

    protected static Class<?> getJavaActualType(Type currentType, String genericTypeName) {
        Class<?> result = null;
        if (currentType != null) {
            if (currentType instanceof Class) {
                result = AnnotationInfo.getJavaActualType((Class)currentType, genericTypeName);
            } else if (currentType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)currentType;
                Class rawType = (Class)parameterizedType.getRawType();
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
                for (int i = 0; result == null && i < actualTypeArguments.length; ++i) {
                    if (!genericTypeName.equals(typeParameters[i].getName())) continue;
                    result = AnnotationInfo.getTypeClass(actualTypeArguments[i]);
                }
            }
        }
        return result;
    }

    protected static Class<?> getTypeClass(Type type) {
        Type componentType;
        Class<?> componentClass;
        Class<?> result = null;
        if (type instanceof Class) {
            result = (Class<?>)type;
        } else if (type instanceof ParameterizedType) {
            result = AnnotationInfo.getTypeClass(((ParameterizedType)type).getRawType());
        } else if (type instanceof GenericArrayType && (componentClass = AnnotationInfo.getTypeClass(componentType = ((GenericArrayType)type).getGenericComponentType())) != null) {
            result = Array.newInstance(componentClass, 0).getClass();
        }
        return result;
    }

    public AnnotationInfo(Class<?> javaClass, Method javaMethod, String annotationValue) {
        this.javaClass = javaClass;
        this.javaMethod = javaMethod;
        this.annotationValue = annotationValue;
        Method m = null;
        try {
            m = javaClass.getMethod(javaMethod.getName(), javaMethod.getParameterTypes());
        }
        catch (Exception e) {
            m = javaMethod;
        }
        this.javaMethodImpl = m != null ? m : javaMethod;
    }

    public AnnotationInfo(Class<?> javaClass, String annotationValue) {
        this(javaClass, null, annotationValue);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AnnotationInfo)) {
            return false;
        }
        AnnotationInfo that = (AnnotationInfo)other;
        return Objects.equals(this.getJavaMethod(), that.getJavaMethod()) && Objects.equals(this.getJavaClass(), that.getJavaClass()) && Objects.equals(this.getAnnotationValue(), that.getAnnotationValue());
    }

    public String getAnnotationValue() {
        return this.annotationValue;
    }

    protected Class<?> getJavaActualType(Class<?> initialType, Type genericType) {
        Class<?> result = initialType;
        try {
            if (genericType instanceof TypeVariable) {
                TypeVariable genericTypeVariable = (TypeVariable)genericType;
                String genericTypeName = genericTypeVariable.getName();
                result = AnnotationInfo.getJavaActualType(this.getJavaClass(), genericTypeName);
            }
        }
        catch (Throwable t) {
            Context.getCurrentLogger().log(Level.WARNING, "Cannot get actual type of generic type: " + genericType, t);
        }
        return result;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public int hashCode() {
        return SystemUtils.hashCode(this.annotationValue, this.javaClass, this.javaMethod);
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public String toString() {
        return "AnnotationInfo [javaMethod: " + this.javaMethod + ", javaClass: " + this.javaClass + ", value: " + this.annotationValue + "]";
    }
}

