/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import java.util.Collections;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.common.caches.AbstractDataCache;
import org.apache.helix.common.caches.PropertyCache;
import org.apache.helix.model.CustomizedView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizedViewCache
extends AbstractDataCache<CustomizedView> {
    private static final Logger LOG = LoggerFactory.getLogger((String)CustomizedViewCache.class.getName());
    private final PropertyCache<CustomizedView> _customizedViewCache;
    protected String _clusterName;
    private PropertyType _propertyType;
    private String _customizedStateType;

    public CustomizedViewCache(String clusterName, String customizedStateType) {
        this(clusterName, PropertyType.CUSTOMIZEDVIEW, customizedStateType);
    }

    protected CustomizedViewCache(String clusterName, PropertyType propertyType, String customizedStateType) {
        super(CustomizedViewCache.createDefaultControlContextProvider(clusterName));
        this._clusterName = clusterName;
        this._propertyType = propertyType;
        this._customizedStateType = customizedStateType;
        this._customizedViewCache = new PropertyCache<CustomizedView>(AbstractDataCache.createDefaultControlContextProvider(clusterName), "CustomizedView", new PropertyCache.PropertyCacheKeyFuncs<CustomizedView>(){

            @Override
            public PropertyKey getRootKey(HelixDataAccessor accessor) {
                return accessor.keyBuilder().customizedView(CustomizedViewCache.this._customizedStateType);
            }

            @Override
            public PropertyKey getObjPropertyKey(HelixDataAccessor accessor, String objName) {
                return accessor.keyBuilder().customizedView(CustomizedViewCache.this._customizedStateType, objName);
            }

            @Override
            public String getObjName(CustomizedView obj) {
                return obj.getResourceName();
            }
        }, true);
    }

    public void refresh(HelixDataAccessor accessor) {
        this._customizedViewCache.refresh(accessor);
    }

    public Map<String, CustomizedView> getCustomizedViewMap() {
        return Collections.unmodifiableMap(this._customizedViewCache.getPropertyMap());
    }

    public PropertyCache<CustomizedView> getCustomizedViewCache() {
        return this._customizedViewCache;
    }
}

