/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableUtils;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public abstract class AbstractBaseAlterTableAnalyzer
extends BaseSemanticAnalyzer {
    private DDLDesc.DDLDescWithWriteId ddlDescWithWriteId;

    public AbstractBaseAlterTableAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    protected void setAcidDdlDesc(DDLDesc.DDLDescWithWriteId descWithWriteId) {
        if (this.ddlDescWithWriteId != null) {
            throw new IllegalStateException("ddlDescWithWriteId is already set: " + String.valueOf(this.ddlDescWithWriteId));
        }
        this.ddlDescWithWriteId = descWithWriteId;
    }

    @Override
    public DDLDesc.DDLDescWithWriteId getAcidDdlDesc() {
        return this.ddlDescWithWriteId;
    }

    protected void addInputsOutputsAlterTable(TableName tableName, Map<String, String> partitionSpec, AbstractAlterTableDesc desc, AlterTableType op, boolean doForceExclusive) throws SemanticException {
        WriteEntity.WriteType writeType;
        boolean alterPartitions;
        boolean isCascade = desc != null && desc.isCascade();
        boolean bl = alterPartitions = partitionSpec != null && !partitionSpec.isEmpty();
        if (isCascade && alterPartitions) {
            throw new SemanticException(ErrorMsg.ALTER_TABLE_PARTITION_CASCADE_NOT_SUPPORTED, new String[]{op.getName()});
        }
        Table table = this.getTable(tableName, true);
        if (isCascade && !table.isPartitioned()) {
            throw new SemanticException(ErrorMsg.ALTER_TABLE_NON_PARTITIONED_TABLE_CASCADE_NOT_SUPPORTED, new String[0]);
        }
        WriteEntity.WriteType writeType2 = writeType = doForceExclusive ? WriteEntity.WriteType.DDL_EXCLUSIVE : this.determineAlterTableWriteType(table, desc, op);
        if (!alterPartitions) {
            this.inputs.add(new ReadEntity(table));
            WriteEntity alterTableOutput = new WriteEntity(table, writeType);
            this.outputs.add(alterTableOutput);
            if (isCascade) {
                for (Partition part : PartitionUtils.getPartitions(this.db, table, partitionSpec, false)) {
                    this.outputs.add(new WriteEntity(part, WriteEntity.WriteType.DDL_NO_LOCK));
                }
            }
        } else {
            ReadEntity re = new ReadEntity(table);
            re.noLockNeeded();
            this.inputs.add(re);
            if (AlterTableUtils.isFullPartitionSpec(table, partitionSpec)) {
                Partition part = PartitionUtils.getPartition(this.db, table, partitionSpec, true);
                this.outputs.add(new WriteEntity(part, writeType));
            } else {
                if (!AlterTableType.SUPPORT_PARTIAL_PARTITION_SPEC.contains((Object)op)) {
                    throw new SemanticException(ErrorMsg.ALTER_TABLE_TYPE_PARTIAL_PARTITION_SPEC_NO_SUPPORTED, new String[]{op.getName()});
                }
                if (!this.conf.getBoolVar(HiveConf.ConfVars.DYNAMIC_PARTITIONING)) {
                    throw new SemanticException(ErrorMsg.DYNAMIC_PARTITION_DISABLED, new String[0]);
                }
                for (Partition part : PartitionUtils.getPartitions(this.db, table, partitionSpec, true)) {
                    this.outputs.add(new WriteEntity(part, writeType));
                }
            }
        }
        if (desc != null) {
            this.validateAlterTableType(table, op, desc.expectView());
        }
    }

    private WriteEntity.WriteType determineAlterTableWriteType(Table table, AbstractAlterTableDesc desc, AlterTableType op) {
        boolean convertingToAcid = false;
        if (desc != null && desc.getProps() != null && Boolean.parseBoolean(desc.getProps().get("transactional"))) {
            convertingToAcid = true;
        }
        if (!AcidUtils.isTransactionalTable(table) && convertingToAcid) {
            return WriteEntity.WriteType.DDL_EXCLUSIVE;
        }
        return WriteEntity.determineAlterTableWriteType(op, table, this.conf);
    }

    protected void validateAlterTableType(Table table, AlterTableType op, boolean expectView) throws SemanticException {
        block7: {
            block6: {
                if (!table.isView()) break block6;
                if (!expectView) {
                    throw new SemanticException(ErrorMsg.ALTER_COMMAND_FOR_VIEWS.getMsg());
                }
                switch (op) {
                    case ADDPARTITION: 
                    case DROPPARTITION: 
                    case RENAMEPARTITION: 
                    case ADDPROPS: 
                    case DROPPROPS: 
                    case RENAME: {
                        break block7;
                    }
                    default: {
                        throw new SemanticException(ErrorMsg.ALTER_VIEW_DISALLOWED_OP.getMsg(op.toString()));
                    }
                }
            }
            if (expectView) {
                throw new SemanticException(ErrorMsg.ALTER_COMMAND_FOR_TABLES.getMsg());
            }
        }
        if (table.isNonNative() && table.getStorageHandler() != null && !table.getStorageHandler().isAllowedAlterOperation(op)) {
            throw new SemanticException(ErrorMsg.ALTER_TABLE_NON_NATIVE.format(new String[]{AlterTableType.NON_NATIVE_TABLE_ALLOWED.toString(), table.getTableName()}));
        }
    }
}

