/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.column.change;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.column.change.AlterTableChangeColumnDesc;
import org.apache.hadoop.hive.ql.ddl.table.constraint.Constraints;
import org.apache.hadoop.hive.ql.ddl.table.constraint.ConstraintsUtils;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={890})
public class AlterTableChangeColumnAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableChangeColumnAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        String oldColumnName = command.getChild(0).getText().toLowerCase();
        String newColumnName = command.getChild(1).getText().toLowerCase();
        String newType = AlterTableChangeColumnAnalyzer.getTypeStringFromAST((ASTNode)command.getChild(2));
        Table table = this.getTable(tableName);
        SkewedInfo skewInfo = table.getTTable().getSd().getSkewedInfo();
        if (null != skewInfo && null != skewInfo.getSkewedColNames() && skewInfo.getSkewedColNames().contains(oldColumnName)) {
            throw new SemanticException(oldColumnName + ErrorMsg.ALTER_TABLE_NOT_ALLOWED_RENAME_SKEWED_COLUMN.getMsg());
        }
        String newComment = null;
        boolean first = false;
        String flagCol = null;
        boolean isCascade = false;
        ASTNode constraintChild = null;
        block7: for (int i = 3; i < command.getChildCount(); ++i) {
            ASTNode child = (ASTNode)command.getChild(i);
            switch (child.getToken().getType()) {
                case 439: {
                    newComment = AlterTableChangeColumnAnalyzer.unescapeSQLString(child.getText());
                    continue block7;
                }
                case 869: {
                    flagCol = AlterTableChangeColumnAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                    continue block7;
                }
                case 153: {
                    first = true;
                    continue block7;
                }
                case 940: {
                    isCascade = true;
                    continue block7;
                }
                case 1183: {
                    continue block7;
                }
                default: {
                    constraintChild = child;
                }
            }
        }
        Constraints constraints = this.getConstraints(tableName, command, newColumnName, table, constraintChild);
        AlterTableChangeColumnDesc desc = new AlterTableChangeColumnDesc(tableName, partitionSpec, isCascade, constraints, AlterTableChangeColumnAnalyzer.unescapeIdentifier(oldColumnName), AlterTableChangeColumnAnalyzer.unescapeIdentifier(newColumnName), newType, newComment, first, flagCol);
        if (AcidUtils.isTransactionalTable(table)) {
            this.setAcidDdlDesc(desc);
        }
        this.addInputsOutputsAlterTable(tableName, partitionSpec, desc, desc.getType(), false);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private Constraints getConstraints(TableName tableName, ASTNode command, String newColumnName, Table table, ASTNode constraintChild) throws SemanticException {
        boolean isNativeColumnDefaultSupported;
        ArrayList<SQLPrimaryKey> primaryKeys = null;
        ArrayList<SQLForeignKey> foreignKeys = null;
        ArrayList<SQLUniqueConstraint> uniqueConstraints = null;
        ArrayList<SQLNotNullConstraint> notNullConstraints = null;
        ArrayList<SQLDefaultConstraint> defaultConstraints = null;
        List<ConstraintsUtils.ConstraintInfo> defaultConstraintInfo = null;
        ArrayList<SQLCheckConstraint> checkConstraints = null;
        if (constraintChild != null) {
            switch (constraintChild.getToken().getType()) {
                case 945: {
                    checkConstraints = new ArrayList<SQLCheckConstraint>();
                    ConstraintsUtils.processCheckConstraints(tableName, constraintChild, (List<String>)ImmutableList.of((Object)newColumnName), checkConstraints, (ASTNode)command.getChild(2), this.ctx.getTokenRewriteStream());
                    break;
                }
                case 990: {
                    defaultConstraintInfo = ConstraintsUtils.processDefaultConstraints(constraintChild, (List<String>)ImmutableList.of((Object)newColumnName), (ASTNode)command.getChild(2), this.ctx.getTokenRewriteStream());
                    break;
                }
                case 1102: {
                    notNullConstraints = new ArrayList<SQLNotNullConstraint>();
                    ConstraintsUtils.processNotNullConstraints(tableName, constraintChild, (List<String>)ImmutableList.of((Object)newColumnName), notNullConstraints);
                    break;
                }
                case 1304: {
                    uniqueConstraints = new ArrayList<SQLUniqueConstraint>();
                    ConstraintsUtils.processUniqueConstraints(tableName, constraintChild, (List<String>)ImmutableList.of((Object)newColumnName), uniqueConstraints);
                    break;
                }
                case 1141: {
                    primaryKeys = new ArrayList<SQLPrimaryKey>();
                    ConstraintsUtils.processPrimaryKeys(tableName, constraintChild, (List<String>)ImmutableList.of((Object)newColumnName), primaryKeys);
                    break;
                }
                case 1035: {
                    foreignKeys = new ArrayList<SQLForeignKey>();
                    ConstraintsUtils.processForeignKeys(tableName, constraintChild, foreignKeys);
                    break;
                }
                default: {
                    throw new SemanticException(ErrorMsg.NOT_RECOGNIZED_CONSTRAINT.getMsg(constraintChild.getToken().getText()));
                }
            }
        }
        if (checkConstraints != null && !checkConstraints.isEmpty()) {
            ConstraintsUtils.validateCheckConstraint(table.getCols(), checkConstraints, this.ctx.getConf());
        }
        boolean bl = isNativeColumnDefaultSupported = table.getStorageHandler() != null && table.getStorageHandler().supportsDefaultColumnValues(table.getParameters());
        if (defaultConstraintInfo != null) {
            defaultConstraints = new ArrayList<SQLDefaultConstraint>();
            ConstraintsUtils.constraintInfosToDefaultConstraints(tableName, defaultConstraintInfo, defaultConstraints, isNativeColumnDefaultSupported);
            DDLUtils.setDefaultColumnValues(table, tableName, defaultConstraintInfo, this.ctx.getConf());
        }
        if (table.getTableType() == TableType.EXTERNAL_TABLE && ConstraintsUtils.hasEnabledOrValidatedConstraints(notNullConstraints, defaultConstraints, checkConstraints, isNativeColumnDefaultSupported)) {
            throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Constraints are disallowed with External tables. Only RELY is allowed."));
        }
        return new Constraints(primaryKeys, foreignKeys, notNullConstraints, uniqueConstraints, defaultConstraints, checkConstraints);
    }
}

