/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.column.update;

import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.column.update.AlterTableUpdateColumnsDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;

public class AlterTableUpdateColumnsOperation
extends AbstractAlterTableOperation<AlterTableUpdateColumnsDesc> {
    public AlterTableUpdateColumnsOperation(DDLOperationContext context, AlterTableUpdateColumnsDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Table table, Partition partition) throws HiveException {
        String serializationLib = table.getSd().getSerdeInfo().getSerializationLib();
        Collection serdes = MetastoreConf.getStringCollection((Configuration)this.context.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SERDES_USING_METASTORE_FOR_SCHEMA);
        if (serdes.contains(serializationLib)) {
            throw new HiveException(table.getTableName() + " has serde " + serializationLib + " for which schema is already handled by HMS.");
        }
        Deserializer deserializer = table.getDeserializer(true);
        try {
            LOG.info("Updating metastore columns for table: {}", (Object)table.getTableName());
            List fields = HiveMetaStoreUtils.getFieldsFromDeserializer((String)table.getTableName(), (Deserializer)deserializer, (Configuration)this.context.getConf());
            StorageDescriptor sd = this.getStorageDescriptor(table, partition);
            sd.setCols(fields);
        }
        catch (MetaException | SerDeException e) {
            LOG.error("alter table update columns: {}", e);
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR);
        }
    }
}

