/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.compact;

import java.util.HashMap;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.storage.compact.AlterTableCompactDesc;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

@DDLSemanticAnalyzerFactory.DDLType(types={871})
public class AlterTableCompactAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableCompactAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        String type = AlterTableCompactAnalyzer.unescapeSQLString(command.getChild(0).getText()).toLowerCase();
        int numberOfBuckets = 0;
        try {
            CompactionType.valueOf((String)type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new SemanticException(ErrorMsg.INVALID_COMPACTION_TYPE.getMsg());
        }
        Map<String, String> mapProp = null;
        boolean isBlocking = false;
        String poolName = null;
        String orderBy = null;
        ExprNodeDesc filterExpr = null;
        block14: for (int i = 0; i < command.getChildCount(); ++i) {
            Tree node = command.getChild(i);
            switch (node.getType()) {
                case 1264: {
                    mapProp = AlterTableCompactAnalyzer.getProps((ASTNode)node.getChild(0));
                    continue block14;
                }
                case 936: {
                    isBlocking = true;
                    continue block14;
                }
                case 953: {
                    poolName = AlterTableCompactAnalyzer.unescapeSQLString(node.getChild(0).getText());
                    continue block14;
                }
                case 868: {
                    try {
                        numberOfBuckets = Integer.parseInt(node.getChild(0).getText());
                        continue block14;
                    }
                    catch (NumberFormatException nfe) {
                        throw new SemanticException("Could not parse bucket number: " + node.getChild(0).getText());
                    }
                }
                case 1130: {
                    orderBy = this.ctx.getTokenRewriteStream().toOriginalString(node.getTokenStartIndex(), node.getTokenStopIndex());
                    continue block14;
                }
                case 1323: {
                    Table table;
                    RowResolver rwsch = new RowResolver();
                    HashMap<String, String> colTypes = new HashMap<String, String>();
                    try {
                        table = this.getDb().getTable(tableName);
                        for (FieldSchema fs : table.getCols()) {
                            TypeInfo columnType = TypeInfoUtils.getTypeInfoFromTypeString((String)fs.getType());
                            rwsch.put(tableName.getTable(), fs.getName(), new ColumnInfo(fs.getName(), columnType, null, true));
                            colTypes.put(fs.getName().toLowerCase(), fs.getType());
                        }
                    }
                    catch (HiveException e) {
                        throw new SemanticException((Throwable)e);
                    }
                    TypeCheckCtx tcCtx = new TypeCheckCtx(rwsch);
                    ASTNode conds = (ASTNode)node.getChild(0);
                    filterExpr = ExprNodeTypeCheck.genExprNode(conds, tcCtx).get(conds);
                    if (PartitionPruner.onlyContainsPartnCols(table, filterExpr)) continue block14;
                    throw new SemanticException(ErrorMsg.ALTER_TABLE_COMPACTION_NON_PARTITIONED_COLUMN_NOT_ALLOWED, new String[0]);
                }
            }
        }
        AlterTableCompactDesc desc = new AlterTableCompactDesc(tableName, partitionSpec, type, isBlocking, poolName, numberOfBuckets, mapProp, orderBy, filterExpr);
        this.addInputsOutputsAlterTable(tableName, partitionSpec, desc, desc.getType(), false);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    @Override
    public boolean isRequiresOpenTransaction() {
        return false;
    }

    @Override
    public void setQueryType(ASTNode tree) {
        this.queryProperties.setQueryType(QueryProperties.QueryType.OTHER);
    }
}

