/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathFuncLongToLong;

public class GroupingColumns
extends MathFuncLongToLong {
    private static final long serialVersionUID = 1L;
    private final long[] masks;

    public GroupingColumns(int inputColumnNum, int[] indices, int outputColumnNum) {
        super(inputColumnNum, outputColumnNum);
        int size = indices.length;
        this.masks = new long[size];
        for (int i = 0; i < size; ++i) {
            this.masks[i] = 1L << indices[i];
        }
    }

    public GroupingColumns() {
        this.masks = null;
    }

    @Override
    protected long func(long v) {
        int size = this.masks.length;
        int adjust = size - 1;
        long result = 0L;
        for (int i = 0; i < size; ++i) {
            if ((v & this.masks[i]) == 0L) continue;
            result += 1L << adjust - i;
        }
        return result;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.inputColumnNum[0] + ", masks " + Arrays.toString(this.masks);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }
}

