/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.BucketIdentifier;
import org.apache.hadoop.hive.ql.io.PositionDeleteInfo;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;

public class IOContext {
    private long currentBlockStart = 0L;
    private long nextBlockStart = -1L;
    private long currentRow = 0L;
    private boolean isBlockPointer = true;
    private boolean ioExceptions = false;
    private boolean useSorted = false;
    private boolean isBinarySearching = false;
    private boolean endBinarySearch = false;
    private Comparison comparison = null;
    private String genericUDFClassName = null;
    private RecordIdentifier ri;
    private boolean isDeletedRecord;
    private PositionDeleteInfo pdi;
    private Path inputPath;

    public long getCurrentBlockStart() {
        return this.currentBlockStart;
    }

    public void setCurrentBlockStart(long currentBlockStart) {
        this.currentBlockStart = currentBlockStart;
    }

    public long getNextBlockStart() {
        return this.nextBlockStart;
    }

    public void setNextBlockStart(long nextBlockStart) {
        this.nextBlockStart = nextBlockStart;
    }

    public long getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(long currentRow) {
        this.currentRow = currentRow;
    }

    public boolean isBlockPointer() {
        return this.isBlockPointer;
    }

    public void setBlockPointer(boolean isBlockPointer) {
        this.isBlockPointer = isBlockPointer;
    }

    public Path getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(Path inputPath) {
        this.inputPath = inputPath;
    }

    public void setIOExceptions(boolean ioe) {
        this.ioExceptions = ioe;
    }

    public boolean getIOExceptions() {
        return this.ioExceptions;
    }

    public boolean useSorted() {
        return this.useSorted;
    }

    public void setUseSorted(boolean useSorted) {
        this.useSorted = useSorted;
    }

    public boolean isBinarySearching() {
        return this.isBinarySearching;
    }

    public void setBinarySearching(boolean isBinarySearching) {
        this.isBinarySearching = isBinarySearching;
    }

    public boolean shouldEndBinarySearch() {
        return this.endBinarySearch;
    }

    public void setEndBinarySearch(boolean endBinarySearch) {
        this.endBinarySearch = endBinarySearch;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public void setComparison(Integer comparison) {
        if (comparison == null && this.isBinarySearching) {
            this.endBinarySearch = true;
        } else {
            this.comparison = comparison == null ? Comparison.UNKNOWN : (comparison < 0 ? Comparison.LESS : (comparison > 0 ? Comparison.GREATER : Comparison.EQUAL));
        }
    }

    public String getGenericUDFClassName() {
        return this.genericUDFClassName;
    }

    public void setGenericUDFClassName(String genericUDFClassName) {
        this.genericUDFClassName = genericUDFClassName;
    }

    public RecordIdentifier getRecordIdentifier() {
        return this.ri;
    }

    public void setRecordIdentifier(RecordIdentifier ri) {
        this.ri = ri;
    }

    public void parseRecordIdentifier(Configuration configuration) {
        BucketIdentifier bucketIdentifier = BucketIdentifier.from(configuration, this.inputPath);
        this.ri = bucketIdentifier == null ? null : new RecordIdentifier(bucketIdentifier.getWriteId(), bucketIdentifier.getBucketProperty(), 0L);
    }

    public void parsePositionDeleteInfo(Configuration configuration) {
        this.pdi = PositionDeleteInfo.parseFromConf(configuration);
    }

    public PositionDeleteInfo getPositionDeleteInfo() {
        return this.pdi;
    }

    public boolean isDeletedRecord() {
        return this.isDeletedRecord;
    }

    public void setDeletedRecord(boolean deletedRecord) {
        this.isDeletedRecord = deletedRecord;
    }

    public void resetSortingValues() {
        this.useSorted = false;
        this.isBinarySearching = false;
        this.endBinarySearch = false;
        this.comparison = null;
        this.genericUDFClassName = null;
    }

    public static enum Comparison {
        GREATER,
        LESS,
        EQUAL,
        UNKNOWN;

    }
}

