/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketVersionPopulator
extends Transform {
    protected static final Logger LOG = LoggerFactory.getLogger(BucketVersionPopulator.class);

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        Set<OpGroup> groups = this.findOpGroups(pctx);
        this.assignGroupVersions(groups);
        return pctx;
    }

    private void assignGroupVersions(Set<OpGroup> groups) {
        for (OpGroup opGroup : groups) {
            opGroup.analyzeBucketVersion();
            opGroup.setBucketVersion();
        }
    }

    private Set<OpGroup> findOpGroups(ParseContext pctx) throws SemanticException {
        BucketVersionProcessorCtx ctx = new BucketVersionProcessorCtx();
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(new IdentifyBucketGroups(), opRules, ctx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return ctx.groups;
    }

    private static class OpGroup {
        Set<Operator<?>> members = Sets.newIdentityHashSet();
        int version = -1;

        public void add(Operator<?> o) {
            this.members.add(o);
        }

        public void setBucketVersion() {
            for (Operator<?> operator : this.members) {
                operator.getConf().setBucketingVersion(this.version);
                LOG.debug("Bucketing version for {} is set to {}", operator, (Object)this.version);
            }
        }

        List<OperatorBucketingVersionInfo> getBucketingVersions() {
            ArrayList<OperatorBucketingVersionInfo> ret = new ArrayList<OperatorBucketingVersionInfo>();
            for (Operator<?> operator : this.members) {
                int bucketingVersion;
                if (operator instanceof TableScanOperator) {
                    TableScanOperator tso = (TableScanOperator)operator;
                    bucketingVersion = ((TableScanDesc)tso.getConf()).getTableMetadata().getBucketingVersion();
                    int numBuckets = ((TableScanDesc)tso.getConf()).getNumBuckets();
                    if (numBuckets > 1) {
                        ret.add(new OperatorBucketingVersionInfo(operator, InfoType.MANDATORY, bucketingVersion));
                    } else {
                        LOG.info("not considering bucketingVersion for: {} because it has {}<2 buckets ", (Object)tso, (Object)numBuckets);
                    }
                }
                if (!(operator instanceof FileSinkOperator)) continue;
                FileSinkOperator fso = (FileSinkOperator)operator;
                bucketingVersion = ((FileSinkDesc)fso.getConf()).getTableInfo().getBucketingVersion();
                ret.add(new OperatorBucketingVersionInfo(operator, InfoType.OPTIONAL, bucketingVersion));
            }
            return ret;
        }

        public void analyzeBucketVersion() {
            List<OperatorBucketingVersionInfo> bucketingVersions = this.getBucketingVersions();
            bucketingVersions.sort(OperatorBucketingVersionInfo.MANDATORY_FIRST);
            try {
                for (OperatorBucketingVersionInfo info : bucketingVersions) {
                    this.setVersion(info);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error setting bucketingVersion for group: " + String.valueOf(bucketingVersions), e);
            }
            if (this.version == -1) {
                this.version = 2;
            }
        }

        private void setVersion(OperatorBucketingVersionInfo info) {
            int newVersion = info.bucketingVersion;
            if (this.version == newVersion || newVersion == -1) {
                return;
            }
            if (this.version == -1) {
                this.version = newVersion;
                return;
            }
            if (info.infoType == InfoType.OPTIONAL) {
                LOG.debug("Ignoring version preference for {}; because {} is already set and its OPTIONAL", info.op, (Object)this.version);
                return;
            }
            throw new RuntimeException("Unable to set version");
        }

        public void merge(OpGroup opGroup) {
            for (Operator<?> operator : opGroup.members) {
                this.add(operator);
            }
            opGroup.members.clear();
        }
    }

    static class BucketVersionProcessorCtx
    implements NodeProcessorCtx {
        Set<OpGroup> groups = new HashSet<OpGroup>();

        BucketVersionProcessorCtx() {
        }
    }

    private static class IdentifyBucketGroups
    implements SemanticNodeProcessor {
        private IdentifyBucketGroups() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator o = (Operator)nd;
            OpGroup g = nodeOutputs.length == 0 ? this.newGroup(procCtx) : (OpGroup)nodeOutputs[0];
            for (int i = 1; i < nodeOutputs.length; ++i) {
                g.merge((OpGroup)nodeOutputs[i]);
            }
            g.add(o);
            if (o instanceof ReduceSinkOperator) {
                return this.newGroup(procCtx);
            }
            return g;
        }

        private OpGroup newGroup(NodeProcessorCtx procCtx) {
            BucketVersionProcessorCtx ctx = (BucketVersionProcessorCtx)procCtx;
            OpGroup g = new OpGroup();
            ctx.groups.add(g);
            return g;
        }
    }

    static class OperatorBucketingVersionInfo {
        public static final Comparator<OperatorBucketingVersionInfo> MANDATORY_FIRST = new Comparator<OperatorBucketingVersionInfo>(){

            @Override
            public int compare(OperatorBucketingVersionInfo i1, OperatorBucketingVersionInfo i2) {
                int r = i1.infoType.compareTo(i2.infoType);
                if (r != 0) {
                    return r;
                }
                r = Integer.compare(i2.bucketingVersion, i1.bucketingVersion);
                if (r != 0) {
                    return r;
                }
                r = i1.op.toString().compareTo(i2.op.toString());
                return r;
            }
        };
        private Operator<?> op;
        private int bucketingVersion;
        private InfoType infoType;

        public OperatorBucketingVersionInfo(Operator<?> op, InfoType infoType, int bucketingVersion) {
            this.op = op;
            this.infoType = infoType;
            this.bucketingVersion = bucketingVersion;
        }

        public String toString() {
            return String.format("[op: %s, bucketingVersion=%d, infoType=%s]", new Object[]{this.op, this.bucketingVersion, this.infoType});
        }
    }

    static enum InfoType {
        MANDATORY,
        OPTIONAL;

    }
}

