/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelColumnOrigin;
import org.apache.calcite.rel.metadata.RelMdRowCount;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAntiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.EstimateUniqueKeys;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRelMdRowCount
extends RelMdRowCount {
    protected static final Logger LOG = LoggerFactory.getLogger((String)HiveRelMdRowCount.class.getName());
    private static final Long HIVE_PK_FK_NO_FILTERING_COST_INCREASING_FACTOR = 1000000000000000L;
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.ROW_COUNT.method, (MetadataHandler)new HiveRelMdRowCount());

    protected HiveRelMdRowCount() {
    }

    public Double getRowCount(HiveJoin join, RelMetadataQuery mq) {
        Pair<PKFKRelationInfo, RexNode> constraintBasedResult = HiveRelMdRowCount.constraintsBasedAnalyzeJoinForPKFK(join, mq);
        if (constraintBasedResult != null) {
            double joinSelectivity = Math.min(1.0, ((PKFKRelationInfo)constraintBasedResult.left).pkInfo.selectivity * ((PKFKRelationInfo)constraintBasedResult.left).ndvScalingFactor);
            double residualSelectivity = RelMdUtil.guessSelectivity((RexNode)((RexNode)constraintBasedResult.right));
            double rowCount = ((PKFKRelationInfo)constraintBasedResult.left).isPKSideSimple ? ((PKFKRelationInfo)constraintBasedResult.left).pkInfo.rowCount + (double)HIVE_PK_FK_NO_FILTERING_COST_INCREASING_FACTOR.longValue() : ((PKFKRelationInfo)constraintBasedResult.left).fkInfo.rowCount * joinSelectivity * residualSelectivity;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Identified Primary - Foreign Key relation from constraints:\n {} {} Row count for join: {}\n Join selectivity: {}\n Residual selectivity: {}\n", new Object[]{RelOptUtil.toString((RelNode)join), constraintBasedResult.left, rowCount, joinSelectivity, residualSelectivity});
            }
            return rowCount;
        }
        PKFKRelationInfo pkfk = HiveRelMdRowCount.analyzeJoinForPKFK(join, mq);
        if (pkfk != null) {
            double selectivity = pkfk.pkInfo.selectivity * pkfk.ndvScalingFactor;
            selectivity = Math.min(1.0, selectivity);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Identified Primary - Foreign Key relation: {} {}", (Object)RelOptUtil.toString((RelNode)join), (Object)pkfk);
            }
            return pkfk.fkInfo.rowCount * selectivity;
        }
        Double rowCount = join.estimateRowCount(mq);
        if (LOG.isDebugEnabled()) {
            LOG.debug("No Primary - Foreign Key relation: \n{} Row count for join: {}\n", (Object)RelOptUtil.toString((RelNode)join), (Object)rowCount);
        }
        return rowCount;
    }

    public Double getRowCount(HiveSemiJoin rel, RelMetadataQuery mq) {
        return this.getRowCountInt(rel, mq);
    }

    public Double getRowCount(HiveAntiJoin rel, RelMetadataQuery mq) {
        return this.getRowCountInt(rel, mq);
    }

    private Double getRowCountInt(Join rel, RelMetadataQuery mq) {
        assert (rel.getJoinType() == JoinRelType.SEMI || rel.getJoinType() == JoinRelType.ANTI);
        PKFKRelationInfo pkfk = HiveRelMdRowCount.analyzeJoinForPKFK(rel, mq);
        if (pkfk != null) {
            double selectivity = pkfk.pkInfo.selectivity * pkfk.ndvScalingFactor;
            selectivity = Math.min(1.0, selectivity);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Identified Primary - Foreign Key relation: {} {}", (Object)RelOptUtil.toString((RelNode)rel), (Object)pkfk);
            }
            if (rel.getJoinType() == JoinRelType.ANTI) {
                return pkfk.fkInfo.rowCount * (1.0 - selectivity);
            }
            return pkfk.fkInfo.rowCount * selectivity;
        }
        if (rel.getJoinType() == JoinRelType.ANTI) {
            return mq.getRowCount(rel.getLeft()) - super.getRowCount(rel, mq);
        }
        return super.getRowCount(rel, mq);
    }

    public Double getRowCount(Sort rel, RelMetadataQuery mq) {
        int limit;
        int offset;
        int offsetLimit;
        Double rowCount = mq.getRowCount(rel.getInput());
        if (rowCount != null && rel.fetch != null && (double)(offsetLimit = (offset = rel.offset == null ? 0 : RexLiteral.intValue((RexNode)rel.offset)) + (limit = RexLiteral.intValue((RexNode)rel.fetch))) < rowCount) {
            return offsetLimit;
        }
        return rowCount;
    }

    public Double getRowCount(Filter rel, RelMetadataQuery mq) {
        if (rel instanceof HiveFilter.StatEnhancedHiveFilter) {
            return ((HiveFilter.StatEnhancedHiveFilter)rel).getRowCount();
        }
        return super.getRowCount(rel, mq);
    }

    public static PKFKRelationInfo analyzeJoinForPKFK(Join joinRel, RelMetadataQuery mq) {
        boolean rightIsKey;
        RelNode left = (RelNode)joinRel.getInputs().get(0);
        RelNode right = (RelNode)joinRel.getInputs().get(1);
        List initJoinFilters = RelOptUtil.conjunctions((RexNode)joinRel.getCondition());
        if (initJoinFilters.isEmpty()) {
            return null;
        }
        ArrayList<RexNode> leftFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> rightFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> joinFilters = new ArrayList<RexNode>(initJoinFilters);
        if (joinRel.isSemiJoin() || joinRel.getJoinType() == JoinRelType.ANTI) {
            return null;
        }
        RelOptUtil.classifyFilters((RelNode)joinRel, joinFilters, (JoinRelType)joinRel.getJoinType(), (boolean)false, (!joinRel.getJoinType().generatesNullsOnRight() ? 1 : 0) != 0, (!joinRel.getJoinType().generatesNullsOnLeft() ? 1 : 0) != 0, joinFilters, leftFilters, rightFilters);
        Pair<Integer, Integer> joinCols = HiveRelMdRowCount.canHandleJoin(joinRel, leftFilters, rightFilters, joinFilters);
        if (joinCols == null) {
            return null;
        }
        int leftColIdx = (Integer)joinCols.left;
        int rightColIdx = (Integer)joinCols.right;
        RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
        RexNode leftPred = RexUtil.composeConjunction((RexBuilder)rexBuilder, leftFilters, (boolean)true);
        RexNode rightPred = RexUtil.composeConjunction((RexBuilder)rexBuilder, rightFilters, (boolean)true);
        ImmutableBitSet lBitSet = ImmutableBitSet.of((int[])new int[]{leftColIdx});
        ImmutableBitSet rBitSet = ImmutableBitSet.of((int[])new int[]{rightColIdx});
        boolean leftIsKey = (joinRel.getJoinType() == JoinRelType.INNER || joinRel.getJoinType() == JoinRelType.RIGHT) && HiveRelMdRowCount.isKey(lBitSet, left, mq);
        boolean bl = rightIsKey = (joinRel.getJoinType() == JoinRelType.INNER || joinRel.getJoinType() == JoinRelType.LEFT) && HiveRelMdRowCount.isKey(rBitSet, right, mq);
        if (!leftIsKey && !rightIsKey) {
            return null;
        }
        double leftRowCount = mq.getRowCount(left);
        double rightRowCount = mq.getRowCount(right);
        if (leftIsKey && rightIsKey && rightRowCount < leftRowCount) {
            leftIsKey = false;
        }
        boolean pkSide = !leftIsKey;
        boolean isPKSideSimpleTree = leftIsKey ? (Boolean)SimpleTreeOnJoinKey.check((boolean)false, (RelNode)left, (ImmutableBitSet)lBitSet, (RelMetadataQuery)mq).left : (Boolean)SimpleTreeOnJoinKey.check((boolean)false, (RelNode)right, (ImmutableBitSet)rBitSet, (RelMetadataQuery)mq).left;
        double leftNDV = isPKSideSimpleTree ? mq.getDistinctRowCount(left, lBitSet, leftPred) : -1.0;
        double rightNDV = isPKSideSimpleTree ? mq.getDistinctRowCount(right, rBitSet, rightPred) : -1.0;
        double ndvScalingFactor = 1.0;
        if (isPKSideSimpleTree) {
            double d = ndvScalingFactor = !pkSide ? leftNDV / rightNDV : rightNDV / leftNDV;
        }
        if (!pkSide) {
            FKSideInfo fkInfo = new FKSideInfo(rightRowCount, rightNDV);
            double pkSelectivity = HiveRelMdRowCount.pkSelectivity(joinRel, mq, true, left, leftRowCount);
            PKSideInfo pkInfo = new PKSideInfo(leftRowCount, leftNDV, joinRel.getJoinType().generatesNullsOnRight() ? 1.0 : pkSelectivity);
            return new PKFKRelationInfo(1, fkInfo, pkInfo, ndvScalingFactor, isPKSideSimpleTree);
        }
        FKSideInfo fkInfo = new FKSideInfo(leftRowCount, leftNDV);
        double pkSelectivity = HiveRelMdRowCount.pkSelectivity(joinRel, mq, false, right, rightRowCount);
        PKSideInfo pkInfo = new PKSideInfo(rightRowCount, rightNDV, joinRel.getJoinType().generatesNullsOnLeft() ? 1.0 : pkSelectivity);
        return new PKFKRelationInfo(0, fkInfo, pkInfo, ndvScalingFactor, isPKSideSimpleTree);
    }

    public static Pair<PKFKRelationInfo, RexNode> constraintsBasedAnalyzeJoinForPKFK(Join join, RelMetadataQuery mq) {
        RexNode residualCond;
        double rightNDV;
        boolean rightIsKey;
        if (join.isSemiJoin() || join.getJoinType() == JoinRelType.ANTI) {
            return null;
        }
        RelNode left = (RelNode)join.getInputs().get(0);
        RelNode right = (RelNode)join.getInputs().get(1);
        List condConjs = RelOptUtil.conjunctions((RexNode)join.getCondition());
        if (condConjs.isEmpty()) {
            return null;
        }
        ArrayList<RexNode> joinFilters = new ArrayList<RexNode>(condConjs);
        ArrayList leftFilters = new ArrayList();
        ArrayList rightFilters = new ArrayList();
        RelOptUtil.classifyFilters((RelNode)join, joinFilters, (JoinRelType)join.getJoinType(), (boolean)false, (!join.getJoinType().generatesNullsOnRight() ? 1 : 0) != 0, (!join.getJoinType().generatesNullsOnLeft() ? 1 : 0) != 0, joinFilters, leftFilters, rightFilters);
        HiveRelOptUtil.PKFKJoinInfo leftInputResult = HiveRelOptUtil.extractPKFKJoin(join, joinFilters, false, mq);
        HiveRelOptUtil.PKFKJoinInfo rightInputResult = HiveRelOptUtil.extractPKFKJoin(join, joinFilters, true, mq);
        if (leftInputResult == null && rightInputResult == null) {
            return null;
        }
        boolean leftIsKey = (join.getJoinType() == JoinRelType.INNER || join.isSemiJoin() || join.getJoinType() == JoinRelType.ANTI || join.getJoinType() == JoinRelType.RIGHT) && leftInputResult.isPkFkJoin;
        boolean bl = rightIsKey = (join.getJoinType() == JoinRelType.INNER || join.isSemiJoin() || join.getJoinType() == JoinRelType.ANTI || join.getJoinType() == JoinRelType.LEFT) && rightInputResult.isPkFkJoin;
        if (!leftIsKey && !rightIsKey) {
            return null;
        }
        double leftRowCount = mq.getRowCount(left);
        double rightRowCount = mq.getRowCount(right);
        if (leftIsKey && rightIsKey && rightRowCount < leftRowCount) {
            leftIsKey = false;
        }
        ImmutableBitSet lBitSet = leftIsKey ? (ImmutableBitSet)leftInputResult.pkFkJoinColumns.left : (ImmutableBitSet)rightInputResult.pkFkJoinColumns.left;
        ImmutableBitSet rBitSet = leftIsKey ? (ImmutableBitSet)leftInputResult.pkFkJoinColumns.right : (ImmutableBitSet)rightInputResult.pkFkJoinColumns.right;
        List<RexNode> residualFilters = leftIsKey ? leftInputResult.additionalPredicates : rightInputResult.additionalPredicates;
        boolean pkSide = !leftIsKey;
        Pair<Boolean, Boolean> simpleTree = leftIsKey ? SimpleTreeOnJoinKey.check(true, left, lBitSet, mq) : SimpleTreeOnJoinKey.check(true, right, rBitSet, mq);
        boolean isPKSideSimpleTree = (Boolean)simpleTree.left;
        boolean isNoFilteringPKSideTree = (Boolean)simpleTree.right;
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RexNode leftPred = RexUtil.composeConjunction((RexBuilder)rexBuilder, leftFilters, (boolean)true);
        RexNode rightPred = RexUtil.composeConjunction((RexBuilder)rexBuilder, rightFilters, (boolean)true);
        double leftNDV = isPKSideSimpleTree ? mq.getDistinctRowCount(left, lBitSet, leftPred) : -1.0;
        double d = rightNDV = isPKSideSimpleTree ? mq.getDistinctRowCount(right, rBitSet, rightPred) : -1.0;
        RexNode rexNode = residualFilters.isEmpty() ? null : (residualCond = residualFilters.size() == 1 ? residualFilters.get(0) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, residualFilters));
        if (!pkSide) {
            FKSideInfo fkInfo = new FKSideInfo(rightRowCount, rightNDV);
            double pkSelectivity = HiveRelMdRowCount.pkSelectivity(join, mq, true, left, leftRowCount);
            PKSideInfo pkInfo = new PKSideInfo(leftRowCount, leftNDV, join.getJoinType().generatesNullsOnRight() ? 1.0 : pkSelectivity);
            double ndvScalingFactor = isPKSideSimpleTree ? leftNDV / rightNDV : 1.0;
            return Pair.of((Object)new PKFKRelationInfo(1, fkInfo, pkInfo, ndvScalingFactor, isNoFilteringPKSideTree), (Object)residualCond);
        }
        FKSideInfo fkInfo = new FKSideInfo(leftRowCount, leftNDV);
        double pkSelectivity = HiveRelMdRowCount.pkSelectivity(join, mq, false, right, rightRowCount);
        PKSideInfo pkInfo = new PKSideInfo(rightRowCount, rightNDV, join.getJoinType().generatesNullsOnLeft() ? 1.0 : pkSelectivity);
        double ndvScalingFactor = isPKSideSimpleTree ? rightNDV / leftNDV : 1.0;
        return Pair.of((Object)new PKFKRelationInfo(0, fkInfo, pkInfo, ndvScalingFactor, isNoFilteringPKSideTree), (Object)residualCond);
    }

    private static double pkSelectivity(Join joinRel, RelMetadataQuery mq, boolean leftChild, RelNode child, double childRowCount) {
        if (leftChild && joinRel.getJoinType().generatesNullsOnRight() || !leftChild && joinRel.getJoinType().generatesNullsOnLeft()) {
            return 1.0;
        }
        HiveTableScan tScan = EstimateUniqueKeys.getTableScan(child, true);
        if (tScan != null) {
            double tRowCount = mq.getRowCount((RelNode)tScan);
            return childRowCount / tRowCount;
        }
        return 1.0;
    }

    private static boolean isKey(ImmutableBitSet c, RelNode rel, RelMetadataQuery mq) {
        boolean isKey = false;
        Set<ImmutableBitSet> keys = EstimateUniqueKeys.getUniqueKeys(rel);
        if (keys != null) {
            for (ImmutableBitSet key : keys) {
                if (!key.equals((Object)c)) continue;
                isKey = true;
                break;
            }
        }
        return isKey;
    }

    private static Pair<Integer, Integer> canHandleJoin(Join joinRel, List<RexNode> leftFilters, List<RexNode> rightFilters, List<RexNode> joinFilters) {
        if (joinFilters.size() != 1) {
            return null;
        }
        RexNode joinCond = joinFilters.get(0);
        if (!(joinCond instanceof RexCall)) {
            return null;
        }
        if (((RexCall)joinCond).getOperator() != SqlStdOperatorTable.EQUALS) {
            return null;
        }
        ImmutableBitSet leftCols = RelOptUtil.InputFinder.bits((RexNode)((RexNode)((RexCall)joinCond).getOperands().get(0)));
        ImmutableBitSet rightCols = RelOptUtil.InputFinder.bits((RexNode)((RexNode)((RexCall)joinCond).getOperands().get(1)));
        if (leftCols.cardinality() != 1 || rightCols.cardinality() != 1) {
            return null;
        }
        int nFieldsLeft = joinRel.getLeft().getRowType().getFieldList().size();
        int nFieldsRight = joinRel.getRight().getRowType().getFieldList().size();
        int nSysFields = joinRel.getSystemFieldList().size();
        ImmutableBitSet rightFieldsBitSet = ImmutableBitSet.range((int)(nSysFields + nFieldsLeft), (int)(nSysFields + nFieldsLeft + nFieldsRight));
        if (rightFieldsBitSet.contains(leftCols)) {
            ImmutableBitSet t = leftCols;
            leftCols = rightCols;
            rightCols = t;
        }
        int leftColIdx = leftCols.nextSetBit(0) - nSysFields;
        int rightColIdx = rightCols.nextSetBit(0) - (nSysFields + nFieldsLeft);
        return new Pair((Object)leftColIdx, (Object)rightColIdx);
    }

    static class PKFKRelationInfo {
        public final int fkSide;
        public final double ndvScalingFactor;
        public final FKSideInfo fkInfo;
        public final PKSideInfo pkInfo;
        public final boolean isPKSideSimple;

        PKFKRelationInfo(int fkSide, FKSideInfo fkInfo, PKSideInfo pkInfo, double ndvScalingFactor, boolean isPKSideSimple) {
            this.fkSide = fkSide;
            this.fkInfo = fkInfo;
            this.pkInfo = pkInfo;
            this.ndvScalingFactor = ndvScalingFactor;
            this.isPKSideSimple = isPKSideSimple;
        }

        public String toString() {
            return String.format("Primary - Foreign Key join:\n\tfkSide = %d\n\tFKInfo:%s\n\tPKInfo:%s\n\tisPKSideSimple:%s\n\tNDV Scaling Factor:%.2f\n", this.fkSide, this.fkInfo, this.pkInfo, this.isPKSideSimple, this.ndvScalingFactor);
        }
    }

    static class PKSideInfo
    extends FKSideInfo {
        public final double selectivity;

        public PKSideInfo(double rowCount, double distinctCount, double selectivity) {
            super(rowCount, distinctCount);
            this.selectivity = selectivity;
        }

        @Override
        public String toString() {
            return String.format("PKInfo(rowCount=%.2f,ndv=%.2f,selectivity=%.2f)", this.rowCount, this.distinctCount, this.selectivity);
        }
    }

    static class FKSideInfo {
        public final double rowCount;
        public final double distinctCount;

        public FKSideInfo(double rowCount, double distinctCount) {
            this.rowCount = rowCount;
            this.distinctCount = distinctCount;
        }

        public String toString() {
            return String.format("FKInfo(rowCount=%.2f,ndv=%.2f)", this.rowCount, this.distinctCount);
        }
    }

    private static class SimpleTreeOnJoinKey
    extends RelVisitor {
        boolean constraintsBased;
        ImmutableBitSet joinKey;
        boolean simpleTree;
        boolean nonFilteringTree;
        RelMetadataQuery mq;

        static Pair<Boolean, Boolean> check(boolean constraintsBased, RelNode r, ImmutableBitSet joinKey, RelMetadataQuery mq) {
            SimpleTreeOnJoinKey v = new SimpleTreeOnJoinKey(constraintsBased, joinKey, mq);
            v.go(r);
            return Pair.of((Object)v.simpleTree, (Object)v.nonFilteringTree);
        }

        SimpleTreeOnJoinKey(boolean constraintsBased, ImmutableBitSet joinKey, RelMetadataQuery mq) {
            this.constraintsBased = constraintsBased;
            this.joinKey = joinKey;
            this.mq = mq;
            this.simpleTree = true;
            this.nonFilteringTree = true;
        }

        public void visit(RelNode node, int ordinal, RelNode parent) {
            if (node instanceof HepRelVertex) {
                node = ((HepRelVertex)node).getCurrentRel();
            }
            if (node instanceof TableScan) {
                this.simpleTree = true;
            } else if (node instanceof Project) {
                this.simpleTree = this.isSimple((Project)node);
                this.nonFilteringTree &= this.simpleTree;
            } else if (node instanceof Filter) {
                Filter filterOp = (Filter)node;
                List<RexNode> conjs = this.extractFilterPreds(filterOp);
                ImmutableBitSet condBits = RelOptUtil.InputFinder.bits(conjs, null);
                this.simpleTree = this.isSimple(condBits, filterOp, this.mq);
                this.nonFilteringTree &= conjs.isEmpty();
            } else {
                this.simpleTree = false;
                this.nonFilteringTree = false;
            }
            if (this.simpleTree) {
                super.visit(node, ordinal, parent);
            }
        }

        private boolean isSimple(Project project) {
            ImmutableBitSet.Builder b = ImmutableBitSet.builder();
            Iterator iterator = this.joinKey.iterator();
            while (iterator.hasNext()) {
                int pos = (Integer)iterator.next();
                RexNode r = (RexNode)project.getProjects().get(pos);
                if (!(r instanceof RexInputRef)) {
                    return false;
                }
                b.set(((RexInputRef)r).getIndex());
            }
            this.joinKey = b.build();
            return true;
        }

        private boolean isSimple(ImmutableBitSet condBits, Filter filter, RelMetadataQuery mq) {
            if (this.constraintsBased) {
                Boolean isUnique = mq.areColumnsUnique((RelNode)filter, condBits);
                return isUnique != null && isUnique != false;
            }
            return HiveRelMdRowCount.isKey(condBits, (RelNode)filter, mq);
        }

        private List<RexNode> extractFilterPreds(Filter filterOp) {
            ArrayList<RexNode> conjs = new ArrayList<RexNode>();
            for (RexNode r : HiveRelOptUtil.conjunctions((RexNode)filterOp.getCondition())) {
                if (r.getKind() == SqlKind.IS_NOT_NULL) {
                    RexCall isNotNullNode = (RexCall)r;
                    if (!RexUtil.isReferenceOrAccess((RexNode)((RexNode)isNotNullNode.getOperands().get(0)), (boolean)true)) continue;
                    ImmutableBitSet ref = RelOptUtil.InputFinder.bits((RexNode)isNotNullNode);
                    RelColumnOrigin co = this.mq.getColumnOrigin((RelNode)filterOp, ref.nextSetBit(0));
                    if (co == null) {
                        conjs.add(r);
                        continue;
                    }
                    RelOptHiveTable table = (RelOptHiveTable)co.getOriginTable();
                    List<ColStatistics> colStats = table.getColStat((List<Integer>)ImmutableList.of((Object)co.getOriginColumnOrdinal()), true);
                    if (colStats != null && !colStats.isEmpty() && colStats.get(0).getNumNulls() == 0L) continue;
                    conjs.add(r);
                    continue;
                }
                conjs.add(r);
            }
            return conjs;
        }
    }
}

