/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.mapper;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignature;
import org.apache.hadoop.hive.ql.optimizer.signature.RelTreeSignature;
import org.apache.hadoop.hive.ql.plan.mapper.PersistedRuntimeStats;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.stats.OperatorStats;

public class MapBackedStatsSource
implements StatsSource {
    private Map<OpTreeSignature, OperatorStats> map = new ConcurrentHashMap<OpTreeSignature, OperatorStats>();
    private Map<RelTreeSignature, OperatorStats> map2 = new ConcurrentHashMap<RelTreeSignature, OperatorStats>();

    @Override
    public boolean canProvideStatsFor(Class<?> clazz) {
        if (Operator.class.isAssignableFrom(clazz)) {
            return true;
        }
        return HiveFilter.class.isAssignableFrom(clazz);
    }

    @Override
    public Optional<OperatorStats> lookup(OpTreeSignature treeSig) {
        return Optional.ofNullable(this.map.get(treeSig));
    }

    @Override
    public Optional<OperatorStats> lookup(RelTreeSignature of) {
        return Optional.ofNullable(this.map2.get(of));
    }

    @Override
    public void load(List<PersistedRuntimeStats> statMap) {
        for (PersistedRuntimeStats persistedRuntimeStats : statMap) {
            if (persistedRuntimeStats.sig != null) {
                this.map.put(persistedRuntimeStats.sig, persistedRuntimeStats.stat);
            }
            if (persistedRuntimeStats.rSig == null) continue;
            this.map2.put(persistedRuntimeStats.rSig, persistedRuntimeStats.stat);
        }
    }
}

