/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderFactory;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorContext;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;

final class RebalanceQueryCompactor
extends QueryCompactor {
    RebalanceQueryCompactor() {
    }

    @Override
    public boolean run(CompactorContext context) throws IOException, HiveException {
        HiveConf hiveConf = context.getConf();
        Table table = context.getTable();
        AcidUtils.setAcidOperationalProperties((Configuration)context.getConf(), true, AcidUtils.getAcidOperationalProperties(table.getParameters()));
        StorageDescriptor storageDescriptor = context.getSd();
        AcidDirectory dir = context.getAcidDirectory();
        ValidWriteIdList writeIds = context.getValidWriteIdList();
        HiveConf conf = this.setUpDriverSession(hiveConf);
        String tmpTableName = this.getTempTableName(table);
        Path tmpTablePath = QueryCompactor.Util.getCompactionResultDir(storageDescriptor, writeIds, conf, true, false, null);
        int numBuckets = context.getCompactionInfo().numberOfBuckets;
        if (numBuckets <= 0) {
            numBuckets = Streams.stream((Iterator)new FileUtils.AdaptingIterator(FileUtils.listFiles((FileSystem)dir.getFs(), (Path)dir.getPath(), (boolean)true, (PathFilter)AcidUtils.bucketFileFilter))).map(f -> AcidUtils.parseBucketId(f.getPath())).collect(Collectors.toSet()).size();
        }
        List<String> createQueries = this.getCreateQueries(tmpTableName, table, tmpTablePath.toString());
        List<String> compactionQueries = this.getCompactionQueries(table, context.getPartition(), tmpTableName, numBuckets, context.getCompactionInfo().orderByClause);
        List<String> dropQueries = this.getDropQueries(tmpTableName);
        this.runCompactionQueries(conf, tmpTableName, context.getCompactionInfo(), Lists.newArrayList((Object[])new Path[]{tmpTablePath}), createQueries, compactionQueries, dropQueries, table.getParameters());
        return true;
    }

    private List<String> getCreateQueries(String fullName, Table t, String tmpTableLocation) {
        return Lists.newArrayList((Object[])new String[]{new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.REBALANCE, false).setOperation(CompactionQueryBuilder.Operation.CREATE).setResultTableName(fullName).setSourceTab(t).setLocation(tmpTableLocation).build()});
    }

    private List<String> getCompactionQueries(Table t, Partition p, String tmpName, int numberOfBuckets, String orderByClause) {
        return Lists.newArrayList((Object[])new String[]{new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.REBALANCE, false).setOperation(CompactionQueryBuilder.Operation.INSERT).setResultTableName(tmpName).setNumberOfBuckets(numberOfBuckets).setOrderByClause(orderByClause).setSourceTab(t).setSourcePartition(p).build()});
    }

    private List<String> getDropQueries(String tmpTableName) {
        return Lists.newArrayList((Object[])new String[]{new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.REBALANCE, false).setOperation(CompactionQueryBuilder.Operation.DROP).setResultTableName(tmpTableName).build()});
    }
}

