/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.MetaStoreThread;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.OptionalCompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorFactory;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.RemoteCompactorThread;
import org.apache.hadoop.hive.ql.txn.compactor.StatsUpdater;
import org.apache.hadoop.hive.ql.txn.compactor.service.CompactionExecutorFactory;
import org.apache.hadoop.hive.ql.txn.compactor.service.CompactionService;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker
extends RemoteCompactorThread
implements MetaStoreThread {
    private static final String CLASS_NAME = Worker.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static long SLEEP_TIME_MAX;
    private static long SLEEP_TIME;
    private String workerName;
    private final CompactorFactory compactorFactory;
    static StatsUpdater statsUpdater;

    public Worker() {
        this.compactorFactory = CompactorFactory.getInstance();
    }

    public Worker(CompactorFactory compactorFactory) {
        this.compactorFactory = compactorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info("Starting Worker thread");
        boolean genericStats = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_COMPACTOR_GATHER_STATS);
        boolean mrStats = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_MR_COMPACTOR_GATHER_STATS);
        long timeout = this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_WORKER_TIMEOUT, TimeUnit.MILLISECONDS);
        long nextSleep = SLEEP_TIME;
        ExecutorService executor = this.getTimeoutHandlingExecutor();
        try {
            do {
                long startedAt = System.currentTimeMillis();
                boolean err = false;
                boolean launchedJob = false;
                Future<Boolean> singleRun = executor.submit(() -> this.findNextCompactionAndExecute(genericStats, mrStats));
                try {
                    launchedJob = singleRun.get(timeout, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException te) {
                    LOG.info("Timeout during executing compaction", (Throwable)te);
                    singleRun.cancel(true);
                    executor.shutdownNow();
                    executor = this.getTimeoutHandlingExecutor();
                    err = true;
                }
                catch (ExecutionException e) {
                    LOG.info("Exception during executing compaction", (Throwable)e);
                    err = true;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable t) {
                    err = true;
                }
                this.doPostLoopActions(System.currentTimeMillis() - startedAt);
                if (!(launchedJob && !err || this.stop.get())) {
                    Thread.sleep(nextSleep);
                }
                long l = nextSleep = err ? nextSleep * 2L : SLEEP_TIME;
                if (nextSleep <= SLEEP_TIME_MAX) continue;
                nextSleep = SLEEP_TIME_MAX;
            } while (!this.stop.get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            LOG.error("Caught an exception in the main loop of compactor worker, exiting.", t);
        }
        finally {
            if (Thread.currentThread().isInterrupted()) {
                LOG.info("Interrupt received, Worker is shutting down.");
            }
            executor.shutdownNow();
            if (this.msc != null) {
                this.msc.close();
            }
        }
    }

    @Override
    public void init(AtomicBoolean stop) throws Exception {
        super.init(stop);
        SLEEP_TIME = this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_WORKER_SLEEP_TIME, TimeUnit.MILLISECONDS);
        SLEEP_TIME_MAX = this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_WORKER_MAX_SLEEP_TIME, TimeUnit.MILLISECONDS);
        this.workerName = this.getWorkerId();
        this.setName(this.workerName);
    }

    private ExecutorService getTimeoutHandlingExecutor() {
        return Executors.newSingleThreadExecutor(r -> {
            Thread masterThread = Thread.currentThread();
            Thread t = new Thread(masterThread.getThreadGroup(), r, masterThread.getName() + "_timeout_executor");
            t.setDaemon(masterThread.isDaemon());
            t.setPriority(masterThread.getPriority());
            return t;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @VisibleForTesting
    protected Boolean findNextCompactionAndExecute(boolean collectGenericStats, boolean collectMrStats) {
        boolean success;
        CompactionService compactionService;
        Table table;
        CompactionInfo ci;
        block32: {
            Boolean bl;
            PerfLogger perfLogger = SessionState.getPerfLogger(false);
            String workerMetric = null;
            ci = null;
            table = null;
            compactionService = null;
            success = false;
            if (this.msc == null) {
                try {
                    this.msc = HiveMetaStoreUtils.getHiveMetastoreClient((HiveConf)this.conf);
                }
                catch (Exception e) {
                    LOG.error("Failed to connect to HMS", (Throwable)e);
                    return false;
                }
            }
            try {
                FindNextCompactRequest findNextCompactRequest = new FindNextCompactRequest();
                findNextCompactRequest.setWorkerId(this.workerName);
                findNextCompactRequest.setWorkerVersion(this.runtimeVersion);
                findNextCompactRequest.setPoolName(this.getPoolName());
                ci = CompactionInfo.optionalCompactionInfoStructToInfo((OptionalCompactionInfoStruct)this.msc.findNextCompact(findNextCompactRequest));
                LOG.info("Processing compaction request {}", (Object)ci);
                if (ci == null) {
                    Boolean bl2 = false;
                    return bl2;
                }
                if (this.runtimeVersion == null && ci.initiatorVersion != null || this.runtimeVersion != null && !this.runtimeVersion.equals(ci.initiatorVersion)) {
                    LOG.warn("Worker and Initiator versions do not match. Worker: v{}, Initiator: v{}", (Object)this.runtimeVersion, (Object)ci.initiatorVersion);
                }
                if (StringUtils.isBlank((CharSequence)this.getPoolName()) && StringUtils.isNotBlank((CharSequence)ci.poolName)) {
                    LOG.warn("A timed out copmaction pool entry ({}) is picked up by one of the default compaction pool workers.", (Object)ci);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getPoolName()) && StringUtils.isNotBlank((CharSequence)ci.poolName) && !this.getPoolName().equals(ci.poolName)) {
                    LOG.warn("The returned compaction request ({}) belong to a different pool. Although the worker is assigned to the {} pool, it will process the request.", (Object)ci, (Object)this.getPoolName());
                }
                CompactorUtil.checkInterrupt(CLASS_NAME);
                if (MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_EXT_ON)) {
                    workerMetric = "compaction_worker_cycle_" + (ci.type != null ? ci.type.toString().toLowerCase() : null);
                    perfLogger.perfLogBegin(CLASS_NAME, workerMetric);
                }
                table = this.resolveTable(ci);
                if (table != null) break block31;
                ci.errorMessage = "Unable to find table " + ci.getFullTableName() + ", assuming it was dropped and moving on.";
                LOG.warn(ci.errorMessage + " Compaction info: {}", (Object)ci);
                this.msc.markRefused(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                bl = false;
            }
            catch (IOException | TException t) {
                LOG.error("Caught an exception in the main loop of compactor worker " + this.workerName, t);
                this.markFailed(ci, t.getMessage());
                if (this.msc != null) {
                    this.msc.close();
                    this.msc = null;
                }
                break block32;
            }
            catch (Throwable t) {
                LOG.error("Caught an exception in the main loop of compactor worker " + this.workerName, t);
                break block32;
            }
            finally {
                if (workerMetric != null && MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_EXT_ON)) {
                    perfLogger.perfLogEnd(CLASS_NAME, workerMetric);
                }
            }
            if (workerMetric != null && MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_EXT_ON)) {
                perfLogger.perfLogEnd(CLASS_NAME, workerMetric);
            }
            return bl;
            {
                block31: {
                    catch (MetaException e) {
                        LOG.error("Unexpected error during resolving table. Compaction info: " + String.valueOf(ci), (Throwable)e);
                        ci.errorMessage = e.getMessage();
                        this.msc.markFailed(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                        Boolean bl3 = false;
                        if (workerMetric != null && MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_EXT_ON)) {
                            perfLogger.perfLogEnd(CLASS_NAME, workerMetric);
                        }
                        return bl3;
                    }
                }
                CompactorUtil.checkInterrupt(CLASS_NAME);
                compactionService = CompactionExecutorFactory.createExecutor(this.conf, this.msc, this.compactorFactory, table, collectGenericStats, collectMrStats);
                try {
                    success = compactionService.compact(table, ci);
                }
                catch (Throwable e) {
                    LOG.error("Caught exception while trying to compact " + String.valueOf(ci) + ". Marking failed to avoid repeated failures", e);
                    this.markFailed(ci, e.getMessage());
                    if (CompactorUtil.runJobAsSelf(ci.runAs)) {
                        compactionService.cleanupResultDirs(ci);
                    }
                    LOG.info("Cleaning as user " + ci.runAs);
                    UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)ci.runAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
                    CompactionService finalCompactionService = compactionService;
                    CompactionInfo finalCi = ci;
                    ugi.doAs(() -> {
                        finalCompactionService.cleanupResultDirs(finalCi);
                        return null;
                    });
                    try {
                        FileSystem.closeAllForUGI((UserGroupInformation)ugi);
                    }
                    catch (IOException ex) {
                        LOG.error("Could not clean up file-system handles for UGI: " + String.valueOf(ugi), e);
                    }
                }
            }
            if (workerMetric != null && MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_EXT_ON)) {
                perfLogger.perfLogEnd(CLASS_NAME, workerMetric);
            }
        }
        if (success && compactionService.computeStats()) {
            statsUpdater.gatherStats(this.conf, ci, table.getParameters(), CompactorUtil.runJobAsSelf(ci.runAs) ? ci.runAs : table.getOwner(), CompactorUtil.getCompactorJobQueueName(this.conf, ci, table), this.msc);
        }
        return success;
    }

    private void markFailed(CompactionInfo ci, String errorMessage) {
        if (ci == null) {
            LOG.warn("CompactionInfo client was null. Could not mark failed");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            ci.errorMessage = errorMessage;
        }
        if (this.msc == null) {
            LOG.warn("Metastore client was null. Could not mark failed: {}", (Object)ci);
            return;
        }
        try {
            this.msc.markFailed(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
        }
        catch (Throwable t) {
            LOG.error("Caught an exception while trying to mark compaction {} as failed: {}", (Object)ci, (Object)t);
        }
    }

    private String getWorkerId() {
        StringBuilder name = new StringBuilder(this.hostName);
        name.append("-");
        name.append(this.getId());
        return name.toString();
    }

    static {
        statsUpdater = new StatsUpdater();
    }
}

